/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Vector;

public class Straight {
    public Vector position;
    public Vector direction;

    public Straight(Vector position, Vector direction) {
        this.position = position;
        this.direction = direction;
    }

    public Straight(PrecisionPoint point1, PrecisionPoint point2) {
        this(new Vector(point1), new Vector(point1, point2));
    }

    public boolean intersects(Straight other) {
        return this.direction.getDotProduct(other.direction.getOrthogonalComplement()) != 0.0;
    }

    public Vector getIntersection(Straight other) {
        if (!this.intersects(other)) {
            return null;
        }
        Vector q = other.position;
        Vector b = other.direction;
        Vector aOC = this.direction.getOrthogonalComplement();
        Vector bOC = b.getOrthogonalComplement();
        double[] intersection = new double[]{(q.getDotProduct(bOC) * this.direction.x - this.position.getDotProduct(aOC) * b.x) / this.direction.getDotProduct(bOC), (q.getDotProduct(bOC) * this.direction.y - this.position.getDotProduct(aOC) * b.y) / this.direction.getDotProduct(bOC)};
        return new Vector(intersection[0], intersection[1]);
    }

    public double getAngle(Straight other) {
        return this.direction.getAngle(other.direction);
    }

    public Vector getProjection(Vector vector) {
        Vector s = this.getIntersection(new Straight(vector, this.direction.getOrthogonalComplement()));
        return s;
    }

    public double getDistance(Vector vector) {
        Vector s = this.getProjection(vector);
        return s.getSubtracted(vector).getLength();
    }

    public boolean contains(Vector vector) {
        return this.getDistance(vector) == 0.0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Straight)) {
            return false;
        }
        Straight otherStraight = (Straight)other;
        return this.contains(otherStraight.position) && this.isParallelTo(otherStraight);
    }

    public boolean isParallelTo(Straight other) {
        return this.direction.isParallelTo(other.direction);
    }

    public int hashCode() {
        return this.position.hashCode() + this.direction.hashCode();
    }
}

