/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportUtilities;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class ConnectionLayer
extends FreeformLayer {
    int antialias = -1;
    protected ConnectionRouter connectionRouter;

    public ConnectionLayer() {
        this.setClippingStrategy(new ConnectionLayerClippingStrategy(this));
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        if (figure instanceof Connection && this.getConnectionRouter() != null) {
            ((Connection)figure).setConnectionRouter(this.getConnectionRouter());
        }
    }

    public ConnectionRouter getConnectionRouter() {
        return this.connectionRouter;
    }

    public void paint(Graphics graphics) {
        if (this.antialias != -1) {
            graphics.setAntialias(this.antialias);
        }
        super.paint(graphics);
    }

    public void remove(IFigure figure) {
        if (figure instanceof Connection) {
            ((Connection)figure).setConnectionRouter(null);
        }
        super.remove(figure);
    }

    public void setConnectionRouter(ConnectionRouter router) {
        this.connectionRouter = router;
        Figure.FigureIterator iter = new Figure.FigureIterator(this);
        while (iter.hasNext()) {
            IFigure figure = iter.nextFigure();
            if (!(figure instanceof Connection)) continue;
            ((Connection)figure).setConnectionRouter(router);
        }
    }

    public void setAntialias(int antialias) {
        this.antialias = antialias;
    }

    public static class ConnectionLayerClippingStrategy
    implements IClippingStrategy {
        private ConnectionLayer connectionLayer = null;

        protected ConnectionLayerClippingStrategy(ConnectionLayer connectionLayer) {
            this.connectionLayer = connectionLayer;
        }

        public Rectangle[] getClip(IFigure figure) {
            Rectangle[] clipRect = null;
            clipRect = figure instanceof Connection ? this.getEdgeClippingRectangle((Connection)figure) : new Rectangle[]{this.getNodeClippingRectangle(figure)};
            int i = 0;
            while (i < clipRect.length) {
                figure.translateToRelative(clipRect[i]);
                ++i;
            }
            return clipRect;
        }

        protected Rectangle[] getEdgeClippingRectangle(Connection connection) {
            Viewport nearestEnclosingTargetViewport;
            Viewport nearestEnclosingSourceViewport;
            IFigure targetFigure;
            Rectangle clipRect = this.getAbsoluteBoundsAsCopy(connection);
            ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
            ConnectionAnchor targetAnchor = connection.getTargetAnchor();
            if (sourceAnchor == null || sourceAnchor.getOwner() == null || targetAnchor == null || targetAnchor.getOwner() == null) {
                return new Rectangle[]{clipRect};
            }
            IFigure sourceFigure = sourceAnchor.getOwner();
            Viewport nearestEnclosingCommonViewport = ViewportUtilities.getNearestCommonViewport(sourceFigure, targetFigure = targetAnchor.getOwner());
            if (nearestEnclosingCommonViewport == null) {
                return new Rectangle[]{clipRect};
            }
            if (nearestEnclosingCommonViewport != this.getRootViewport()) {
                clipRect.intersect(this.getNodeClippingRectangle(nearestEnclosingCommonViewport.getParent()));
            }
            if ((nearestEnclosingSourceViewport = ViewportUtilities.getNearestEnclosingViewport(sourceFigure)) != (nearestEnclosingTargetViewport = ViewportUtilities.getNearestEnclosingViewport(targetFigure))) {
                Rectangle sourceClipRect = this.getAbsoluteBoundsAsCopy(sourceFigure);
                if (nearestEnclosingSourceViewport != nearestEnclosingCommonViewport) {
                    this.clipAtViewports(sourceClipRect, ViewportUtilities.getViewportsPath(nearestEnclosingSourceViewport, nearestEnclosingCommonViewport, false));
                }
                Rectangle targetClipRect = this.getAbsoluteBoundsAsCopy(targetFigure);
                if (nearestEnclosingTargetViewport != nearestEnclosingCommonViewport) {
                    this.clipAtViewports(targetClipRect, ViewportUtilities.getViewportsPath(nearestEnclosingTargetViewport, nearestEnclosingCommonViewport, false));
                }
                PointList absolutePointsAsCopy = this.getAbsolutePointsAsCopy(connection);
                boolean sourceAnchorVisible = sourceClipRect.contains(absolutePointsAsCopy.getFirstPoint());
                boolean targetAnchorVisible = targetClipRect.contains(absolutePointsAsCopy.getLastPoint());
                if (!sourceAnchorVisible || !targetAnchorVisible) {
                    return new Rectangle[0];
                }
                return new Rectangle[]{clipRect};
            }
            return new Rectangle[]{clipRect};
        }

        protected Rectangle getNodeClippingRectangle(IFigure figure) {
            Rectangle clipRect = this.getAbsoluteBoundsAsCopy(figure);
            List enclosingViewportsPath = ViewportUtilities.getViewportsPath(ViewportUtilities.getNearestEnclosingViewport(figure), this.getRootViewport(), false);
            this.clipAtViewports(clipRect, enclosingViewportsPath);
            return clipRect;
        }

        protected void clipAtViewports(Rectangle clipRect, List enclosingViewportsPath) {
            Iterator iterator = enclosingViewportsPath.iterator();
            while (iterator.hasNext()) {
                clipRect.intersect(this.getAbsoluteViewportClientAreaAsCopy((Viewport)iterator.next()));
            }
        }

        protected Viewport getRootViewport() {
            return ViewportUtilities.getNearestEnclosingViewport(this.connectionLayer);
        }

        protected PointList getAbsolutePointsAsCopy(Connection connection) {
            PointList points = connection.getPoints().getCopy();
            connection.translateToAbsolute(points);
            return points;
        }

        protected Rectangle getAbsoluteViewportClientAreaAsCopy(Viewport viewport) {
            Rectangle absoluteClientArea = viewport.getClientArea();
            viewport.translateToParent(absoluteClientArea);
            viewport.translateToAbsolute(absoluteClientArea);
            return absoluteClientArea;
        }

        protected Rectangle getAbsoluteBoundsAsCopy(IFigure figure) {
            Rectangle absoluteFigureBounds = figure.getBounds().getCopy();
            figure.translateToAbsolute(absoluteFigureBounds);
            return absoluteFigureBounds;
        }
    }
}

