/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;

public final class MoreCollections {
    public static <T> List<T> asArrayList(T firstItem) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(firstItem);
        return list;
    }

    public static <T> List<T> asArrayList(T firstItem, List<T> moreItems) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(firstItem);
        list.addAll(moreItems);
        return list;
    }

    public static <T> @Nullable T findFirstMatching(List<T> list, Predicate<T> filter) {
        for (T e : list) {
            if (!filter.test(e)) continue;
            return e;
        }
        return null;
    }

    public static <T> @Nullable T findLastElement(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return MoreCollections.getLastElement(list);
    }

    public static <T> T getElementAt(List<T> list, int index) {
        if (index < 0) {
            return list.get(list.size() + index);
        }
        return list.get(index);
    }

    public static <T> T getLastElement(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> Collection<T> nullToEmpty(@Nullable Collection<T> coll) {
        return coll == null ? Collections.emptyList() : coll;
    }

    public static <T> List<T> nullToEmpty(@Nullable List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    public static <T> T removeLastElement(List<T> list) {
        return list.remove(list.size() - 1);
    }

    public static String toStringWithIndex(List<?> list) {
        if (list.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        int l = list.size();
        while (i < l) {
            Object e = list.get(i);
            sb.append(i).append(':').append((Object)(e == list ? "(this List)" : e));
            if (i == l - 1) break;
            sb.append(", ");
            ++i;
        }
        return sb.append(']').toString();
    }

    public static <T> List<T> noNulls(@Nullable List<T> coll) {
        return coll == null || coll.isEmpty() ? Collections.emptyList() : coll.stream().filter(Objects::nonNull).toList();
    }

    private MoreCollections() {
    }
}

