/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.Gson;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtilsCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInnerToTopRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveInstanceMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GetRefactorEditHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JdtDomModels;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;

public class MoveHandler {
    public static final String DEFAULT_PACKAGE_DISPLAYNAME = "(default package)";

    public static MoveDestinationsResponse getMoveDestinations(MoveParams moveParams) {
        if (moveParams == null || StringUtils.isBlank((CharSequence)moveParams.moveKind)) {
            return null;
        }
        if ("moveResource".equalsIgnoreCase(moveParams.moveKind)) {
            return MoveHandler.getPackageDestinations(moveParams.sourceUris);
        }
        if ("moveInstanceMethod".equalsIgnoreCase(moveParams.moveKind)) {
            return MoveHandler.getInstanceMethodDestinations(moveParams.params);
        }
        return null;
    }

    public static MoveDestinationsResponse getPackageDestinations(String[] documentUris) {
        if (documentUris == null) {
            documentUris = new String[]{};
        }
        LinkedHashSet<IJavaProject> targetProjects = new LinkedHashSet<IJavaProject>();
        LinkedHashSet<IPackageFragment> selectedPackages = new LinkedHashSet<IPackageFragment>();
        String[] stringArray = documentUris;
        int n = documentUris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
            IPath filePath = ResourceUtils.filePathFromURI(uri);
            if (unit != null && filePath != null) {
                selectedPackages.add((IPackageFragment)unit.getParent());
                IJavaProject currentProject = unit.getJavaProject();
                if ("jdt.ls-java-project".equals(currentProject.getProject().getName())) {
                    IProject belongedProject = MoveHandler.findNearestProject(filePath);
                    if (belongedProject != null) {
                        targetProjects.add(JavaCore.create((IProject)belongedProject));
                    }
                } else {
                    targetProjects.add(currentProject);
                }
            }
            ++n2;
        }
        PreferenceManager manager = JavaLanguageServerPlugin.getPreferencesManager();
        Collection<IPath> workspaceRoots = manager.getPreferences().getRootPaths();
        for (IPath workspaceRoot : workspaceRoots) {
            ProjectUtils.getVisibleProjects(workspaceRoot).forEach(project -> {
                if (ProjectUtils.isJavaProject(project)) {
                    targetProjects.add(JavaCore.create((IProject)project));
                }
            });
            String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(workspaceRoot);
            IProject invisibleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
            if (!invisibleProject.exists() || !ProjectUtils.isJavaProject(invisibleProject)) continue;
            targetProjects.add(JavaCore.create((IProject)invisibleProject));
        }
        LinkedHashSet<PackageNode> packageNodes = new LinkedHashSet<PackageNode>();
        try {
            for (IJavaProject project2 : targetProjects) {
                IClasspathEntry[] iClasspathEntryArray = project2.getRawClasspath();
                int n3 = iClasspathEntryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClasspathEntry entry = iClasspathEntryArray[n4];
                    if (entry.getEntryKind() == 3) {
                        IPackageFragmentRoot[] roots;
                        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project2.findPackageFragmentRoots(entry);
                        int n5 = roots.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IPackageFragmentRoot root = iPackageFragmentRootArray[n6];
                            if (!root.isArchive() && !root.isExternal()) {
                                IJavaElement[] fragments;
                                IJavaElement[] iJavaElementArray = fragments = root.getChildren();
                                int n7 = fragments.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IJavaElement fragment = iJavaElementArray[n8];
                                    if (fragment instanceof IPackageFragment) {
                                        IPackageFragment pkg = (IPackageFragment)fragment;
                                        PackageNode packageNode = PackageNode.createPackageNode(pkg);
                                        packageNode.setParentOfSelectedFile(selectedPackages.contains(fragment));
                                        packageNodes.add(packageNode);
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to list Java packages for source paths.", e);
        }
        return new MoveDestinationsResponse(packageNodes.toArray(new PackageNode[0]));
    }

    private static MethodDeclaration getSelectedMethodDeclaration(ICompilationUnit unit, CodeActionParams params) {
        CompilationUnit ast = CodeActionHandler.getASTRoot(unit);
        if (ast == null) {
            return null;
        }
        int start = DiagnosticsHelper.getStartOffset(unit, params.getRange());
        int end = DiagnosticsHelper.getEndOffset(unit, params.getRange());
        InnovationContext context = new InnovationContext(unit, start, end - start);
        context.setASTRoot(ast);
        ASTNode node = context.getCoveredNode();
        if (node == null) {
            node = context.getCoveringNode();
        }
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        if (node instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)node;
            return methodDeclaration;
        }
        return null;
    }

    private static MoveDestinationsResponse getInstanceMethodDestinations(CodeActionParams params) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return new MoveDestinationsResponse("Cannot find the compilation unit associated with " + params.getTextDocument().getUri());
        }
        MethodDeclaration methodDeclaration = MoveHandler.getSelectedMethodDeclaration(unit, params);
        if (methodDeclaration == null) {
            return new MoveDestinationsResponse("The selected element is not a method.");
        }
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        if (methodBinding == null || !(methodBinding.getJavaElement() instanceof IMethod)) {
            return new MoveDestinationsResponse("The selected element is not a method.");
        }
        IMethod method = (IMethod)methodBinding.getJavaElement();
        MoveInstanceMethodProcessor processor = new MoveInstanceMethodProcessor(method, PreferenceManager.getCodeGenerationSettings(unit));
        MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
        CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 2);
        try {
            check.run((IProgressMonitor)new NullProgressMonitor());
            if (check.getStatus().hasFatalError()) {
                return new MoveDestinationsResponse(check.getStatus().getMessageMatchingSeverity(4));
            }
            IVariableBinding[] possibleTargets = processor.getPossibleTargets();
            Object[] targets = (JdtDomModels.LspVariableBinding[])Stream.of(possibleTargets).map(target -> new JdtDomModels.LspVariableBinding((IVariableBinding)target)).toArray(JdtDomModels.LspVariableBinding[]::new);
            return new MoveDestinationsResponse(targets);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            return new MoveDestinationsResponse("Cannot find any target to move the method to.");
        }
    }

    private static IProject findNearestProject(IPath filePath) {
        List projects = Stream.of(ProjectUtils.getAllProjects()).filter(ProjectUtils::isJavaProject).sorted(new Comparator<IProject>(){

            @Override
            public int compare(IProject p1, IProject p2) {
                return p2.getLocation().toOSString().length() - p1.getLocation().toOSString().length();
            }
        }).collect(Collectors.toList());
        for (IProject project : projects) {
            if (!project.getLocation().isPrefixOf(filePath)) continue;
            return project;
        }
        return null;
    }

    public static GetRefactorEditHandler.RefactorWorkspaceEdit move(MoveParams moveParams, IProgressMonitor monitor) {
        if (moveParams == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("moveParams should not be empty.");
        }
        try {
            if ("moveResource".equalsIgnoreCase(moveParams.moveKind)) {
                String targetUri = null;
                if (moveParams.destination instanceof String) {
                    String dest;
                    targetUri = dest = (String)moveParams.destination;
                } else {
                    String json = moveParams.destination == null ? null : new Gson().toJson(moveParams.destination);
                    PackageNode packageNode = JSONUtility.toLsp4jModel(json, PackageNode.class);
                    if (packageNode == null) {
                        return new GetRefactorEditHandler.RefactorWorkspaceEdit("Invalid destination object: " + String.valueOf(moveParams.destination));
                    }
                    targetUri = packageNode.uri;
                }
                return MoveHandler.moveCU(moveParams.sourceUris, targetUri, moveParams.updateReferences, monitor);
            }
            if ("moveInstanceMethod".equalsIgnoreCase(moveParams.moveKind)) {
                String json = moveParams.destination == null ? null : new Gson().toJson(moveParams.destination);
                JdtDomModels.LspVariableBinding variableBinding = JSONUtility.toLsp4jModel(json, JdtDomModels.LspVariableBinding.class);
                if (variableBinding == null) {
                    return new GetRefactorEditHandler.RefactorWorkspaceEdit("Invalid destination object: " + String.valueOf(moveParams.destination));
                }
                return MoveHandler.moveInstanceMethod(moveParams.params, variableBinding, monitor);
            }
            if ("moveStaticMember".equalsIgnoreCase(moveParams.moveKind)) {
                String typeName = MoveHandler.resolveTargetTypeName(moveParams.destination);
                return MoveHandler.moveStaticMember(moveParams.params, typeName, monitor);
            }
            if ("moveTypeToNewFile".equalsIgnoreCase(moveParams.moveKind)) {
                return MoveHandler.moveTypeToNewFile(moveParams.params, monitor);
            }
            if ("moveTypeToClass".equalsIgnoreCase(moveParams.moveKind)) {
                String typeName = MoveHandler.resolveTargetTypeName(moveParams.destination);
                return MoveHandler.moveTypeToClass(moveParams.params, typeName, monitor);
            }
        }
        catch (IllegalArgumentException e) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit(e.getMessage());
        }
        return new GetRefactorEditHandler.RefactorWorkspaceEdit("Unsupported move operation.");
    }

    private static String resolveTargetTypeName(Object destinationObj) throws IllegalArgumentException {
        if (destinationObj instanceof String) {
            String dest = (String)destinationObj;
            return dest;
        }
        String json = destinationObj == null ? null : new Gson().toJson(destinationObj);
        SymbolInformation destination = JSONUtility.toLsp4jModel(json, SymbolInformation.class);
        if (destination == null) {
            throw new IllegalArgumentException("Invalid destination object: " + String.valueOf(destinationObj));
        }
        Object typeName = destination.getName();
        if (StringUtils.isNotBlank((CharSequence)destination.getContainerName())) {
            typeName = destination.getContainerName() + "." + destination.getName();
        }
        return typeName;
    }

    private static GetRefactorEditHandler.RefactorWorkspaceEdit moveCU(String[] sourceUris, String targetUri, boolean updateReferences, IProgressMonitor monitor) {
        URI targetURI = JDTUtils.toURI(targetUri);
        if (targetURI == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move the files because of illegal uri '" + targetUri + "'.");
        }
        ArrayList<ICompilationUnit> elements = new ArrayList<ICompilationUnit>();
        String[] stringArray = sourceUris;
        int n = sourceUris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
            if (unit != null) {
                elements.add(unit);
            }
            ++n2;
        }
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Moving File...", (int)100);
        try {
            IResource[] resources = ReorgUtilsCore.getResources(elements);
            IJavaElement[] javaElements = ReorgUtilsCore.getJavaElements(elements);
            IContainer[] targetContainers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(targetURI);
            if (targetContainers == null || targetContainers.length == 0) {
                GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move the files because cannot find the target folder '" + targetUri + "' in the workspace.");
                return refactorWorkspaceEdit;
            }
            if (!(resources != null && resources.length != 0 || javaElements != null && javaElements.length != 0)) {
                GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move the files because cannot find any resources or Java elements associated with the files.");
                return refactorWorkspaceEdit;
            }
            Arrays.sort(targetContainers, (a, b) -> a.getFullPath().toPortableString().length() - b.getFullPath().toPortableString().length());
            IJavaElement targetElement = null;
            IContainer[] iContainerArray = targetContainers;
            int n3 = targetContainers.length;
            int n4 = 0;
            while (n4 < n3) {
                IContainer container = iContainerArray[n4];
                targetElement = JavaCore.create((IResource)container);
                if (targetElement instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)targetElement;
                    targetElement = root.getPackageFragment("");
                }
                if (targetElement != null) break;
                ++n4;
            }
            if (targetElement == null) {
                JavaLanguageServerPlugin.logError("Failed to move the files because cannot find the package associated with the path '" + targetUri + "'.");
                GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move the files because cannot find the package associated with the path '" + targetUri + "'.");
                return refactorWorkspaceEdit;
            }
            IReorgDestination packageDestination = ReorgDestinationFactory.createDestination(targetElement);
            WorkspaceEdit edit = MoveHandler.move(resources, javaElements, packageDestination, updateReferences, (IProgressMonitor)submonitor);
            if (edit == null) {
                GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Cannot enable move operation.");
                return refactorWorkspaceEdit;
            }
            GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit(edit);
            return refactorWorkspaceEdit;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to move the files.", e);
            GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move the files because of " + e.toString());
            return refactorWorkspaceEdit;
        }
        finally {
            submonitor.done();
        }
    }

    public static WorkspaceEdit move(IResource[] resources, IJavaElement[] javaElements, IReorgDestination destination, boolean updateReferences, IProgressMonitor monitor) throws CoreException {
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy((IResource[])resources, (IJavaElement[])javaElements);
        if (policy.canEnable()) {
            JavaMoveProcessor processor = new JavaMoveProcessor(policy);
            MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
            processor.setDestination(destination);
            processor.setUpdateReferences(updateReferences);
            processor.setReorgQueries(new IReorgQueries(){
                private final IConfirmQuery yesQuery = new IConfirmQuery(){

                    public boolean confirm(String question) throws OperationCanceledException {
                        return true;
                    }

                    public boolean confirm(String question, Object[] elements) throws OperationCanceledException {
                        return true;
                    }
                };

                public IConfirmQuery createSkipQuery(String queryTitle, int queryID) {
                    return this.yesQuery;
                }

                public IConfirmQuery createYesNoQuery(String queryTitle, boolean allowCancel, int queryID) {
                    return this.yesQuery;
                }

                public IConfirmQuery createYesYesToAllNoNoToAllQuery(String queryTitle, boolean allowCancel, int queryID) {
                    return this.yesQuery;
                }
            });
            CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 6);
            CreateChangeOperation create = new CreateChangeOperation(check, 4);
            create.run(monitor);
            Change change = create.getChange();
            return ChangeUtil.convertToWorkspaceEdit(change);
        }
        return null;
    }

    private static GetRefactorEditHandler.RefactorWorkspaceEdit moveInstanceMethod(CodeActionParams params, JdtDomModels.LspVariableBinding destination, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move instance method because cannot find the compilation unit associated with " + params.getTextDocument().getUri());
        }
        MethodDeclaration methodDeclaration = MoveHandler.getSelectedMethodDeclaration(unit, params);
        if (methodDeclaration == null || destination == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move instance method because no method is selected or no destination is specified.");
        }
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        if (methodBinding == null || !(methodBinding.getJavaElement() instanceof IMethod)) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move instance method because the selected element is not a method.");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Moving instance method...", (int)100);
        IMethod method = (IMethod)methodBinding.getJavaElement();
        MoveInstanceMethodProcessor processor = new MoveInstanceMethodProcessor(method, PreferenceManager.getCodeGenerationSettings(unit));
        MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
        CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 2);
        try {
            check.run((IProgressMonitor)subMonitor.split(20));
            if (check.getStatus().getSeverity() >= 4) {
                JavaLanguageServerPlugin.logError("Failed to execute the 'move' refactoring.");
                JavaLanguageServerPlugin.logError(check.getStatus().toString());
                GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move instance method. Reason: " + check.getStatus().toString());
                return refactorWorkspaceEdit;
            }
            IVariableBinding[] possibleTargets = processor.getPossibleTargets();
            Optional<IVariableBinding> target = Stream.of(possibleTargets).filter(possibleTarget -> Objects.equals(possibleTarget.getKey(), lspVariableBinding.bindingKey)).findFirst();
            if (target.isPresent()) {
                processor.setTarget(target.get());
                processor.setDeprecateDelegates(false);
                processor.setInlineDelegator(true);
                processor.setRemoveDelegator(true);
                check = new CheckConditionsOperation((Refactoring)refactoring, 4);
                check.run((IProgressMonitor)subMonitor.split(60));
                if (check.getStatus().getSeverity() >= 4) {
                    JavaLanguageServerPlugin.logError("Failed to execute the 'move' refactoring.");
                    JavaLanguageServerPlugin.logError(check.getStatus().toString());
                    GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move instance method. Reason: " + check.getStatus().toString());
                    return refactorWorkspaceEdit;
                }
                Change change = processor.createChange((IProgressMonitor)subMonitor.split(20));
                GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit(ChangeUtil.convertToWorkspaceEdit(change));
                return refactorWorkspaceEdit;
            }
            GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move instance method because cannot find the target " + destination.name);
            return refactorWorkspaceEdit;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move instance method because of " + e.toString());
            return refactorWorkspaceEdit;
        }
        finally {
            subMonitor.done();
        }
    }

    private static GetRefactorEditHandler.RefactorWorkspaceEdit moveStaticMember(CodeActionParams params, String destinationTypeName, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move static member because cannot find the compilation unit associated with " + params.getTextDocument().getUri());
        }
        BodyDeclaration bodyDeclaration = MoveHandler.getSelectedMemberDeclaration(unit, params);
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)bodyDeclaration;
            elements.add(methodDecl.resolveBinding().getJavaElement());
        } else if (bodyDeclaration instanceof FieldDeclaration) {
            FieldDeclaration fieldDecl = (FieldDeclaration)bodyDeclaration;
            for (Object fragment : fieldDecl.fragments()) {
                elements.add(((VariableDeclarationFragment)fragment).resolveBinding().getJavaElement());
            }
        } else if (bodyDeclaration instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)bodyDeclaration;
            elements.add(typeDecl.resolveBinding().getJavaElement());
        }
        IMember[] members = (IMember[])elements.stream().filter(IMember.class::isInstance).map(IMember.class::cast).toArray(IMember[]::new);
        return MoveHandler.moveStaticMember(members, destinationTypeName, monitor);
    }

    private static GetRefactorEditHandler.RefactorWorkspaceEdit moveStaticMember(IMember[] members, String destinationTypeName, IProgressMonitor monitor) {
        CodeGenerationSettings codeGenerationSettings;
        if (members.length == 0 || destinationTypeName == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move static member because no members are selected or no destination is specified.");
        }
        ITypeRoot iTypeRoot = members[0].getTypeRoot();
        if (iTypeRoot instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)iTypeRoot;
            codeGenerationSettings = PreferenceManager.getCodeGenerationSettings(unit);
        } else {
            codeGenerationSettings = PreferenceManager.getCodeGenerationSettings((IResource)members[0].getJavaProject().getProject());
        }
        CodeGenerationSettings settings = codeGenerationSettings;
        MoveStaticMembersProcessor processor = new MoveStaticMembersProcessor(members, settings);
        MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
        CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 2);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Moving static members...", (int)100);
        try {
            check.run((IProgressMonitor)subMonitor.split(20));
            if (check.getStatus().getSeverity() >= 4) {
                JavaLanguageServerPlugin.logError("Failed to execute the 'move' refactoring.");
                JavaLanguageServerPlugin.logError(check.getStatus().toString());
            }
            processor.setDestinationTypeFullyQualifiedName(destinationTypeName);
            processor.setDeprecateDelegates(false);
            check = new CheckConditionsOperation((Refactoring)refactoring, 4);
            check.run((IProgressMonitor)subMonitor.split(60));
            if (check.getStatus().getSeverity() >= 4) {
                JavaLanguageServerPlugin.logError("Failed to execute the 'move' refactoring.");
                JavaLanguageServerPlugin.logError(check.getStatus().toString());
                GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move static member. Reason: " + check.getStatus().toString());
                return refactorWorkspaceEdit;
            }
            Change change = processor.createChange((IProgressMonitor)subMonitor.split(20));
            GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit(ChangeUtil.convertToWorkspaceEdit(change));
            return refactorWorkspaceEdit;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            GetRefactorEditHandler.RefactorWorkspaceEdit refactorWorkspaceEdit = new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move static member because of " + e.toString());
            return refactorWorkspaceEdit;
        }
        finally {
            subMonitor.done();
        }
    }

    private static GetRefactorEditHandler.RefactorWorkspaceEdit moveTypeToNewFile(CodeActionParams params, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move type to new file because cannot find the compilation unit associated with " + params.getTextDocument().getUri());
        }
        IType type = MoveHandler.getSelectedType(unit, params);
        if (type == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move type to new file because no type is selected.");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Moving type to new file...", (int)100);
        try {
            MoveInnerToTopRefactoring refactoring = new MoveInnerToTopRefactoring(type, PreferenceManager.getCodeGenerationSettings(unit));
            CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 6);
            check.run((IProgressMonitor)subMonitor.split(50));
            if (check.getStatus().getSeverity() >= 4) {
                JavaLanguageServerPlugin.logError("Failed to execute the 'move' refactoring.");
                JavaLanguageServerPlugin.logError(check.getStatus().toString());
                return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move type to new file. Reason: " + check.getStatus().toString());
            }
            Change change = refactoring.createChange((IProgressMonitor)subMonitor.split(50));
            return new GetRefactorEditHandler.RefactorWorkspaceEdit(ChangeUtil.convertToWorkspaceEdit(change));
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move type to new file because of " + e.toString());
        }
        catch (OperationCanceledException e) {
            return null;
        }
    }

    private static GetRefactorEditHandler.RefactorWorkspaceEdit moveTypeToClass(CodeActionParams params, String destinationTypeName, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move type to another class because cannot find the compilation unit associated with " + params.getTextDocument().getUri());
        }
        IType type = MoveHandler.getSelectedType(unit, params);
        if (type == null) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move type to another class because no type is selected.");
        }
        try {
            if (RefactoringAvailabilityTesterCore.isMoveStaticAvailable((IMember)type)) {
                return MoveHandler.moveStaticMember(new IMember[]{type}, destinationTypeName, monitor);
            }
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Moving non-static type to another class is not supported.");
        }
        catch (JavaModelException e) {
            return new GetRefactorEditHandler.RefactorWorkspaceEdit("Failed to move type to another class. Reason: " + e.toString());
        }
    }

    private static IType getSelectedType(ICompilationUnit unit, CodeActionParams params) {
        AbstractTypeDeclaration typeDeclaration = MoveHandler.getSelectedTypeDeclaration(unit, params);
        return typeDeclaration == null ? null : (IType)typeDeclaration.resolveBinding().getJavaElement();
    }

    private static BodyDeclaration getSelectedMemberDeclaration(ICompilationUnit unit, CodeActionParams params) {
        CompilationUnit ast = CodeActionHandler.getASTRoot(unit);
        if (ast == null) {
            return null;
        }
        int start = DiagnosticsHelper.getStartOffset(unit, params.getRange());
        int end = DiagnosticsHelper.getEndOffset(unit, params.getRange());
        InnovationContext context = new InnovationContext(unit, start, end - start);
        context.setASTRoot(ast);
        ASTNode node = context.getCoveredNode();
        if (node == null) {
            node = context.getCoveringNode();
        }
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        if (node != null && (node instanceof MethodDeclaration || node instanceof FieldDeclaration || node instanceof AbstractTypeDeclaration) && JdtFlags.isStatic((BodyDeclaration)((BodyDeclaration)node))) {
            return (BodyDeclaration)node;
        }
        return null;
    }

    private static AbstractTypeDeclaration getSelectedTypeDeclaration(ICompilationUnit unit, CodeActionParams params) {
        int start = DiagnosticsHelper.getStartOffset(unit, params.getRange());
        int end = DiagnosticsHelper.getEndOffset(unit, params.getRange());
        InnovationContext context = new InnovationContext(unit, start, end - start);
        context.setASTRoot(CodeActionHandler.getASTRoot(unit));
        ASTNode node = context.getCoveredNode();
        if (node == null) {
            node = context.getCoveringNode();
        }
        while (node != null && !(node instanceof AbstractTypeDeclaration)) {
            node = node.getParent();
        }
        return (AbstractTypeDeclaration)node;
    }

    public static class MoveDestinationsResponse {
        public String errorMessage;
        public Object[] destinations;

        public MoveDestinationsResponse(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public MoveDestinationsResponse(Object[] destinations) {
            this.destinations = destinations;
        }
    }

    public static class MoveParams {
        String moveKind;
        String[] sourceUris;
        CodeActionParams params;
        Object destination;
        boolean updateReferences;

        public MoveParams(String moveKind, String[] sourceUris) {
            this(moveKind, sourceUris, null);
        }

        public MoveParams(String moveKind, String[] sourceUris, CodeActionParams params) {
            this(moveKind, sourceUris, params, null, true);
        }

        public MoveParams(String moveKind, String[] sourceUris, Object destination, boolean updateReferences) {
            this(moveKind, sourceUris, null, destination, updateReferences);
        }

        public MoveParams(String moveKind, CodeActionParams params, Object destination, boolean updateReferences) {
            this(moveKind, null, params, destination, updateReferences);
        }

        public MoveParams(String moveKind, String[] sourceUris, CodeActionParams params, Object destination, boolean updateReferences) {
            this.moveKind = moveKind;
            this.sourceUris = sourceUris;
            this.params = params;
            this.destination = destination;
            this.updateReferences = updateReferences;
        }
    }

    public static class PackageNode {
        public String displayName;
        public String uri;
        public String path;
        public String project;
        public boolean isDefaultPackage;
        public boolean isParentOfSelectedFile = false;

        public PackageNode(String displayName, String uri, String path, String project, boolean isDefaultPackage) {
            this.displayName = displayName;
            this.uri = uri;
            this.path = path;
            this.project = project;
            this.isDefaultPackage = isDefaultPackage;
        }

        public void setParentOfSelectedFile(boolean isParentOfSelectedFile) {
            this.isParentOfSelectedFile = isParentOfSelectedFile;
        }

        public static PackageNode createPackageNode(IPackageFragment fragment) {
            if (fragment == null) {
                return null;
            }
            String projectName = fragment.getJavaProject().getProject().getName();
            String uri = null;
            if (fragment.getResource() != null) {
                uri = JDTUtils.getFileURI(fragment.getResource());
            }
            if (fragment.isDefaultPackage()) {
                return new PackageNode(MoveHandler.DEFAULT_PACKAGE_DISPLAYNAME, uri, fragment.getPath().toPortableString(), projectName, true);
            }
            return new PackageNode(fragment.getElementName(), uri, fragment.getPath().toPortableString(), projectName, false);
        }
    }
}

