/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix.helper;

import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;

public final class LambdaQueries {
    private LambdaQueries() {
    }

    public static Expression getSingleExpressionFromLambdaBody(Block lambdaBody) {
        Expression expression;
        if (lambdaBody.statements().size() != 1) {
            return null;
        }
        Statement singleStatement = (Statement)lambdaBody.statements().get(0);
        if (singleStatement instanceof ReturnStatement) {
            return ((ReturnStatement)singleStatement).getExpression();
        }
        if (singleStatement instanceof ExpressionStatement && LambdaQueries.isValidLambdaExpressionBody(expression = ((ExpressionStatement)singleStatement).getExpression())) {
            return expression;
        }
        return null;
    }

    private static boolean isValidLambdaExpressionBody(Expression expression) {
        PrefixExpression.Operator operator;
        if (expression instanceof Assignment || expression instanceof ClassInstanceCreation || expression instanceof MethodInvocation || expression instanceof PostfixExpression || expression instanceof SuperMethodInvocation) {
            return true;
        }
        return expression instanceof PrefixExpression && ((operator = ((PrefixExpression)expression).getOperator()) == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT);
    }
}

