/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.IndexedItemBitSetMap;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterable;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassificationBag<K, V> {
    @NotNull
    private final OrderedSet<V> items;
    @NotNull
    final IndexedItemBitSetMap<K, V> bag;
    @Nullable
    final CollectionHost<V> host;

    public ClassificationBag(Function<V, K> mapper) {
        this(0, mapper);
    }

    public ClassificationBag(@NotNull Function<V, K> mapper, @Nullable CollectionHost<V> host) {
        this(0, mapper, host);
    }

    public ClassificationBag(int capacity, @NotNull Function<V, K> mapper) {
        this(capacity, mapper, null);
    }

    public ClassificationBag(int capacity, @NotNull Function<V, K> mapper, @Nullable CollectionHost<V> host) {
        this.host = host;
        this.items = new OrderedSet(capacity, new CollectionHost<V>(){

            @Override
            public void adding(int index, @Nullable V v, @Nullable Object v2) {
                if (ClassificationBag.this.host != null && !ClassificationBag.this.host.skipHostUpdate()) {
                    ClassificationBag.this.host.adding(index, v, v2);
                }
                if (v != null) {
                    ClassificationBag.this.bag.addItem(v, index);
                }
            }

            @Override
            public Object removing(int index, @Nullable V v) {
                if (ClassificationBag.this.host != null && !ClassificationBag.this.host.skipHostUpdate()) {
                    ClassificationBag.this.host.removing(index, v);
                }
                if (v != null) {
                    ClassificationBag.this.bag.removeItem(v, index);
                }
                return null;
            }

            @Override
            public void clearing() {
                if (ClassificationBag.this.host != null && !ClassificationBag.this.host.skipHostUpdate()) {
                    ClassificationBag.this.host.clearing();
                }
                ClassificationBag.this.bag.clear();
            }

            @Override
            public void addingNulls(int index) {
                if (ClassificationBag.this.host != null && !ClassificationBag.this.host.skipHostUpdate()) {
                    ClassificationBag.this.host.addingNulls(index);
                }
            }

            @Override
            public boolean skipHostUpdate() {
                return false;
            }

            @Override
            public int getIteratorModificationCount() {
                return ClassificationBag.this.getModificationCount();
            }
        });
        this.bag = new IndexedItemBitSetMap<K, V>(mapper);
    }

    @NotNull
    public OrderedSet<V> getItems() {
        return this.items;
    }

    public int getModificationCount() {
        return this.items.getModificationCount();
    }

    public boolean add(@Nullable V item) {
        return this.items.add(item);
    }

    public boolean remove(@Nullable V item) {
        return this.items.remove(item);
    }

    public boolean remove(int index) {
        return this.items.removeIndex(index);
    }

    public boolean contains(@Nullable V item) {
        return this.items.contains(item);
    }

    public boolean containsCategory(@Nullable K category) {
        BitSet bitSet = (BitSet)this.bag.get(category);
        return bitSet != null && !bitSet.isEmpty();
    }

    @Nullable
    public BitSet getCategorySet(@Nullable K category) {
        return (BitSet)this.bag.get(category);
    }

    public int getCategoryCount(@Nullable K category) {
        BitSet bitSet = (BitSet)this.bag.get(category);
        return bitSet == null ? 0 : bitSet.cardinality();
    }

    @NotNull
    public Map<K, BitSet> getCategoryMap() {
        return this.bag;
    }

    public void clear() {
        this.items.clear();
    }

    @SafeVarargs
    @NotNull
    public final <X> ReversibleIterable<X> getCategoryItems(@NotNull Class<? extends X> xClass, K ... categories) {
        return new IndexedIterable(this.items.getConcurrentModsIndexedProxy(), new BitSetIterable(this.categoriesBitSet(categories), false));
    }

    @NotNull
    public final <X> ReversibleIterable<X> getCategoryItems(@NotNull Class<? extends X> xClass, @NotNull Collection<? extends K> categories) {
        return new IndexedIterable(this.items.getConcurrentModsIndexedProxy(), new BitSetIterable(this.categoriesBitSet(categories), false));
    }

    @NotNull
    public final <X> ReversibleIterable<X> getCategoryItems(@NotNull Class<? extends X> xClass, @NotNull BitSet bitSet) {
        return new IndexedIterable(this.items.getConcurrentModsIndexedProxy(), new BitSetIterable(bitSet, false));
    }

    @SafeVarargs
    @NotNull
    public final <X> ReversibleIterable<X> getCategoryItemsReversed(@NotNull Class<? extends X> xClass, K ... categories) {
        return new IndexedIterable(this.items.getConcurrentModsIndexedProxy(), new BitSetIterable(this.categoriesBitSet(categories), true));
    }

    @NotNull
    public final <X> ReversibleIterable<X> getCategoryItemsReversed(@NotNull Class<? extends X> xClass, @NotNull Collection<? extends K> categories) {
        return new IndexedIterable(this.items.getConcurrentModsIndexedProxy(), new BitSetIterable(this.categoriesBitSet(categories), true));
    }

    @NotNull
    public final <X> ReversibleIterable<X> getCategoryItemsReversed(@NotNull Class<? extends X> xClass, @NotNull BitSet bitSet) {
        return new IndexedIterable(this.items.getConcurrentModsIndexedProxy(), new BitSetIterable(bitSet, true));
    }

    @SafeVarargs
    @NotNull
    public final BitSet categoriesBitSet(K ... categories) {
        BitSet bitSet = new BitSet();
        for (K category : categories) {
            BitSet bitSet1 = (BitSet)this.bag.get(category);
            if (bitSet1 == null) continue;
            bitSet.or(bitSet1);
        }
        return bitSet;
    }

    @NotNull
    public final BitSet categoriesBitSet(@NotNull Collection<? extends K> categories) {
        BitSet bitSet = new BitSet();
        for (K category : categories) {
            BitSet bitSet1 = (BitSet)this.bag.get(category);
            if (bitSet1 == null) continue;
            bitSet.or(bitSet1);
        }
        return bitSet;
    }
}

