/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

final class KotlinSerializableFilter
implements IFilter {
    private int lineNumber = -2;

    KotlinSerializableFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (context.getClassName().endsWith("$Companion") && methodNode.name.equals("<init>") && methodNode.desc.equals("()V")) {
            this.lineNumber = -1;
            for (AbstractInsnNode i : methodNode.instructions) {
                if (i.getType() != 15) continue;
                this.lineNumber = ((LineNumberNode)i).line;
                return;
            }
            return;
        }
        if (methodNode.name.equals("serializer") && methodNode.desc.equals("()Lkotlinx/serialization/KSerializer;")) {
            Matcher matcher = new Matcher();
            if (matcher.matchSerializer(methodNode, this.lineNumber) || matcher.matchCachedSerializer(methodNode, context.getClassName())) {
                output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
            }
            return;
        }
        if ((methodNode.access & 0x1000) == 0) {
            return;
        }
        if (methodNode.name.startsWith("write$Self$")) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
            return;
        }
        if ((methodNode.name.equals("get$cachedSerializer") || methodNode.name.startsWith("_init_$_anonymous_") || methodNode.name.startsWith("_childSerializers$_anonymous_")) && methodNode.desc.equals("()Lkotlinx/serialization/KSerializer;")) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
            return;
        }
        Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        if (argumentTypes.length > 1 && argumentTypes[argumentTypes.length - 1].getClassName().equals("kotlinx.serialization.internal.SerializationConstructorMarker")) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public boolean matchSerializer(MethodNode methodNode, int lineNumber) {
            this.cursor = methodNode.instructions.getFirst();
            this.nextIs(178);
            FieldInsnNode getStaticInstruction = (FieldInsnNode)this.cursor;
            if (this.cursor == null) {
                return false;
            }
            AbstractInsnNode lineNumberInstruction = this.cursor.getPrevious();
            this.nextIsType(192, "kotlinx/serialization/KSerializer");
            this.nextIs(176);
            return this.cursor != null && getStaticInstruction.name.equals("INSTANCE") && lineNumberInstruction instanceof LineNumberNode && (lineNumber == -1 || lineNumber == ((LineNumberNode)lineNumberInstruction).line);
        }

        private boolean matchCachedSerializer(MethodNode methodNode, String className) {
            this.firstIsALoad0(methodNode);
            this.nextIsInvoke(183, className, "get$cachedSerializer", "()Lkotlinx/serialization/KSerializer;");
            this.nextIs(176);
            return this.cursor != null;
        }
    }
}

