/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.workspace.GradleClasspathContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

final class DefaultGradleClasspathContainer
extends GradleClasspathContainer {
    private final IPath containerPath;
    private final IClasspathEntry[] classpathEntries;

    public DefaultGradleClasspathContainer(IPath containerPath, List<IClasspathEntry> classpathEntries) {
        this.containerPath = (IPath)Preconditions.checkNotNull((Object)containerPath);
        this.classpathEntries = (IClasspathEntry[])Iterables.toArray(classpathEntries, IClasspathEntry.class);
    }

    public String getDescription() {
        return CoreMessages.ClasspathContainer_Label;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.classpathEntries;
    }

    public int getKind() {
        return 1;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.classpathEntries);
        result = 31 * result + this.containerPath.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultGradleClasspathContainer other = (DefaultGradleClasspathContainer)obj;
        return Arrays.equals(this.classpathEntries, other.classpathEntries) && this.containerPath.equals((Object)other.containerPath);
    }
}

