/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.javac.JavacProblem;
import org.eclipse.jface.text.Position;

public class JavacProblemConverter {
    private static final String COMPILER_ERR_MISSING_RET_STMT = "compiler.err.missing.ret.stmt";
    private static final String COMPILER_WARN_NON_SERIALIZABLE_INSTANCE_FIELD = "compiler.warn.non.serializable.instance.field";
    private static final String COMPILER_WARN_MISSING_SVUID = "compiler.warn.missing.SVUID";
    private final CompilerOptions compilerOptions;
    private final Context context;
    private final Map<JavaFileObject, JCTree.JCCompilationUnit> units = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();

    public JavacProblemConverter(Map<String, String> options, Context context) {
        this(new CompilerOptions(options), context);
    }

    public JavacProblemConverter(CompilerOptions options, Context context) {
        this.compilerOptions = options;
        this.context = context;
    }

    /*
     * Unable to fully structure code
     */
    public JavacProblem createJavacProblem(Diagnostic<? extends JavaFileObject> diagnostic) {
        nestedDiagnostic = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, JCDiagnostic.class);
        if (nestedDiagnostic == null || !diagnostic.getCode().equals("compiler.err.invalid.permits.clause")) ** GOTO lbl-1000
        if (nestedDiagnostic.getSource() == diagnostic.getSource()) ** GOTO lbl-1000
        if (nestedDiagnostic.getSource() == null && (var5_3 = JavacProblemConverter.findSymbol(nestedDiagnostic)) instanceof Symbol.ClassSymbol) {
            classSymbol = var5_3;
            ** if (classSymbol.sourcefile != diagnostic.getSource()) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl11
        }
lbl-1000:
        // 3 sources

        {
            v0 = false;
        }
lbl11:
        // 2 sources

        useNestedDiagnostic = v0;
        problemId = this.toProblemId((Diagnostic<? extends JavaFileObject>)(useNestedDiagnostic != false ? nestedDiagnostic : diagnostic));
        if (problemId == -1) {
            return null;
        }
        severity = this.toSeverity(problemId, diagnostic);
        if (severity == 256 || severity == 32) {
            return null;
        }
        diagnosticPosition = this.getDiagnosticPosition(diagnostic, this.context, problemId);
        if (diagnosticPosition == null) {
            return null;
        }
        if (diagnosticPosition.length == 0) {
            ++diagnosticPosition.length;
            try {
                documentText = JavacProblemConverter.loadDocumentText(diagnostic);
                if (diagnosticPosition.getOffset() >= documentText.length() || documentText.charAt(diagnosticPosition.getOffset()) == '\n') {
                    --diagnosticPosition.offset;
                }
            }
            catch (IOException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
        }
        arguments = this.getDiagnosticStringArguments(diagnostic);
        return new JavacProblem(diagnostic.getSource().getName().toCharArray(), diagnostic.getMessage(Locale.getDefault()), diagnostic.getCode(), problemId, arguments, severity, diagnosticPosition.getOffset(), diagnosticPosition.getOffset() + Math.max(diagnosticPosition.getLength() - 1, 0), (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber());
    }

    private static Symbol.ClassSymbol findSymbol(Diagnostic<?> diagnostic) {
        Symbol.TypeSymbol typeSymbol;
        Symbol.ClassSymbol res = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Symbol.ClassSymbol.class);
        if (res != null) {
            return res;
        }
        Type.ClassType type = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Type.ClassType.class);
        if (type != null && (typeSymbol = type.tsym) instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)typeSymbol;
            return classSym;
        }
        return null;
    }

    private Position getDiagnosticPosition(Diagnostic<? extends JavaFileObject> diagnostic, Context context, int problemId) {
        if (diagnostic.getCode().contains(".dc") || "compiler.warn.proc.messager".equals(diagnostic.getCode())) {
            JCTree.JCCompilationUnit unit;
            JCDiagnostic.DiagnosticPosition returnType;
            JCTree.JCMethodDecl methodDecl;
            JCDiagnostic jcDiagnostic;
            JCDiagnostic.DiagnosticPosition method;
            if (problemId == -1610612265) {
                Position position;
                Object typeParam;
                Tree tree;
                String message = diagnostic.getMessage(Locale.ENGLISH);
                TreePath path = this.getTreePath(diagnostic);
                if (message.startsWith("no @param for <") && (tree = path.getLeaf()) instanceof JCTree.JCMethodDecl) {
                    method = (JCTree.JCMethodDecl)tree;
                    typeParam = message.substring("no @param for <".length(), message.length() - 1);
                    position = ((JCTree.JCMethodDecl)method).getTypeParameters().stream().filter(arg_0 -> JavacProblemConverter.lambda$getDiagnosticPosition$0((String)typeParam, arg_0)).map(paramDecl -> new Position(paramDecl.getPreferredPosition(), paramDecl.getName().toString().length())).findFirst().orElse(null);
                    if (position != null) {
                        return position;
                    }
                }
                if (message.startsWith("no @param for ") && (typeParam = path.getLeaf()) instanceof JCTree.JCMethodDecl) {
                    method = (JCTree.JCMethodDecl)typeParam;
                    String param = message.substring("no @param for ".length());
                    position = ((JCTree.JCMethodDecl)method).getParameters().stream().filter(paramDecl -> param.equals(paramDecl.getName().toString())).map(paramDecl -> new Position(paramDecl.getPreferredPosition(), paramDecl.getName().toString().length())).findFirst().orElse(null);
                    if (position != null) {
                        return position;
                    }
                }
            }
            if (problemId == -1610612261 && diagnostic instanceof JCDiagnostic && (method = (jcDiagnostic = (JCDiagnostic)diagnostic).getDiagnosticPosition()) instanceof JCTree.JCMethodDecl && (methodDecl = (JCTree.JCMethodDecl)method).getReturnType() != null) {
                returnType = methodDecl.getReturnType();
                unit = this.units.get(jcDiagnostic.getSource());
                if (unit != null) {
                    int end = unit.endPositions.getEndPos((JCTree)returnType);
                    int start = ((JCTree)returnType).getStartPosition();
                    return new Position(start, end - start);
                }
            }
            if (problemId == -1610612259 && diagnostic instanceof JCDiagnostic && (returnType = (jcDiagnostic = (JCDiagnostic)diagnostic).getDiagnosticPosition()) instanceof JCTree.JCMethodDecl && (methodDecl = (JCTree.JCMethodDecl)returnType).getThrows() != null && !((List)methodDecl.getThrows()).isEmpty()) {
                JCTree ex = (JCTree)((List)methodDecl.getThrows()).head;
                unit = this.units.get(jcDiagnostic.getSource());
                if (unit != null) {
                    int end = unit.endPositions.getEndPos(ex);
                    int start = ex.getStartPosition();
                    return new Position(start, end - start);
                }
            }
            return this.getDefaultPosition(diagnostic);
        }
        if (diagnostic instanceof JCDiagnostic) {
            JCTree.JCMethodInvocation method;
            JCTree.JCMethodInvocation methodInvocation;
            Tree tree;
            Object switchExpr2;
            Tree element;
            Tree methodDecl3;
            TreePath current;
            Object parens;
            TreePath diagnosticPath;
            EndPosTable endPos;
            Symbol.VarSymbol varSymbol;
            JCDiagnostic.DiagnosticPosition ex;
            JCDiagnostic jcDiagnostic = (JCDiagnostic)diagnostic;
            if (problemId == 67109266 && (ex = jcDiagnostic.getDiagnosticPosition()) instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl method2 = (JCTree.JCMethodDecl)ex;
                int start = method2.getPreferredPosition();
                JCTree.JCCompilationUnit unit = this.units.get(jcDiagnostic.getSource());
                if (unit != null) {
                    int end = method2.thrown.stream().mapToInt(unit.endPositions::getEndPos).max().orElse(-1);
                    if (end >= 0) {
                        return new Position(start, end - start);
                    }
                }
            }
            if ((problemId == 33554513 || problemId == 0x20000033) && (varSymbol = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Symbol.VarSymbol.class)) != null) {
                return new Position(varSymbol.pos, ((Name)varSymbol.getSimpleName()).length());
            }
            JCTree.JCCompilationUnit unit = this.units.get(diagnostic.getSource());
            EndPosTable endPosTable = endPos = unit != null ? unit.endPositions : null;
            if (diagnosticPath != null) {
                if (problemId == 67108979) {
                    for (diagnosticPath = diagnosticPath.getParentPath(); diagnosticPath != null && diagnosticPath.getLeaf() instanceof JCTree.JCExpression && !(diagnosticPath.getLeaf() instanceof JCTree.JCMethodInvocation); diagnosticPath = diagnosticPath.getParentPath()) {
                    }
                    Tree tree2 = diagnosticPath.getLeaf();
                    if (tree2 instanceof JCTree.JCMethodInvocation) {
                        JCTree.JCMethodInvocation method3 = (JCTree.JCMethodInvocation)tree2;
                        selectExpr = method3.getMethodSelect();
                        if (selectExpr instanceof JCTree.JCIdent) {
                            JCTree.JCIdent methodNameIdent = (JCTree.JCIdent)selectExpr;
                            int start = methodNameIdent.getStartPosition();
                            int end = methodNameIdent.getEndPosition(endPos);
                            return new Position(start, end - start);
                        }
                        if (selectExpr instanceof JCTree.JCFieldAccess) {
                            JCTree.JCFieldAccess methodFieldAccess = (JCTree.JCFieldAccess)selectExpr;
                            int start = methodFieldAccess.getPreferredPosition() + 1;
                            int end = methodFieldAccess.getEndPosition(endPos);
                            return new Position(start, end - start);
                        }
                    }
                } else if (problemId == 0x800008D || problemId == 0x800008C) {
                    for (diagnosticPath = this.getTreePath(jcDiagnostic); diagnosticPath != null && !(diagnosticPath.getLeaf() instanceof JCTree.JCClassDecl); diagnosticPath = diagnosticPath.getParentPath()) {
                    }
                } else if (problemId == 16779068) {
                    selectExpr = diagnosticPath.getLeaf();
                    if (selectExpr instanceof JCTree.JCClassDecl) {
                        classDecl = (JCTree.JCClassDecl)selectExpr;
                        diagnosticPath = JavacTrees.instance(context).getPath(this.units.get(jcDiagnostic.getSource()), ((JCTree.JCClassDecl)classDecl).getExtendsClause());
                    }
                } else if (problemId == 16779069) {
                    selectExpr = diagnosticPath.getLeaf();
                    if (selectExpr instanceof JCTree.JCClassDecl) {
                        classDecl = (JCTree.JCClassDecl)selectExpr;
                        Symbol.ClassSymbol sym = JavacProblemConverter.getDiagnosticArgumentByType(jcDiagnostic, Symbol.ClassSymbol.class);
                        Optional<JCTree.JCExpression> jcExpr = ((JCTree.JCClassDecl)classDecl).getImplementsClause().stream().filter(expression -> {
                            if (!(expression instanceof JCTree.JCIdent)) return false;
                            JCTree.JCIdent jcIdent = (JCTree.JCIdent)expression;
                            if (!jcIdent.sym.equals(sym)) return false;
                            return true;
                        }).findFirst();
                        if (jcExpr.isPresent()) {
                            diagnosticPath = JavacTrees.instance(context).getPath(this.units.get(jcDiagnostic.getSource()), jcExpr.get());
                        }
                    }
                } else {
                    if (problemId == 0x1000011 && (classDecl = diagnosticPath.getLeaf()) instanceof JCTree.JCFieldAccess) {
                        JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)classDecl;
                        int start = fieldAccess.getStartPosition();
                        int end = fieldAccess.getEndPosition(endPos);
                        return new Position(start, end - start);
                    }
                    if (problemId == 67109498) {
                        Tree tree3 = diagnosticPath.getParentPath() == null ? null : (tree = diagnosticPath.getParentPath().getParentPath() == null ? null : diagnosticPath.getParentPath().getParentPath().getLeaf());
                        if (tree != null && unit != null && tree instanceof JCTree.JCMethodDecl) {
                            JCTree.JCMethodDecl methodDecl2 = (JCTree.JCMethodDecl)tree;
                            try {
                                int startPosition = methodDecl2.pos;
                                int lastParenthesisIndex = unit.getSourceFile().getCharContent(false).toString().indexOf(41, startPosition);
                                return new Position(startPosition, lastParenthesisIndex - startPosition + 1);
                            }
                            catch (IOException startPosition) {}
                        }
                    } else {
                        if (problemId == 67108969 && diagnosticPath.getParentPath() != null && (tree = diagnosticPath.getParentPath().getLeaf()) instanceof JCTree.JCReturn) {
                            JCTree.JCReturn returnStmt = (JCTree.JCReturn)tree;
                            return this.getPositionByNodeRangeOnly(jcDiagnostic, returnStmt);
                        }
                        if (problemId == 67109268 && diagnosticPath.getParentPath() != null && (tree = diagnosticPath.getParentPath().getLeaf()) instanceof JCTree.JCMethodDecl) {
                            JCTree.JCMethodDecl methodDecl3 = (JCTree.JCMethodDecl)tree;
                            return this.getPositionByNodeRangeOnly(jcDiagnostic, methodDecl3.getReturnType());
                        }
                        if (problemId == 16778523 || problemId == 16778522) {
                            return this.getPositionByNodeRangeOnly(jcDiagnostic, (JCTree)diagnosticPath.getLeaf());
                        }
                        if (problemId == 1073743531 && (tree = diagnosticPath.getLeaf()) instanceof JCTree.JCSwitchExpression) {
                            JCTree.JCExpression jCExpression;
                            JCTree.JCSwitchExpression switchExpr2 = (JCTree.JCSwitchExpression)tree;
                            JCTree.JCExpression methodDecl2 = switchExpr2.selector;
                            if (methodDecl2 instanceof JCTree.JCParens) {
                                parens = (JCTree.JCParens)methodDecl2;
                                jCExpression = ((JCTree.JCParens)parens).expr;
                            } else {
                                jCExpression = switchExpr2.selector;
                            }
                            return this.getPositionByNodeRangeOnly(jcDiagnostic, jCExpression);
                        }
                        if (problemId == 0x8000082 && diagnosticPath.getParentPath() != null && (diagnosticPath.getParentPath().getLeaf() instanceof JCTree.JCNewClass || !(diagnosticPath.getLeaf() instanceof JCTree.JCNewClass) && diagnosticPath.getParentPath().getLeaf() instanceof JCTree.JCVariableDecl)) {
                            return this.getPositionByNodeRangeOnly(jcDiagnostic, (JCTree)diagnosticPath.getParentPath().getLeaf());
                        }
                    }
                }
            }
            for (current = diagnosticPath; current != null && (methodDecl3 = current.getLeaf()) instanceof JCTree; current = current.getParentPath()) {
                JCTree tree4 = (JCTree)methodDecl3;
                if (endPos == null || TreeInfo.getEndPos(tree4, endPos) != -1) break;
            }
            Tree tree5 = current != null ? current.getLeaf() : (element = (switchExpr2 = jcDiagnostic.getDiagnosticPosition()) instanceof Tree ? (tree = (Tree)switchExpr2) : null);
            if (problemId == 0x4000074 && element instanceof JCTree.JCFieldAccess && diagnosticPath != null && (switchExpr2 = diagnosticPath.getParentPath().getLeaf()) instanceof JCTree.JCMethodInvocation && (methodInvocation = (JCTree.JCMethodInvocation)switchExpr2).getMethodSelect() == element) {
                element = methodInvocation;
            }
            if (problemId == 0x1000002 && element instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)element;
                if (jcDiagnostic.getArgs().length > 0 && jcDiagnostic.getArgs()[0] instanceof PackageElement) {
                    element = fieldAccess.getExpression();
                }
            }
            if (problemId == 67109622 && element instanceof JCTree.JCClassDecl) {
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)element;
                if (jcDiagnostic.getArgs().length >= 2 && (parens = jcDiagnostic.getArgs()[1]) instanceof Symbol.MethodSymbol) {
                    Symbol.MethodSymbol method4 = (Symbol.MethodSymbol)parens;
                    element = classDecl.getMembers().stream().filter(JCTree.JCMethodDecl.class::isInstance).map(JCTree.JCMethodDecl.class::cast).filter(m -> m.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)).filter(m -> method.name.equals(m.getName())).findFirst().map(Tree.class::cast).orElse(element);
                }
            }
            if (problemId == 0x4000064 && element instanceof JCTree.JCMethodInvocation && (parens = (method = (JCTree.JCMethodInvocation)element).getMethodSelect()) instanceof JCTree.JCIdent) {
                JCTree.JCIdent name = (JCTree.JCIdent)parens;
                element = name;
            }
            if (element != null) {
                Tree tree6 = element;
                Objects.requireNonNull(tree6);
                Tree tree7 = tree6;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JCTree.JCTypeApply.class, JCTree.JCClassDecl.class, JCTree.JCVariableDecl.class, JCTree.JCMethodDecl.class, JCTree.JCIdent.class, JCTree.JCMethodInvocation.class, JCTree.JCFieldAccess.class}, (Tree)tree7, n)) {
                    case 0: {
                        JCTree.JCTypeApply jcTypeApply = (JCTree.JCTypeApply)tree7;
                        return this.getPositionByNodeRangeOnly(jcDiagnostic, jcTypeApply.clazz);
                    }
                    case 1: {
                        JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)tree7;
                        return this.getDiagnosticPosition(jcDiagnostic, jcClassDecl);
                    }
                    case 2: {
                        JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)tree7;
                        return this.getDiagnosticPosition(jcDiagnostic, jcVariableDecl);
                    }
                    case 3: {
                        JCTree.JCMethodDecl jcMethodDecl = (JCTree.JCMethodDecl)tree7;
                        return this.getDiagnosticPosition(jcDiagnostic, jcMethodDecl, problemId);
                    }
                    case 4: {
                        JCTree.JCIdent jcIdent = (JCTree.JCIdent)tree7;
                        return this.getPositionByNodeRangeOnly(jcDiagnostic, jcIdent);
                    }
                    case 5: {
                        JCTree.JCMethodInvocation methodInvocation2 = (JCTree.JCMethodInvocation)tree7;
                        return this.getPositionByNodeRangeOnly(jcDiagnostic, methodInvocation2);
                    }
                    case 6: {
                        JCTree.JCFieldAccess jcFieldAccess = (JCTree.JCFieldAccess)tree7;
                        if (JavacProblemConverter.getDiagnosticArgumentByType(jcDiagnostic, Kinds.KindName.class) == Kinds.KindName.PACKAGE || JavacProblemConverter.getDiagnosticArgumentByType(jcDiagnostic, Symbol.PackageSymbol.class) != null) break;
                        return new Position(jcFieldAccess.getPreferredPosition() + 1, jcFieldAccess.getIdentifier().length());
                    }
                }
                Position result = this.getMissingReturnMethodDiagnostic(jcDiagnostic, context);
                if (result != null) {
                    return result;
                }
                if (jcDiagnostic.getStartPosition() == jcDiagnostic.getEndPosition()) {
                    return this.getPositionUsingScanner(jcDiagnostic);
                }
            }
        }
        return this.getDefaultPosition(diagnostic);
    }

    private Position getPositionByNodeRangeOnly(Diagnostic<?> jcDiagnostic, JCTree jcTree) {
        int startPosition = jcTree.getStartPosition();
        if (startPosition != -1) {
            JCTree.JCCompilationUnit trackedUnit = this.units.get(jcDiagnostic.getSource());
            if (trackedUnit != null && trackedUnit.endPositions != null) {
                int endPosition = jcTree.getEndPosition(trackedUnit.endPositions);
                if (endPosition != -1) {
                    return new Position(startPosition, endPosition - startPosition);
                }
            } else if (jcTree instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)jcTree;
                return new Position(startPosition, ident.getName().length());
            }
        }
        return this.getDefaultPosition(jcDiagnostic);
    }

    private Position getDiagnosticPosition(JCDiagnostic jcDiagnostic, JCTree.JCMethodDecl jcMethodDecl, int problemId) {
        boolean includeLastParenthesis;
        int startPosition = (int)jcDiagnostic.getPosition();
        boolean bl = includeLastParenthesis = problemId == 67109265 || problemId == 67109270 || problemId == 67109269 || problemId == 67109273 || problemId == 67109274;
        if (startPosition != -1) {
            try {
                JCTree.JCCompilationUnit unit;
                String name = jcMethodDecl.getName().toString();
                if (includeLastParenthesis && (unit = this.units.get(jcDiagnostic.getSource())) != null) {
                    int lastParenthesisIndex = unit.getSourceFile().getCharContent(false).toString().indexOf(41, startPosition);
                    return new Position(startPosition, lastParenthesisIndex - startPosition + 1);
                }
                return this.getDiagnosticPosition(name, startPosition, jcDiagnostic);
            }
            catch (IOException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.getDefaultPosition(jcDiagnostic);
    }

    private Position getDefaultPosition(Diagnostic<?> diagnostic) {
        if (diagnostic.getPosition() >= 0L) {
            int start = (int)Math.min(diagnostic.getPosition(), diagnostic.getStartPosition());
            int end = (int)Math.max(diagnostic.getEndPosition(), (long)start);
            return new Position(start, end - start);
        }
        Symbol.ClassSymbol end = JavacProblemConverter.findSymbol(diagnostic);
        if (end instanceof Symbol.ClassSymbol) {
            JCTree.JCClassDecl classDeclaration;
            int startPosition;
            JCTree declaration;
            Symbol.ClassSymbol classSymbol = end;
            JCTree.JCCompilationUnit unit = this.units.get(classSymbol.sourcefile);
            if (unit != null && (declaration = TreeInfo.declarationFor(classSymbol, unit)) instanceof JCTree.JCClassDecl && (startPosition = (classDeclaration = (JCTree.JCClassDecl)declaration).getPreferredPosition()) != -1) {
                return new Position(startPosition, classDeclaration.getSimpleName().length());
            }
        }
        return null;
    }

    private Position getPositionUsingScanner(JCDiagnostic jcDiagnostic) {
        try {
            int preferedOffset = jcDiagnostic.getDiagnosticPosition().getPreferredPosition();
            DiagnosticSource source = jcDiagnostic.getDiagnosticSource();
            JavaFileObject fileObject = source.getFile();
            CharSequence charContent = fileObject.getCharContent(true);
            Context scanContext = new Context();
            ScannerFactory scannerFactory = ScannerFactory.instance(scanContext);
            Log log = Log.instance(scanContext);
            log.useSource(fileObject);
            Scanner javacScanner = scannerFactory.newScanner(charContent, true);
            Tokens.Token t = javacScanner.token();
            while (t != null && t.kind != Tokens.TokenKind.EOF && t.endPos <= preferedOffset) {
                javacScanner.nextToken();
                t = javacScanner.token();
                Tokens.Token prev = javacScanner.prevToken();
                if (prev == null || t.endPos != prev.endPos || t.pos != prev.pos || !t.kind.equals(prev.kind)) continue;
                t = null;
            }
            Tokens.Token toHighlight = javacScanner.token();
            if (JavacProblemConverter.isTokenBadChoiceForHighlight(t) && !JavacProblemConverter.isTokenBadChoiceForHighlight(javacScanner.prevToken())) {
                toHighlight = javacScanner.prevToken();
            }
            return new Position(Math.min(charContent.length() - 1, toHighlight.pos), Math.max(1, toHighlight.endPos - toHighlight.pos - 1));
        }
        catch (IOException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
            return this.getDefaultPosition(jcDiagnostic);
        }
    }

    private Position getMissingReturnMethodDiagnostic(JCDiagnostic jcDiagnostic, Context context) {
        if (COMPILER_ERR_MISSING_RET_STMT.equals(jcDiagnostic.getCode())) {
            JCTree tree = jcDiagnostic.getDiagnosticPosition().getTree();
            if (tree instanceof JCTree.JCBlock) {
                try {
                    int startOffset = tree.getStartPosition();
                    DiagnosticSource source = jcDiagnostic.getDiagnosticSource();
                    JavaFileObject fileObject = source.getFile();
                    CharSequence charContent = fileObject.getCharContent(true);
                    ScannerFactory scannerFactory = ScannerFactory.instance(context);
                    Scanner javacScanner = scannerFactory.newScanner(charContent, true);
                    Tokens.Token t = javacScanner.token();
                    Tokens.Token lparen = null;
                    Tokens.Token rparen = null;
                    Tokens.Token name = null;
                    block8: while (t.kind != Tokens.TokenKind.EOF && t.endPos <= startOffset) {
                        javacScanner.nextToken();
                        t = javacScanner.token();
                        switch (t.kind) {
                            case IDENTIFIER: {
                                if (lparen != null) continue block8;
                                name = t;
                                continue block8;
                            }
                            case LPAREN: {
                                lparen = t;
                                continue block8;
                            }
                            case RPAREN: {
                                if (name == null) continue block8;
                                rparen = t;
                                continue block8;
                            }
                            case RBRACE: 
                            case SEMI: {
                                name = null;
                                lparen = null;
                                rparen = null;
                                continue block8;
                            }
                        }
                    }
                    if (lparen != null && name != null && rparen != null) {
                        return new Position(Math.min(charContent.length() - 1, name.pos), Math.max(0, rparen.endPos - name.pos - 1));
                    }
                }
                catch (IOException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
            return this.getDefaultPosition(jcDiagnostic);
        }
        return null;
    }

    private static boolean isTokenBadChoiceForHighlight(Tokens.Token t) {
        return t.kind == Tokens.TokenKind.LPAREN || t.kind == Tokens.TokenKind.RPAREN || t.kind == Tokens.TokenKind.LBRACKET || t.kind == Tokens.TokenKind.RBRACKET || t.kind == Tokens.TokenKind.LBRACE || t.kind == Tokens.TokenKind.RBRACE;
    }

    private Position getDiagnosticPosition(JCDiagnostic jcDiagnostic, JCTree.JCVariableDecl jcVariableDecl) {
        int startPosition = (int)jcDiagnostic.getPosition();
        if (startPosition != -1) {
            try {
                String name = jcVariableDecl.getName().toString();
                return this.getDiagnosticPosition(name, startPosition, jcDiagnostic);
            }
            catch (IOException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.getDefaultPosition(jcDiagnostic);
    }

    private Position getDiagnosticPosition(JCDiagnostic jcDiagnostic, JCTree.JCClassDecl jcClassDecl) {
        int startPosition = (int)jcDiagnostic.getPosition();
        java.util.List realMembers = jcClassDecl.getMembers().stream().filter(member -> {
            if (!(member instanceof JCTree.JCMethodDecl)) return true;
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)member;
            if (methodDecl.sym == null) return true;
            if ((methodDecl.sym.flags() & 0x1000000000L) == 0L) return true;
            return false;
        }).collect(Collectors.toList());
        if (startPosition != -1 && (realMembers.isEmpty() || jcClassDecl.getStartPosition() != ((JCTree)((List)jcClassDecl.getMembers()).get(0)).getStartPosition())) {
            try {
                String name = jcClassDecl.getSimpleName().toString();
                return this.getDiagnosticPosition(name, startPosition, jcDiagnostic);
            }
            catch (IOException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.getDefaultPosition(jcDiagnostic);
    }

    private Position getDiagnosticPosition(String name, int startPosition, JCDiagnostic jcDiagnostic) throws IOException {
        String temp;
        int ind;
        String content;
        if (name != null && !name.isEmpty() && (content = JavacProblemConverter.loadDocumentText(jcDiagnostic)) != null && content.length() > startPosition && (ind = (temp = content.substring(startPosition)).indexOf(name)) >= 0) {
            int offset = startPosition + ind;
            int length = name.length();
            return new Position(offset, length);
        }
        return this.getDefaultPosition(jcDiagnostic);
    }

    private static String loadDocumentText(Diagnostic<?> diagnostic) throws IOException {
        if (diagnostic instanceof JCDiagnostic) {
            JCDiagnostic jcDiagnostic = (JCDiagnostic)diagnostic;
            DiagnosticSource source = jcDiagnostic.getDiagnosticSource();
            JavaFileObject fileObject = source.getFile();
            CharSequence charContent = fileObject.getCharContent(true);
            String content = charContent.toString();
            return content;
        }
        return null;
    }

    private int toSeverity(int jdtProblemId, Diagnostic<? extends JavaFileObject> diagnostic) {
        int irritant;
        if (jdtProblemId != 0 && (irritant = ProblemReporter.getIrritant((int)jdtProblemId)) != 0) {
            int res = this.compilerOptions.getSeverity(irritant);
            return res &= 0xFFFFFFDF;
        }
        return switch (diagnostic.getKind()) {
            case Diagnostic.Kind.ERROR -> 1;
            case Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING -> 0;
            case Diagnostic.Kind.NOTE -> 1024;
            default -> 1;
        };
    }

    public int toProblemId(Diagnostic<? extends JavaFileObject> diagnostic) {
        String javacDiagnosticCode;
        return switch (javacDiagnosticCode = diagnostic.getCode()) {
            case "compiler.warn.dangling.doc.comment" -> {
                int var5_5;
                yield var5_5 = -1;
            }
            case "compiler.note.removal.filename", "compiler.note.deprecated.plural.additional", "compiler.note.removal.plural.additional", "compiler.note.unchecked.filename" -> {
                int var5_6;
                yield var5_6 = -1;
            }
            case "compiler.err.expected" -> {
                int var5_7;
                yield var5_7 = 1610612967;
            }
            case "compiler.err.expected2" -> {
                int var5_8;
                yield var5_8 = 0x600000E6;
            }
            case "compiler.err.expected3" -> {
                int var5_9;
                yield var5_9 = 0x600000F0;
            }
            case "compiler.err.unclosed.comment" -> {
                int var5_10;
                yield var5_10 = 1610612996;
            }
            case "compiler.err.illegal.start.of.type" -> {
                int var5_11;
                yield var5_11 = 0x40000000;
            }
            case "compiler.err.illegal.start.of.expr" -> {
                int var5_13;
                try {
                    String token = this.readIdentifier(JavacProblemConverter.loadDocumentText(diagnostic), diagnostic.getPosition());
                    if (Modifier.ModifierKeyword.toKeyword((String)token) != null) {
                        int var5_12;
                        yield var5_12 = 536871914;
                    }
                }
                catch (Exception ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
                yield var5_13 = 0x40000000;
            }
            case "compiler.err.illegal.start.of.stmt" -> {
                int var5_14;
                yield var5_14 = 0x40000000;
            }
            case "compiler.err.variable.not.allowed" -> {
                int var5_15;
                yield var5_15 = 0x40000000;
            }
            case "compiler.err.illegal.dot" -> {
                int var5_16;
                yield var5_16 = 0x40000000;
            }
            case "compiler.warn.raw.class.use" -> {
                int var5_17;
                yield var5_17 = 16777788;
            }
            case "compiler.err.cant.resolve.location" -> {
                int var5_18;
                int v1 = switch (JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Kinds.KindName.class)) {
                    case Kinds.KindName.CLASS -> 0x1000002;
                    case Kinds.KindName.METHOD -> 0x4000064;
                    case Kinds.KindName.VAR -> {
                        Tree var9_277;
                        TreePath path = this.getTreePath(diagnostic);
                        if (path != null && path.getParentPath() != null && (var9_277 = path.getLeaf()) instanceof JCTree.JCIdent) {
                            JCTree.JCFieldAccess fieldAccess;
                            JCTree.JCIdent ident = (JCTree.JCIdent)var9_277;
                            var9_277 = path.getParentPath().getLeaf();
                            if (var9_277 instanceof JCTree.JCFieldAccess && (fieldAccess = (JCTree.JCFieldAccess)var9_277).getExpression() == ident) {
                                yield 0x22000032;
                            }
                        }
                        yield 33554515;
                    }
                    default -> 0x22000032;
                };
                yield var5_18 = v1;
            }
            case "compiler.err.cant.resolve.location.args" -> {
                int var5_19;
                yield var5_19 = this.convertUndefinedMethod(diagnostic);
            }
            case "compiler.err.cant.resolve.location.args.params" -> {
                int var5_20;
                yield var5_20 = 0x4000064;
            }
            case "compiler.err.cant.resolve", "compiler.err.invalid.mref" -> {
                int var5_21;
                yield var5_21 = this.convertUnresolved(diagnostic);
            }
            case "compiler.err.cant.resolve.args" -> {
                int var5_22;
                yield var5_22 = this.convertUndefinedMethod(diagnostic);
            }
            case "compiler.err.cant.resolve.args.params" -> {
                int var5_23;
                yield var5_23 = 0x4000064;
            }
            case "compiler.err.cant.apply.symbols", "compiler.err.cant.apply.symbol" -> {
                int var5_24;
                int v2 = switch (JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Kinds.KindName.class)) {
                    case Kinds.KindName.CONSTRUCTOR -> {
                        String rootCauseCode;
                        boolean isDefault;
                        Tree ident;
                        TreePath treePath;
                        for (treePath = this.getTreePath(diagnostic); treePath != null && !(treePath.getLeaf() instanceof JCTree.JCMethodDecl) && treePath != null; treePath = treePath.getParentPath()) {
                        }
                        if (treePath == null || !((ident = treePath.getLeaf()) instanceof JCTree.JCMethodDecl)) {
                            yield 0x8000082;
                        }
                        JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)ident;
                        boolean v3 = isDefault = (methodDecl.sym.flags() & 0x1000000000L) != 0L;
                        if (diagnostic instanceof JCDiagnostic.MultilineDiagnostic && isDefault) {
                            yield 0x800008C;
                        }
                        JCDiagnostic rootCause = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, JCDiagnostic.class);
                        if (rootCause == null) {
                            yield 0x8000082;
                        }
                        switch (rootCauseCode = rootCause.getCode()) {
                            case "compiler.misc.report.access": {
                                if (isDefault) {
                                    yield 0x800008D;
                                }
                                yield 0x8000083;
                            }
                            case "compiler.misc.arg.length.mismatch": {
                                if (isDefault) {
                                    yield 0x800008C;
                                }
                                yield 0x8000082;
                            }
                        }
                        yield 0x8000082;
                    }
                    case Kinds.KindName.METHOD -> 67108979;
                    default -> 67108979;
                };
                yield var5_24 = v2;
            }
            case "compiler.err.premature.eof" -> {
                int var5_25;
                yield var5_25 = 1610612975;
            }
            case "compiler.err.report.access" -> {
                int var5_26;
                yield var5_26 = this.convertNotVisibleAccess(diagnostic);
            }
            case "compiler.err.does.not.override.abstract" -> {
                int var5_29;
                Object isDefault;
                Object[] args = this.getDiagnosticArguments(diagnostic);
                if (args.length > 2 && (isDefault = args[0]) instanceof Symbol.ClassSymbol) {
                    Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)isDefault;
                    if (args[0] == args[2]) {
                        if (classSymbol.isEnum()) {
                            int var5_27;
                            yield var5_27 = 67109622;
                        }
                        if (!classSymbol.isInterface() && !classSymbol.isAbstract()) {
                            int var5_28;
                            yield var5_28 = 16777549;
                        }
                    }
                }
                yield var5_29 = 67109264;
            }
            case COMPILER_WARN_MISSING_SVUID -> {
                int var5_30;
                yield var5_30 = 0x20000060;
            }
            case COMPILER_WARN_NON_SERIALIZABLE_INSTANCE_FIELD -> {
                int var5_31;
                yield var5_31 = 99999999;
            }
            case "compiler.err.ref.ambiguous" -> {
                int var5_32;
                yield var5_32 = this.convertAmbiguous(diagnostic);
            }
            case "compiler.err.illegal.initializer.for.type" -> {
                int var5_33;
                yield var5_33 = 0x1000011;
            }
            case "compiler.err.prob.found.req" -> {
                int var5_34;
                yield var5_34 = this.convertTypeMismatch(diagnostic);
            }
            case "compiler.err.invalid.meth.decl.ret.type.req" -> {
                int var5_35;
                yield var5_35 = 16777327;
            }
            case "compiler.err.abstract.meth.cant.have.body" -> {
                int var5_36;
                yield var5_36 = 603979889;
            }
            case "compiler.err.unreported.exception.need.to.catch.or.throw" -> {
                int var5_37;
                yield var5_37 = 16777384;
            }
            case "compiler.err.unreported.exception.default.constructor" -> {
                int var5_38;
                yield var5_38 = 16777362;
            }
            case "compiler.err.unreachable.stmt" -> {
                int var5_39;
                yield var5_39 = 536871073;
            }
            case "compiler.err.except.never.thrown.in.try" -> {
                int var5_40;
                yield var5_40 = 83886247;
            }
            case "compiler.err.except.already.caught" -> {
                int var5_41;
                yield var5_41 = 553648315;
            }
            case "compiler.err.unclosed.str.lit" -> {
                int var5_42;
                yield var5_42 = 1610612995;
            }
            case "compiler.err.class.public.should.be.in.file" -> {
                int var5_43;
                yield var5_43 = 16777541;
            }
            case "compiler.err.already.defined.this.unit" -> {
                int var5_44;
                yield var5_44 = 0x10000181;
            }
            case "compiler.err.override.meth.doesnt.throw" -> {
                int var5_45;
                yield var5_45 = 67109266;
            }
            case "compiler.err.override.incompatible.ret" -> {
                int var5_46;
                yield var5_46 = 67109268;
            }
            case "compiler.err.annotation.missing.default.value" -> {
                int var5_47;
                yield var5_47 = 16777825;
            }
            case "compiler.err.annotation.value.must.be.name.value" -> {
                int var5_48;
                yield var5_48 = 67109475;
            }
            case "compiler.err.multicatch.types.must.be.disjoint" -> {
                int var5_49;
                yield var5_49 = 553649001;
            }
            case "compiler.err.unreported.exception.implicit.close" -> {
                int var5_50;
                yield var5_50 = 16778098;
            }
            case "compiler.err.repeated.modifier" -> {
                int var5_51;
                yield var5_51 = 67109232;
            }
            case "compiler.err.not.stmt" -> {
                int var5_52;
                yield var5_52 = 1610612958;
            }
            case "compiler.err.varargs.and.old.array.syntax" -> {
                int var5_53;
                yield var5_53 = 67109667;
            }
            case "compiler.err.non-static.cant.be.ref" -> {
                int var5_54;
                int v4 = switch (JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Kinds.KindName.class)) {
                    case Kinds.KindName.METHOD -> 603979977;
                    case Kinds.KindName.VAR -> 33554506;
                    default -> 33554506;
                };
                yield var5_54 = v4;
            }
            case COMPILER_ERR_MISSING_RET_STMT -> {
                int var5_55;
                yield var5_55 = 603979884;
            }
            case "compiler.err.cant.ref.before.ctor.called" -> {
                int var5_56;
                yield var5_56 = 0x8000087;
            }
            case "compiler.err.not.def.public.cant.access" -> {
                int var5_57;
                yield var5_57 = 0x1000003;
            }
            case "compiler.err.already.defined" -> {
                int var5_58;
                yield var5_58 = 67109219;
            }
            case "compiler.warn.underscore.as.identifier" -> {
                int var5_59;
                yield var5_59 = 1610613179;
            }
            case "compiler.err.var.might.not.have.been.initialized" -> {
                int var5_60;
                Symbol.VarSymbol symbol = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Symbol.VarSymbol.class);
                yield var5_60 = symbol.owner instanceof Symbol.ClassSymbol ? 33554513 : 0x20000033;
            }
            case "compiler.err.missing.meth.body.or.decl.abstract" -> {
                int var5_64;
                JCDiagnostic jcDiagnostic;
                JCDiagnostic.DiagnosticPosition isDefault;
                if (diagnostic instanceof JCDiagnostic && (isDefault = (jcDiagnostic = (JCDiagnostic)diagnostic).getDiagnosticPosition()) instanceof JCTree.JCMethodDecl) {
                    JCTree.JCMethodDecl jcMethodDecl = (JCTree.JCMethodDecl)isDefault;
                    if (jcMethodDecl.sym != null && jcMethodDecl.sym.enclClass() != null && jcMethodDecl.sym.enclClass().type != null && jcMethodDecl.sym.enclClass().type.isInterface()) {
                        int var5_63;
                        if (this.compilerOptions.complianceLevel < 0x340000L) {
                            int var5_61;
                            yield var5_61 = 67109223;
                        }
                        if (this.compilerOptions.complianceLevel < 0x350000L) {
                            int var5_62;
                            yield var5_62 = 67109914;
                        }
                        yield var5_63 = 67109935;
                    }
                }
                yield var5_64 = 603979883;
            }
            case "compiler.err.intf.meth.cant.have.body" -> {
                int var5_65;
                yield var5_65 = 603979889;
            }
            case "compiler.warn.empty.if" -> {
                int var5_66;
                yield var5_66 = 553648316;
            }
            case "compiler.warn.redundant.cast" -> {
                int var5_67;
                yield var5_67 = 553648309;
            }
            case "compiler.err.illegal.char" -> {
                int var5_68;
                yield var5_68 = 1610612989;
            }
            case "compiler.err.enum.label.must.be.unqualified.enum" -> {
                int var5_69;
                yield var5_69 = 33554502;
            }
            case "compiler.err.bad.initializer" -> {
                int var5_70;
                yield var5_70 = 0x600000F0;
            }
            case "compiler.err.cant.assign.val.to.var" -> {
                int var5_71;
                yield var5_71 = 0x2000050;
            }
            case "compiler.err.cant.inherit.from.final" -> {
                int var5_72;
                yield var5_72 = this.isInAnonymousClass(diagnostic) ? 0x100001D : 16777529;
            }
            case "compiler.err.qualified.new.of.static.class" -> {
                int var5_73;
                yield var5_73 = 16777373;
            }
            case "compiler.err.abstract.cant.be.instantiated" -> {
                int var5_74;
                yield var5_74 = 16777373;
            }
            case "compiler.err.mod.not.allowed.here" -> {
                int var5_75;
                yield var5_75 = this.illegalModifier(diagnostic);
            }
            case "compiler.warn.strictfp" -> {
                int var5_76;
                yield var5_76 = this.uselessStrictfp(diagnostic);
            }
            case "compiler.err.invalid.permits.clause" -> {
                int var5_77;
                yield var5_77 = this.illegalModifier(diagnostic);
            }
            case "compiler.err.sealed.class.must.have.subclasses" -> {
                int var5_78;
                yield var5_78 = 16779076;
            }
            case "compiler.misc.doesnt.extend.sealed" -> {
                int var5_79;
                yield var5_79 = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Type.ClassType.class).isInterface() ? 16779079 : 16779073;
            }
            case "compiler.err.feature.not.supported.in.source.plural" -> {
                int var5_82;
                if (this.compilerOptions.complianceLevel < 0x340000L) {
                    int var5_80;
                    yield var5_80 = 67109223;
                }
                if (this.compilerOptions.complianceLevel < 0x350000L) {
                    int var5_81;
                    yield var5_81 = 67109914;
                }
                yield var5_82 = 67109935;
            }
            case "compiler.err.expression.not.allowable.as.annotation.value" -> {
                int var5_83;
                yield var5_83 = 536871525;
            }
            case "compiler.err.illegal.combination.of.modifiers" -> {
                int var5_84;
                yield var5_84 = this.illegalCombinationOfModifiers(diagnostic);
            }
            case "compiler.err.duplicate.class" -> {
                int var5_85;
                yield var5_85 = 16777539;
            }
            case "compiler.err.module.not.found", "compiler.warn.module.not.found" -> {
                int var5_86;
                yield var5_86 = 8389908;
            }
            case "compiler.err.package.empty.or.not.found" -> {
                int var5_87;
                yield var5_87 = 8389919;
            }
            case "compiler.warn.service.provided.but.not.exported.or.used" -> {
                int var5_88;
                yield var5_88 = -1;
            }
            case "compiler.warn.missing-explicit-ctor" -> {
                int var5_89;
                yield var5_89 = 0x8000000;
            }
            case "compiler.warn.has.been.deprecated", "compiler.warn.has.been.deprecated.for.removal" -> {
                int var5_90;
                int v5;
                Kinds.KindName kind = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Kinds.KindName.class);
                if (kind == null) {
                    v5 = 33554505;
                } else {
                    switch (kind) {
                        case CONSTRUCTOR: {
                            v5 = 0x8000085;
                            break;
                        }
                        case METHOD: {
                            v5 = 67108967;
                            break;
                        }
                        case VAR: 
                        case RECORD_COMPONENT: {
                            v5 = 33554505;
                            break;
                        }
                        case ANNOTATION: {
                            v5 = 0x1000005;
                            break;
                        }
                        case PACKAGE: {
                            v5 = 8390033;
                            break;
                        }
                        case MODULE: {
                            v5 = 8390037;
                            break;
                        }
                        case CLASS: 
                        case RECORD: 
                        case INTERFACE: 
                        case ENUM: {
                            v5 = 0x1000005;
                            break;
                        }
                        default: {
                            v5 = 33554505;
                        }
                    }
                }
                yield var5_90 = v5;
            }
            case "compiler.warn.inconsistent.white.space.indentation" -> {
                int var5_91;
                yield var5_91 = -1;
            }
            case "compiler.warn.trailing.white.space.will.be.removed" -> {
                int var5_92;
                yield var5_92 = -1;
            }
            case "compiler.warn.possible.fall-through.into.case" -> {
                int var5_93;
                yield var5_93 = 0x200000C2;
            }
            case "compiler.warn.restricted.type.not.allowed.preview" -> {
                int var5_94;
                yield var5_94 = 16778958;
            }
            case "compiler.err.illegal.esc.char" -> {
                int var5_95;
                yield var5_95 = 1610612990;
            }
            case "compiler.err.preview.feature.disabled", "compiler.err.preview.feature.disabled.plural" -> {
                int var5_96;
                yield var5_96 = 0x40044F;
            }
            case "compiler.err.is.preview" -> {
                int var5_97;
                yield var5_97 = 0x400454;
            }
            case "compiler.err.cant.access" -> {
                int var5_98;
                yield var5_98 = 16778666;
            }
            case "compiler.err.var.not.initialized.in.default.constructor" -> {
                int var5_99;
                yield var5_99 = 33554513;
            }
            case "compiler.err.assert.as.identifier" -> {
                int var5_100;
                yield var5_100 = 536871352;
            }
            case "compiler.warn.unchecked.varargs.non.reifiable.type", "compiler.warn.varargs.unsafe.use.varargs.param" -> {
                int var5_101;
                yield var5_101 = 67109670;
            }
            case "compiler.err.var.might.already.be.assigned" -> {
                int var5_102;
                yield var5_102 = 0x2000050;
            }
            case "compiler.err.annotation.missing.default.value.1" -> {
                int var5_103;
                yield var5_103 = 16777825;
            }
            case "compiler.warn.static.not.qualified.by.type" -> {
                int var5_104;
                int v6;
                Kinds.KindName kind = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Kinds.KindName.class);
                if (kind == null) {
                    v6 = 570425420;
                } else {
                    switch (kind) {
                        case METHOD: {
                            v6 = 603979893;
                            break;
                        }
                        case VAR: 
                        case RECORD_COMPONENT: {
                            v6 = 570425420;
                            break;
                        }
                        default: {
                            v6 = 570425420;
                        }
                    }
                }
                yield var5_104 = v6;
            }
            case "compiler.err.illegal.static.intf.meth.call" -> {
                int var5_105;
                yield var5_105 = 1610613404;
            }
            case "compiler.err.recursive.ctor.invocation" -> {
                int var5_106;
                yield var5_106 = 0x8000089;
            }
            case "compiler.err.illegal.text.block.open" -> {
                int var5_107;
                yield var5_107 = 0x40000000;
            }
            case "compiler.warn.prob.found.req" -> {
                int var5_108;
                yield var5_108 = 976;
            }
            case "compiler.warn.restricted.type.not.allowed" -> {
                int var5_109;
                yield var5_109 = 16778958;
            }
            case "compiler.err.override.weaker.access" -> {
                int var5_110;
                yield var5_110 = 67109273;
            }
            case "compiler.err.enum.constant.expected" -> {
                int var5_111;
                yield var5_111 = 0x40000000;
            }
            case "compiler.err.limit.string" -> {
                int var5_112;
                yield var5_112 = 536871343;
            }
            case "compiler.err.limit.string.overflow" -> {
                int var5_113;
                yield var5_113 = 536871064;
            }
            case "compiler.err.undef.label" -> {
                int var5_114;
                yield var5_114 = 536871086;
            }
            case "compiler.err.unexpected.lambda" -> {
                int var5_115;
                yield var5_115 = 0x40000000;
            }
            case "compiler.err.deconstruction.pattern.only.records" -> {
                int var5_116;
                yield var5_116 = 2099064;
            }
            case "compiler.err.use.of.underscore.not.allowed.non.variable" -> {
                int var5_117;
                yield var5_117 = 2099152;
            }
            case "compiler.warn.preview.feature.use.plural", "compiler.warn.is.preview" -> {
                int var5_118;
                yield var5_118 = 0x400450;
            }
            case "compiler.err.non.sealed.with.no.sealed.supertype" -> {
                int var5_119;
                yield var5_119 = 16779067;
            }
            case "compiler.err.record.cannot.declare.instance.fields" -> {
                int var5_120;
                yield var5_120 = 16778949;
            }
            case "compiler.err.else.without.if" -> {
                int var5_121;
                yield var5_121 = 0x40000000;
            }
            case "compiler.err.dc.bad.entity" -> {
                int var5_122;
                yield var5_122 = -1610612218;
            }
            case "compiler.err.dc.bad.inline.tag" -> {
                int var5_123;
                yield var5_123 = -1610612218;
            }
            case "compiler.err.dc.identifier.expected" -> {
                int var5_124;
                yield var5_124 = -1610612269;
            }
            case "compiler.err.dc.invalid.html" -> {
                int var5_125;
                yield var5_125 = -1610612218;
            }
            case "compiler.err.dc.malformed.html" -> {
                int var5_126;
                yield var5_126 = -1610612218;
            }
            case "compiler.err.dc.missing.semicolon" -> {
                int var5_127;
                yield var5_127 = -1610612218;
            }
            case "compiler.err.dc.no.content" -> {
                int var5_128;
                yield var5_128 = -1610612218;
            }
            case "compiler.err.dc.no.tag.name" -> {
                int var5_129;
                yield var5_129 = -1610612218;
            }
            case "compiler.err.dc.no.url" -> {
                int var5_130;
                yield var5_130 = -1610612218;
            }
            case "compiler.err.dc.no.title" -> {
                int var5_131;
                yield var5_131 = -1610612218;
            }
            case "compiler.err.dc.gt.expected" -> {
                int var5_132;
                yield var5_132 = -1610612218;
            }
            case "compiler.err.dc.ref.bad.parens" -> {
                int var5_133;
                yield var5_133 = -1610612218;
            }
            case "compiler.err.dc.ref.syntax.error" -> {
                int var5_134;
                yield var5_134 = -1610612218;
            }
            case "compiler.err.dc.ref.unexpected.input" -> {
                int var5_135;
                yield var5_135 = -1610612218;
            }
            case "compiler.err.dc.unexpected.content" -> {
                int var5_136;
                yield var5_136 = -1610612218;
            }
            case "compiler.err.dc.unterminated.inline.tag" -> {
                int var5_137;
                yield var5_137 = -1610612224;
            }
            case "compiler.err.dc.unterminated.signature" -> {
                int var5_138;
                yield var5_138 = -1610612218;
            }
            case "compiler.err.dc.unterminated.string" -> {
                int var5_139;
                yield var5_139 = -1610612218;
            }
            case "compiler.err.dc.ref.annotations.not.allowed" -> {
                int var5_140;
                yield var5_140 = -1610612218;
            }
            case "compiler.warn.proc.messager", "compiler.err.proc.messager" -> {
                int var5_150;
                JCTree.JCPrimitiveTypeTree primitiveType;
                JCTree.JCMethodDecl method;
                JCTree var10_300;
                JCDiagnostic jcDiag;
                JCDiagnostic.DiagnosticPosition rootCause;
                String message = diagnostic.getMessage(Locale.ENGLISH).toLowerCase();
                if (message.contains("no @param for")) {
                    int var5_141;
                    yield var5_141 = -1610612265;
                }
                if (message.contains("no @return")) {
                    int var5_142;
                    yield var5_142 = -1610612261;
                }
                if (message.contains("@param name not found")) {
                    int var5_143;
                    yield var5_143 = -1610612262;
                }
                if (message.contains("no @throws for ")) {
                    int var5_144;
                    yield var5_144 = -1610612259;
                }
                if (message.contains("invalid use of @return")) {
                    int var5_145;
                    yield var5_145 = -1610612266;
                }
                if (message.startsWith("exception not thrown: ")) {
                    int var5_146;
                    yield var5_146 = -1610612255;
                }
                if (message.startsWith("@param ") && message.endsWith(" has already been specified")) {
                    int var5_147;
                    yield var5_147 = -1610612263;
                }
                if (message.contains("no comment")) {
                    int var5_148;
                    yield var5_148 = -1610612250;
                }
                if (message.contains("empty comment") && diagnostic instanceof JCDiagnostic && (rootCause = (jcDiag = (JCDiagnostic)diagnostic).getDiagnosticPosition()) instanceof JCTree.JCMethodDecl && (var10_300 = (method = (JCTree.JCMethodDecl)rootCause).getReturnType()) instanceof JCTree.JCPrimitiveTypeTree && (primitiveType = (JCTree.JCPrimitiveTypeTree)var10_300).getPrimitiveTypeKind() != TypeKind.VOID) {
                    int var5_149;
                    yield var5_149 = -1610612261;
                }
                yield var5_150 = -1;
            }
            case "compiler.err.doesnt.exist" -> {
                int var5_153;
                JCTree.JCCompilationUnit unit = this.units.get(diagnostic.getSource());
                if (unit != null) {
                    long diagPos = diagnostic.getPosition();
                    boolean isImport = unit.getImports().stream().anyMatch(jcImport -> diagPos >= (long)jcImport.getStartPosition() && diagPos <= (long)jcImport.getEndPosition(unit.endPositions));
                    if (isImport) {
                        int var5_151;
                        yield var5_151 = 268435846;
                    }
                    if (unit.getModule() != null) {
                        int var5_152;
                        yield var5_152 = 8389919;
                    }
                }
                yield var5_153 = 0x1000002;
            }
            case "compiler.err.override.meth" -> {
                int var5_154;
                yield var5_154 = diagnostic.getMessage(Locale.ENGLISH).contains("static") ? 67109270 : 67109265;
            }
            case "compiler.err.unclosed.char.lit", "compiler.err.empty.char.lit" -> {
                int var5_155;
                yield var5_155 = 1610612989;
            }
            case "compiler.err.malformed.fp.lit" -> {
                int var5_156;
                yield var5_156 = 0x60000101;
            }
            case "compiler.warn.missing.deprecated.annotation" -> {
                int var5_161;
                if (!(diagnostic instanceof JCDiagnostic)) {
                    int var5_157;
                    yield var5_157 = -1;
                }
                JCDiagnostic jcDiagnostic = (JCDiagnostic)diagnostic;
                JCDiagnostic.DiagnosticPosition pos = jcDiagnostic.getDiagnosticPosition();
                if (pos instanceof JCTree.JCVariableDecl) {
                    int var5_158;
                    yield var5_158 = 536871540;
                }
                if (pos instanceof JCTree.JCMethodDecl) {
                    int var5_159;
                    yield var5_159 = 536871541;
                }
                if (pos instanceof JCTree.JCClassDecl) {
                    int var5_160;
                    yield var5_160 = 536871542;
                }
                ILog.get().error("Could not convert diagnostic " + String.valueOf(diagnostic));
                yield var5_161 = -1;
            }
            case "compiler.warn.override.equals.but.not.hashcode" -> {
                int var5_162;
                yield var5_162 = 16777548;
            }
            case "compiler.warn.unchecked.call.mbr.of.raw.type" -> {
                int var5_163;
                yield var5_163 = 16777747;
            }
            case "compiler.err.cant.inherit.from.sealed" -> {
                int var5_166;
                Symbol.ClassSymbol sym = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Symbol.ClassSymbol.class);
                if (sym == null) {
                    int var5_164;
                    yield var5_164 = -1;
                }
                if (sym.isInterface()) {
                    int var5_165;
                    yield var5_165 = 16779069;
                }
                yield var5_166 = 16779068;
            }
            case "compiler.err.non.sealed.sealed.or.final.expected" -> {
                int var5_167;
                yield var5_167 = 16779066;
            }
            case "compiler.err.enum.annotation.must.be.enum.constant" -> {
                int var5_168;
                yield var5_168 = 536871545;
            }
            case "compiler.err.package.in.other.module" -> {
                int var5_169;
                yield var5_169 = 8390064;
            }
            case "compiler.err.module.decl.sb.in.module-info.java" -> {
                int var5_172;
                if (!(diagnostic instanceof JCDiagnostic)) {
                    int var5_170;
                    yield var5_170 = -1;
                }
                JCDiagnostic jcDiagnostic = (JCDiagnostic)diagnostic;
                JCDiagnostic.DiagnosticPosition pos = jcDiagnostic.getDiagnosticPosition();
                if (pos instanceof JCTree.JCModuleDecl) {
                    int var5_171;
                    yield var5_171 = 1610612946;
                }
                if (pos instanceof JCTree.JCModuleImport) {
                    // empty if block
                }
                ILog.get().error("Could not convert diagnostic " + String.valueOf(diagnostic));
                yield var5_172 = -1;
            }
            case "compiler.err.file.sb.on.source.or.patch.path.for.module" -> {
                int var5_173;
                yield var5_173 = 1610612946;
            }
            case "compiler.err.package.not.visible" -> {
                int var5_174;
                yield var5_174 = 0x1000003;
            }
            case "compiler.err.expected4" -> {
                int var5_175;
                yield var5_175 = 0x40000000;
            }
            case "compiler.err.no.intf.expected.here" -> {
                int var5_176;
                yield var5_176 = 16777528;
            }
            case "compiler.err.intf.expected.here" -> {
                int var5_177;
                yield var5_177 = 16777531;
            }
            case "compiler.err.method.does.not.override.superclass" -> {
                int var5_178;
                yield var5_178 = 67109498;
            }
            case "compiler.err.name.clash.same.erasure.no.override" -> {
                int var5_179;
                yield var5_179 = 16777743;
            }
            case "compiler.err.cant.deref" -> {
                int var5_180;
                yield var5_180 = 67108978;
            }
            case "compiler.err.cant.infer.local.var.type" -> {
                int var5_181;
                yield var5_181 = 1073743327;
            }
            case "compiler.err.array.and.varargs" -> {
                int var5_182;
                yield var5_182 = 536870968;
            }
            case "compiler.err.type.doesnt.take.params" -> {
                int var5_183;
                yield var5_183 = 16777740;
            }
            case "compiler.err.static.imp.only.classes.and.interfaces" -> {
                int var5_184;
                yield var5_184 = 268435847;
            }
            case "compiler.err.service.implementation.is.abstract" -> {
                int var5_185;
                yield var5_185 = 16778522;
            }
            case "compiler.err.service.implementation.no.args.constructor.not.public" -> {
                int var5_186;
                yield var5_186 = 16778524;
            }
            case "compiler.err.service.implementation.doesnt.have.a.no.args.constructor" -> {
                int var5_187;
                yield var5_187 = 16778523;
            }
            case "compiler.err.not.exhaustive" -> {
                int var5_188;
                yield var5_188 = 1073743531;
            }
            case "compiler.err.switch.expression.empty" -> {
                int var5_189;
                yield var5_189 = 1073743531;
            }
            case "compiler.err.switch.mixing.case.types" -> {
                int var5_190;
                yield var5_190 = 1073743530;
            }
            case "compiler.err.return.outside.switch.expression" -> {
                int var5_191;
                yield var5_191 = 1073743548;
            }
            case "compiler.err.cant.apply.diamond.1" -> {
                int var5_192;
                yield var5_192 = 16777740;
            }
            case "compiler.err.class.in.unnamed.module.cant.extend.sealed.in.diff.package" -> {
                int var5_193;
                yield var5_193 = 16779075;
            }
            case "compiler.err.non.sealed.or.sealed.expected" -> {
                int var5_194;
                yield var5_194 = 16779071;
            }
            case "compiler.err.array.dimension.missing" -> {
                int var5_195;
                yield var5_195 = 536871071;
            }
            case "compiler.warn.deprecated.annotation.has.no.effect" -> {
                int var5_196;
                yield var5_196 = 0x1000000;
            }
            case "compiler.err.enum.constant.not.expected" -> {
                int var5_197;
                yield var5_197 = 0x4000064;
            }
            case "compiler.warn.poor.choice.for.module.name" -> {
                int var5_198;
                yield var5_198 = 0x800000;
            }
            case "compiler.err.try.without.catch.finally.or.resource.decls" -> {
                int var5_199;
                yield var5_199 = 0x40000000;
            }
            case "compiler.warn.unchecked.meth.invocation.applied" -> {
                int var5_200;
                yield var5_200 = 16777748;
            }
            case "compiler.warn.override.unchecked.ret" -> {
                int var5_201;
                yield var5_201 = 67109423;
            }
            case "compiler.warn.override.varargs.missing" -> {
                int var5_202;
                yield var5_202 = 67109667;
            }
            case "compiler.err.encl.class.required" -> {
                int var5_203;
                yield var5_203 = 0x1000014;
            }
            case "compiler.err.operator.cant.be.applied", "compiler.err.operator.cant.be.applied.1" -> {
                int var5_204;
                yield var5_204 = 0x200000A0;
            }
            case "compiler.warn.try.resource.not.referenced" -> {
                int var5_205;
                yield var5_205 = 536870973;
            }
            case "compiler.warn.try.explicit.close.call" -> {
                int var5_206;
                yield var5_206 = 536871801;
            }
            case "compiler.err.types.incompatible" -> {
                int var5_207;
                yield var5_207 = 67109917;
            }
            case "compiler.err.incompatible.thrown.types.in.mref" -> {
                int var5_208;
                yield var5_208 = 16777384;
            }
            case "compiler.err.already.defined.single.import" -> {
                int var5_209;
                yield var5_209 = 0x10000181;
            }
            case "compiler.err.icls.cant.have.static.decl" -> {
                int var5_210;
                yield var5_210 = 67109225;
            }
            case "compiler.err.override.static" -> {
                int var5_211;
                yield var5_211 = 67109271;
            }
            case "compiler.err.native.meth.cant.have.body" -> {
                int var5_212;
                yield var5_212 = 603979888;
            }
            case "compiler.err.varargs.invalid.trustme.anno" -> {
                int var5_213;
                yield var5_213 = 67109668;
            }
            case "compiler.warn.unchecked.generic.array.creation" -> {
                int var5_214;
                yield var5_214 = 67109438;
            }
            case "compiler.warn.varargs.redundant.trustme.anno" -> {
                int var5_215;
                yield var5_215 = 0x1000000;
            }
            case "compiler.warn.finally.cannot.complete" -> {
                int var5_216;
                yield var5_216 = 536871096;
            }
            case "compiler.err.generic.throwable" -> {
                int var5_217;
                yield var5_217 = 16777773;
            }
            case "compiler.warn.potentially.ambiguous.overload" -> {
                int var5_218;
                yield var5_218 = 0x1000000;
            }
            case "compiler.warn.inexact.non-varargs.call" -> {
                int var5_219;
                yield var5_219 = 67109665;
            }
            case "compiler.note.deprecated.filename" -> {
                int var5_220;
                yield var5_220 = 67109276;
            }
            case "compiler.note.unchecked.plural.additional" -> {
                int var5_221;
                yield var5_221 = 0x1000000;
            }
            case "compiler.err.error.reading.file" -> {
                int var5_222;
                yield var5_222 = 536871614;
            }
            case "compiler.err.dot.class.expected" -> {
                int var5_223;
                yield var5_223 = 0x1000000;
            }
            case "compiler.err.feature.not.supported.in.source" -> {
                int var5_224;
                yield var5_224 = 4195411;
            }
            case "compiler.err.annotation.type.not.applicable.to.type", "compiler.err.annotation.type.not.applicable" -> {
                int var5_226;
                JCDiagnostic jcDiagnostic;
                JCDiagnostic.DiagnosticPosition var8_287;
                if (diagnostic instanceof JCDiagnostic && (var8_287 = (jcDiagnostic = (JCDiagnostic)diagnostic).getDiagnosticPosition()) instanceof JCTree.JCAnnotation) {
                    JCTree.JCAnnotation jcAnnotation = (JCTree.JCAnnotation)var8_287;
                    if (jcAnnotation.type.tsym.getAnnotationTypeMetadata().getTarget() == null) {
                        int var5_225;
                        yield var5_225 = 16777865;
                    }
                }
                yield var5_226 = 16777838;
            }
            case "compiler.err.pkg.annotations.sb.in.package-info.java" -> {
                int var5_227;
                yield var5_227 = 1610613338;
            }
            case "compiler.err.unexpected.type" -> {
                int var5_228;
                yield var5_228 = 0x1000011;
            }
            case "compiler.err.intf.annotation.members.cant.have.params" -> {
                int var5_229;
                yield var5_229 = 1610613353;
            }
            case "compiler.err.static.declaration.not.allowed.in.inner.classes" -> {
                int var5_231;
                JCDiagnostic jcDiagnostic;
                JCDiagnostic.DiagnosticPosition var8_288;
                if (diagnostic instanceof JCDiagnostic && (var8_288 = (jcDiagnostic = (JCDiagnostic)diagnostic).getDiagnosticPosition()) instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)var8_288;
                    if (classDecl.sym.isEnum()) {
                        int var5_230;
                        yield var5_230 = 0x20000020;
                    }
                }
                yield var5_231 = 16777527;
            }
            case "compiler.err.new.not.allowed.in.annotation" -> {
                int var5_232;
                yield var5_232 = 536871525;
            }
            case "compiler.err.foreach.not.applicable.to.type" -> {
                int var5_233;
                yield var5_233 = 536871493;
            }
            case "compiler.err.this.as.identifier" -> {
                int var5_234;
                yield var5_234 = 0x40000000;
            }
            case "compiler.err.int.number.too.large" -> {
                int var5_235;
                yield var5_235 = 536871066;
            }
            case "compiler.err.type.var.cant.be.deref" -> {
                int var5_236;
                yield var5_236 = 16777791;
            }
            case "compiler.err.try.with.resources.expr.needs.var" -> {
                int var5_237;
                yield var5_237 = 0x40000000;
            }
            case "compiler.err.catch.without.try" -> {
                int var5_238;
                yield var5_238 = 0x40000000;
            }
            case "compiler.err.not.encl.class" -> {
                int var5_239;
                yield var5_239 = 0x1000017;
            }
            case "compiler.err.type.found.req" -> {
                int var5_240;
                yield var5_240 = 16777838;
            }
            case "compiler.warn.try.resource.throws.interrupted.exc" -> {
                int var5_241;
                yield var5_241 = 16778098;
            }
            case "compiler.err.cyclic.inheritance" -> {
                int var5_242;
                yield var5_242 = 16777533;
            }
            case "compiler.err.incorrect.receiver.type" -> {
                int var5_243;
                yield var5_243 = 1610613386;
            }
            case "compiler.err.incorrect.constructor.receiver.type" -> {
                int var5_244;
                yield var5_244 = 1610613386;
            }
            case "compiler.err.incorrect.constructor.receiver.name" -> {
                int var5_245;
                yield var5_245 = 1610613387;
            }
            case "compiler.err.too.many.modules" -> {
                int var5_246;
                yield var5_246 = 0x800000;
            }
            case "compiler.err.call.must.only.appear.in.ctor" -> {
                int var5_247;
                yield var5_247 = 1207959691;
            }
            case "compiler.err.void.not.allowed.here" -> {
                int var5_248;
                yield var5_248 = 67108979;
            }
            case "compiler.err.abstract.cant.be.accessed.directly" -> {
                int var5_249;
                yield var5_249 = 67108968;
            }
            case "compiler.warn.annotation.method.not.found" -> {
                int var5_250;
                yield var5_250 = 67109475;
            }
            case "compiler.warn.annotation.method.not.found.reason" -> {
                int var5_251;
                yield var5_251 = 67109475;
            }
            case "compiler.err.import.module.not.found" -> {
                int var5_252;
                yield var5_252 = 8389908;
            }
            case "compiler.warn.possible.this.escape" -> {
                int var5_253;
                yield var5_253 = 39916802;
            }
            case "compiler.warn.possible.this.escape.location" -> {
                int var5_254;
                yield var5_254 = 39916803;
            }
            case "compiler.warn.possible.loss.of.precision" -> {
                int var5_255;
                yield var5_255 = 39916804;
            }
            case "compiler.warn.auxiliary.class.accessed.from.outside.of.its.source.file" -> {
                int var5_256;
                yield var5_256 = 39916805;
            }
            case "compiler.warn.restricted.method" -> {
                int var5_257;
                yield var5_257 = 0x1000118;
            }
            case "compiler.note.deprecated.filename.additional" -> {
                int var5_258;
                yield var5_258 = 67108967;
            }
            default -> {
                int var5_260;
                int var5_259;
                ILog.get().error("Could not accurately convert diagnostic (" + diagnostic.getCode() + ")\n" + String.valueOf(diagnostic));
                yield diagnostic.getKind() == Diagnostic.Kind.ERROR && diagnostic.getCode().startsWith("compiler.err") ? (var5_259 = 0) : (var5_260 = -1);
            }
        };
    }

    private String readIdentifier(String documentText, long position) {
        int endIndex = (int)position;
        if (!Character.isJavaIdentifierStart(documentText.charAt(endIndex))) {
            return null;
        }
        ++endIndex;
        while (++endIndex < documentText.length() && Character.isJavaIdentifierPart(documentText.charAt(endIndex))) {
        }
        return documentText.substring((int)position, endIndex);
    }

    private int uselessStrictfp(Diagnostic<? extends JavaFileObject> diagnostic) {
        TreePath path = this.getTreePath(diagnostic);
        if (path != null && path.getLeaf() instanceof JCTree.JCMethodDecl && path.getParentPath() != null && path.getParentPath().getLeaf() instanceof JCTree.JCClassDecl) {
            return 67109921;
        }
        return 1610613477;
    }

    private int illegalCombinationOfModifiers(Diagnostic<? extends JavaFileObject> diagnostic) {
        String message = diagnostic.getMessage(Locale.ENGLISH);
        TreePath path = this.getTreePath(diagnostic);
        if (path != null) {
            Tree parentNode;
            Tree leaf = path.getLeaf();
            TreePath parentPath = path.getParentPath();
            Tree tree = parentNode = parentPath != null ? parentPath.getLeaf() : null;
            if (message.contains("public") || message.contains("protected") || message.contains("private")) {
                if (leaf instanceof JCTree.JCMethodDecl) {
                    return 67109224;
                }
                if (leaf instanceof JCTree.JCClassDecl && parentNode instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl parentDecl = (JCTree.JCClassDecl)parentNode;
                    return switch (parentDecl.getKind()) {
                        case Tree.Kind.INTERFACE -> 16777525;
                        default -> 16777526;
                    };
                }
                if (leaf instanceof JCTree.JCVariableDecl && parentNode instanceof JCTree.JCClassDecl) {
                    return 33554776;
                }
            } else if (leaf instanceof JCTree.JCMethodDecl) {
                if (parentNode instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl declaringClass = (JCTree.JCClassDecl)parentNode;
                    if (declaringClass.getKind() == Tree.Kind.INTERFACE) {
                        return 0x4000420;
                    }
                    if (message.contains("abstract") && message.contains("final")) {
                        return 16777524;
                    }
                }
            } else if (leaf instanceof JCTree.JCVariableDecl && parentNode instanceof JCTree.JCClassDecl && message.contains("volatile") && message.contains("final")) {
                return 33554777;
            }
        }
        return 536871914;
    }

    private int illegalModifier(Diagnostic<? extends JavaFileObject> diagnostic) {
        TreePath path = this.getTreePath(diagnostic);
        while (path != null) {
            Tree parentNode;
            Tree leaf = path.getLeaf();
            TreePath parentPath = path.getParentPath();
            Tree tree = parentNode = parentPath != null ? parentPath.getLeaf() : null;
            if (leaf instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)leaf;
                if (parentNode instanceof JCTree.JCClassDecl) {
                    int n;
                    JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)parentNode;
                    if (methodDecl.getReturnType() == null) {
                        switch (classDecl.getKind()) {
                            case ENUM: {
                                n = 67109624;
                                break;
                            }
                            default: {
                                n = 67109233;
                                break;
                            }
                        }
                    } else {
                        switch (classDecl.getKind()) {
                            case INTERFACE: {
                                if (this.compilerOptions.complianceLevel < 0x340000L) {
                                    n = 67109223;
                                    break;
                                }
                                if (this.compilerOptions.complianceLevel < 0x350000L) {
                                    n = 67109914;
                                    break;
                                }
                                n = 67109935;
                                break;
                            }
                            case ANNOTATION_TYPE: {
                                n = 67109464;
                                break;
                            }
                            default: {
                                n = 67109222;
                            }
                        }
                    }
                    return n;
                }
                return 67109222;
            }
            if (leaf instanceof JCTree.JCClassDecl) {
                int n;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)leaf;
                if (parentNode instanceof JCTree.JCClassDecl) {
                    switch (classDecl.getKind()) {
                        case RECORD: {
                            n = 16778946;
                            break;
                        }
                        case ENUM: {
                            n = 16777969;
                            break;
                        }
                        case INTERFACE: {
                            n = 0x1000131;
                            break;
                        }
                        default: {
                            n = 0x1000130;
                            break;
                        }
                    }
                } else if (parentNode instanceof JCTree.JCCompilationUnit) {
                    switch (classDecl.getKind()) {
                        case RECORD: {
                            n = 16778947;
                            break;
                        }
                        case ENUM: {
                            n = 16777966;
                            break;
                        }
                        case INTERFACE: {
                            n = 16777519;
                            break;
                        }
                        default: {
                            n = 16777518;
                            break;
                        }
                    }
                } else {
                    switch (classDecl.getKind()) {
                        case RECORD: {
                            n = 16778978;
                            break;
                        }
                        case ENUM: {
                            n = 16778982;
                            break;
                        }
                        default: {
                            n = 16777522;
                        }
                    }
                }
                return n;
            }
            if (leaf instanceof JCTree.JCVariableDecl) {
                if (parentNode instanceof JCTree.JCMethodDecl) {
                    return 67109220;
                }
                if (parentNode instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)parentNode;
                    return switch (classDecl.getKind()) {
                        case Tree.Kind.INTERFACE -> 33554775;
                        default -> 33554774;
                    };
                }
            }
            path = parentPath;
        }
        return 536871914;
    }

    private boolean isInAnonymousClass(Diagnostic<? extends JavaFileObject> diagnostic) {
        for (TreePath path = this.getTreePath(diagnostic); path != null; path = path.getParentPath()) {
            Tree tree = path.getLeaf();
            if (tree instanceof JCTree.JCNewClass) {
                JCTree.JCNewClass newClass = (JCTree.JCNewClass)tree;
                return newClass.getClassBody() != null;
            }
            if (!(path.getLeaf() instanceof JCTree.JCClassDecl)) continue;
            return false;
        }
        return false;
    }

    private int convertUnresolved(Diagnostic<?> diagnostic) {
        JCDiagnostic jcDiagnostic;
        if (diagnostic instanceof JCDiagnostic && (jcDiagnostic = (JCDiagnostic)diagnostic).getDiagnosticPosition() instanceof JCTree.JCFieldAccess) {
            return 33554502;
        }
        return switch (JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Kinds.KindName.class)) {
            case Kinds.KindName.CLASS, Kinds.KindName.RECORD, Kinds.KindName.INTERFACE, Kinds.KindName.ENUM -> 0x1000002;
            case Kinds.KindName.METHOD -> 0x4000064;
            case Kinds.KindName.MODULE -> 8389908;
            case Kinds.KindName.VAR -> 33554515;
            default -> 33554515;
        };
    }

    private int convertUndefinedMethod(Diagnostic<?> diagnostic) {
        Kinds.KindName kind;
        Type receiverArg;
        JCDiagnostic diagnosticArg = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, JCDiagnostic.class);
        if (diagnosticArg != null && (receiverArg = JavacProblemConverter.getDiagnosticArgumentByType(diagnosticArg, Type.class)).hasTag(TypeTag.ARRAY)) {
            return 0x4000074;
        }
        if ("compiler.err.cant.resolve.args".equals(diagnostic.getCode()) && (kind = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Kinds.KindName.class)) == Kinds.KindName.CONSTRUCTOR) {
            return 0x8000082;
        }
        TreePath treePath = this.getTreePath(diagnostic);
        if (treePath != null && treePath.getParentPath() != null && treePath.getParentPath().getLeaf() instanceof JCTree.JCAssign && treePath.getParentPath().getParentPath() != null && treePath.getParentPath().getParentPath().getLeaf() instanceof JCTree.JCAnnotation) {
            return 67109475;
        }
        return 0x4000064;
    }

    private static <T> T getDiagnosticArgumentByType(Diagnostic<?> diagnostic, Class<T> type) {
        if (!(diagnostic instanceof JCDiagnostic)) {
            return null;
        }
        JCDiagnostic jcDiagnostic = (JCDiagnostic)diagnostic;
        Object[] args = jcDiagnostic.getArgs();
        if (args != null) {
            for (Object arg : args) {
                if (!type.isInstance(arg)) continue;
                return type.cast(arg);
            }
        }
        return null;
    }

    private Object[] getDiagnosticArguments(Diagnostic<?> diagnostic) {
        if (!(diagnostic instanceof JCDiagnostic)) {
            return new Object[0];
        }
        JCDiagnostic jcDiagnostic = (JCDiagnostic)diagnostic;
        return jcDiagnostic.getArgs();
    }

    private String[] getDiagnosticStringArguments(Diagnostic<?> diagnostic) {
        Object object;
        if (!(diagnostic instanceof JCDiagnostic)) {
            return new String[0];
        }
        JCDiagnostic jcDiagnostic = (JCDiagnostic)diagnostic;
        if (!jcDiagnostic.getSubdiagnostics().isEmpty()) {
            jcDiagnostic = jcDiagnostic.getSubdiagnostics().get(0);
        }
        if (jcDiagnostic.getArgs().length != 0 && (object = jcDiagnostic.getArgs()[0]) instanceof JCDiagnostic) {
            JCDiagnostic argDiagnostic = (JCDiagnostic)object;
            return (String[])Stream.of(argDiagnostic.getArgs()).filter(Predicate.not(Kinds.KindName.class::isInstance)).map(Object::toString).toArray(String[]::new);
        }
        return (String[])Stream.of(jcDiagnostic.getArgs()).filter(Predicate.not(Kinds.KindName.class::isInstance)).map(Object::toString).toArray(String[]::new);
    }

    private int convertTypeMismatch(Diagnostic<?> diagnostic) {
        JCDiagnostic jcDiagnostic;
        JCDiagnostic.DiagnosticPosition diagnosticPosition;
        Diagnostic diagnosticArg = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Diagnostic.class);
        if (diagnosticArg != null) {
            if ("compiler.misc.inconvertible.types".equals(diagnosticArg.getCode())) {
                Object[] args = this.getDiagnosticArguments(diagnosticArg);
                if (args != null && args.length > 1 && args[1] instanceof Type.JCVoidType) {
                    return 67108970;
                }
                TreePath path = this.getTreePath(diagnostic);
                if (path != null && path.getParentPath() != null && path.getParentPath().getLeaf() instanceof JCTree.JCNewClass) {
                    return 0x8000082;
                }
            } else {
                if ("compiler.misc.unexpected.ret.val".equals(diagnosticArg.getCode())) {
                    return 67108969;
                }
                if ("compiler.misc.missing.ret.val".equals(diagnosticArg.getCode())) {
                    return 603979884;
                }
                if ("compiler.misc.incompatible.ret.type.in.lambda".equals(diagnosticArg.getCode())) {
                    return 603979884;
                }
            }
        }
        if (diagnostic instanceof JCDiagnostic && (diagnosticPosition = (jcDiagnostic = (JCDiagnostic)diagnostic).getDiagnosticPosition()) instanceof JCTree) {
            JCTree tree = (JCTree)diagnosticPosition;
            JCTree.JCCompilationUnit unit = this.units.get(jcDiagnostic.getSource());
            if (unit != null) {
                TreePath path = JavacTrees.instance(this.context).getPath(unit, tree);
                if (path != null) {
                    path = path.getParentPath();
                }
                if (path != null && path.getLeaf() instanceof JCTree.JCEnhancedForLoop) {
                    return 16777796;
                }
                while (path != null && path.getLeaf() instanceof JCTree.JCExpression) {
                    if (path.getLeaf() instanceof JCTree.JCMethodInvocation) {
                        return 67108979;
                    }
                    path = path.getParentPath();
                }
            }
        }
        return 0x1000011;
    }

    private TreePath getTreePath(Diagnostic<?> diagnostic) {
        JCDiagnostic jcDiagnostic;
        JCDiagnostic.DiagnosticPosition diagnosticPosition;
        if (diagnostic instanceof JCDiagnostic && (diagnosticPosition = (jcDiagnostic = (JCDiagnostic)diagnostic).getDiagnosticPosition()) instanceof JCTree) {
            JCTree tree = (JCTree)diagnosticPosition;
            JCTree.JCCompilationUnit unit = this.units.get(jcDiagnostic.getSource());
            if (unit != null) {
                return JavacTrees.instance(this.context).getPath(unit, tree);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int convertNotVisibleAccess(Diagnostic<?> diagnostic) {
        Object subDiagnostic;
        if (!(diagnostic instanceof JCDiagnostic)) return 0;
        JCDiagnostic jcDiagnostic = (JCDiagnostic)diagnostic;
        Object[] args = jcDiagnostic.getArgs();
        if (args == null) return 0;
        if (args.length <= 0) return 0;
        if (args[0] == Kinds.KindName.CONSTRUCTOR) {
            Object lastArg = args[args.length - 1];
            if (!(lastArg instanceof JCDiagnostic)) return 0x8000083;
            subDiagnostic = (JCDiagnostic)lastArg;
            args = ((JCDiagnostic)subDiagnostic).getArgs();
        }
        if ((subDiagnostic = args[0]) instanceof Symbol.MethodSymbol) {
            TreePath treePath;
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)subDiagnostic;
            if (!methodSymbol.isConstructor()) return 67108965;
            for (treePath = this.getTreePath(jcDiagnostic); treePath != null && !(treePath.getLeaf() instanceof JCTree.JCMethodDecl); treePath = treePath.getParentPath()) {
            }
            if (treePath == null) return 0x8000083;
            Tree tree = treePath.getLeaf();
            if (!(tree instanceof JCTree.JCMethodDecl)) return 0x8000083;
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)tree;
            if ((methodDecl.sym.flags() & 0x1000000000L) == 0L) return 0x8000083;
            return 0x800008D;
        }
        if (args[0] instanceof Symbol.ClassSymbol) {
            return 0x1000003;
        }
        if (!(args[0] instanceof Symbol.VarSymbol)) return 0;
        return 33554503;
    }

    private int convertAmbiguous(Diagnostic<?> diagnostic) {
        Kinds.KindName kind = JavacProblemConverter.getDiagnosticArgumentByType(diagnostic, Kinds.KindName.class);
        return switch (kind) {
            case Kinds.KindName.CLASS, Kinds.KindName.INTERFACE -> 0x1000004;
            case Kinds.KindName.METHOD -> 0x4000066;
            default -> 0;
        };
    }

    public void registerUnit(JavaFileObject javaFileObject, JCTree.JCCompilationUnit unit) {
        this.units.put(javaFileObject, unit);
    }

    private static /* synthetic */ boolean lambda$getDiagnosticPosition$0(String typeParam, JCTree.JCTypeParameter paramDecl) {
        return typeParam.equals(paramDecl.getName().toString());
    }
}

