/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle;

import com.github.badsyntax.gradle.GradleExecution;
import com.github.badsyntax.gradle.exceptions.GradleExecutionException;
import com.github.badsyntax.gradle.exceptions.ProcessException;
import com.github.badsyntax.gradle.process.Process;
import com.github.badsyntax.gradle.process.ProcessOutput;
import java.io.File;
import java.io.IOException;
import java.util.stream.Collectors;

public class GradleLocalInstallation
implements GradleExecution {
    private File localInstallation;
    private static final String GRADLE_EXECUTION_UNIX = "gradle";
    private static final String GRADLE_EXECUTION_WINDOWS = "gradle.bat";

    public GradleLocalInstallation(File localInstallation) {
        this.localInstallation = localInstallation;
    }

    @Override
    public synchronized String exec(String ... args) throws GradleExecutionException {
        try {
            if (args.length == 0) {
                throw new GradleExecutionException("No gradle args supplied");
            }
            File binFolder = this.localInstallation.toPath().resolve("bin").toFile();
            Process process = new Process(binFolder);
            process.setUnixCommand(GRADLE_EXECUTION_UNIX);
            process.setWindowsCommand(GRADLE_EXECUTION_WINDOWS);
            process.exec(args);
            ProcessOutput processOutput = process.getProcessOutput();
            String stdErrString = processOutput.getStdErr().lines().collect(Collectors.joining("\n"));
            String stdOutString = processOutput.getStdOut().lines().collect(Collectors.joining("\n"));
            process.close();
            if (stdErrString.length() > 0) {
                throw new GradleExecutionException(String.format("Error running gradle: %s", stdErrString));
            }
            return stdOutString;
        }
        catch (ProcessException | IOException e) {
            throw new GradleExecutionException(String.format("Error running gradle: %s", e.getMessage()));
        }
    }
}

