/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.IOException;
import jdk.test.lib.Asserts;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;

public class DerUtils {
    public static DerValue innerDerValue(byte[] data, String location) throws IOException {
        DerValue v = new DerValue(data);
        for (char step : location.toCharArray()) {
            if (step == 'c') {
                v = new DerValue(v.getOctetString());
                continue;
            }
            DerInputStream ins = v.getData();
            for (int i = 0; i < step - 48; ++i) {
                ins.getDerValue();
            }
            if (ins.available() > 0) {
                v = ins.getDerValue();
                continue;
            }
            return null;
        }
        return v;
    }

    public static void checkAlg(byte[] der, String location, ObjectIdentifier expected) throws Exception {
        Asserts.assertEQ(DerUtils.innerDerValue(der, location).getOID(), expected);
    }

    public static void checkAlg(byte[] der, String location, KnownOIDs expected) throws Exception {
        Asserts.assertEQ(DerUtils.innerDerValue(der, location).getOID(), ObjectIdentifier.of(expected));
    }

    public static void checkInt(byte[] der, String location, int expected) throws Exception {
        Asserts.assertEQ(DerUtils.innerDerValue(der, location).getInteger(), expected);
    }

    public static void shouldNotExist(byte[] der, String location) throws Exception {
        Asserts.assertTrue(DerUtils.innerDerValue(der, location) == null);
    }
}

