/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.swt.widgets.Shell;

class SearchAgainAction
extends Action {
    private final SearchView fView;

    public SearchAgainAction(SearchView view) {
        this.setText(SearchMessages.SearchAgainAction_label);
        this.setToolTipText(SearchMessages.SearchAgainAction_tooltip);
        SearchPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.search.ui.refresh.svg");
        this.fView = view;
    }

    public void run() {
        ISearchResult search = this.fView.getCurrentSearchResult();
        if (search != null) {
            ISearchQuery query = search.getQuery();
            NewSearchUI.cancelQuery(query);
            if (query.canRerun()) {
                if (query.canRunInBackground()) {
                    NewSearchUI.runQueryInBackground(query, this.fView);
                } else {
                    Shell shell = this.fView.getSite().getShell();
                    ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
                    IStatus status = NewSearchUI.runQueryInForeground((IRunnableContext)pmd, query, this.fView);
                    if (!status.isOK() && status.getSeverity() != 8) {
                        ErrorDialog.openError((Shell)shell, (String)SearchMessages.SearchAgainAction_Error_title, (String)SearchMessages.SearchAgainAction_Error_message, (IStatus)status);
                    }
                }
            }
        }
    }
}

