/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.ui.internal.UiPlugin;
import org.eclipse.buildship.ui.internal.i18n.UiMessages;
import org.eclipse.buildship.ui.internal.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.internal.util.layout.LayoutUtils;
import org.eclipse.buildship.ui.internal.util.selection.TargetWidgetsInvertingSelectionListener;
import org.eclipse.buildship.ui.internal.util.widget.UiBuilder;
import org.eclipse.buildship.ui.internal.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.internal.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectCreationConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectWizardMessages;
import org.eclipse.buildship.ui.internal.wizard.project.WorkingSetChangedListener;
import org.eclipse.buildship.ui.internal.wizard.project.WorkingSetConfigurationWidget;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;

public final class NewGradleProjectWizardPage
extends AbstractWizardPage {
    private final ProjectCreationConfiguration creationConfiguration;
    private Text projectNameText;
    private Button useDefaultWorkspaceLocationButton;
    private Text customLocationText;
    private WorkingSetConfigurationWidget workingSetConfigurationWidget;

    public NewGradleProjectWizardPage(ProjectImportConfiguration importConfiguration, ProjectCreationConfiguration creationConfiguration) {
        super("NewGradleProject", ProjectWizardMessages.Title_NewGradleProjectWizardPage, ProjectWizardMessages.InfoMessage_NewGradleProjectWizardPageDefault, importConfiguration, (List<Property<?>>)ImmutableList.of(creationConfiguration.getProjectName(), creationConfiguration.getCustomLocation(), creationConfiguration.getTargetProjectDir(), importConfiguration.getWorkingSets()));
        this.creationConfiguration = creationConfiguration;
    }

    @Override
    protected void createWidgets(Composite root) {
        root.setLayout((Layout)LayoutUtils.newGridLayout(3));
        this.createContent(root);
        this.bindToConfiguration();
    }

    private void createContent(Composite root) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        Composite projectNameComposite = new Composite(root, 0);
        GridLayoutFactory.swtDefaults().extendedMargins(0, 0, 0, 10).numColumns(2).applyTo(projectNameComposite);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(3, -1).applyTo((Control)projectNameComposite);
        uiBuilderFactory.newLabel(projectNameComposite).alignLeft().text(ProjectWizardMessages.Label_ProjectName).control();
        this.projectNameText = uiBuilderFactory.newText(projectNameComposite).alignFillHorizontal().control();
        Group locationGroup = uiBuilderFactory.newGroup(root).text(ProjectWizardMessages.Group_Label_ProjectLocation).control();
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)locationGroup);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(3, -1).applyTo((Control)locationGroup);
        this.useDefaultWorkspaceLocationButton = uiBuilderFactory.newCheckbox((Composite)locationGroup).text(ProjectWizardMessages.Button_UseDefaultLocation).control();
        this.useDefaultWorkspaceLocationButton.setSelection(((Boolean)this.creationConfiguration.getUseDefaultLocation().getValue()).booleanValue());
        GridDataFactory.swtDefaults().span(3, -1).applyTo((Control)this.useDefaultWorkspaceLocationButton);
        uiBuilderFactory.newLabel((Composite)locationGroup).alignLeft().text(ProjectWizardMessages.Label_CustomLocation);
        this.customLocationText = uiBuilderFactory.newText((Composite)locationGroup).text(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()).control();
        this.customLocationText.setEnabled(!this.useDefaultWorkspaceLocationButton.getSelection());
        this.customLocationText.setText(this.useDefaultWorkspaceLocationButton.getSelection() ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : (String)FileUtils.getAbsolutePath((File)((File)this.creationConfiguration.getCustomLocation().getValue())).or((Object)""));
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.customLocationText);
        Button customLocationBrowseButton = uiBuilderFactory.newButton((Composite)locationGroup).alignLeft().text(UiMessages.Button_Label_Browse).control();
        customLocationBrowseButton.setEnabled(!this.useDefaultWorkspaceLocationButton.getSelection());
        customLocationBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(root.getShell(), this.customLocationText, ProjectWizardMessages.Label_ProjectRootDirectory));
        Group workingSetGroup = uiBuilderFactory.newGroup(root).text(ProjectWizardMessages.Group_Label_WorkingSets).control();
        GridLayoutFactory.swtDefaults().applyTo((Composite)workingSetGroup);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).span(3, -1).applyTo((Control)workingSetGroup);
        this.workingSetConfigurationWidget = new WorkingSetConfigurationWidget(new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"}, UiPlugin.getInstance().getDialogSettings());
        this.workingSetConfigurationWidget.createContent((Composite)workingSetGroup);
        this.workingSetConfigurationWidget.modifyCurrentWorkingSetItem(WorkingSetUtils.toWorkingSets((List)this.getConfiguration().getWorkingSets().getValue()));
        this.workingSetConfigurationWidget.getWorkingSetsEnabledButton().setSelection(((Boolean)this.getConfiguration().getApplyWorkingSets().getValue()).booleanValue());
        this.workingSetConfigurationWidget.getWorkingSetsCombo().setEnabled(((Boolean)this.getConfiguration().getApplyWorkingSets().getValue()).booleanValue());
        this.workingSetConfigurationWidget.getWorkingSetsSelectButton().setEnabled(((Boolean)this.getConfiguration().getApplyWorkingSets().getValue()).booleanValue());
        this.useDefaultWorkspaceLocationButton.addSelectionListener((SelectionListener)new TargetWidgetsInvertingSelectionListener(this.useDefaultWorkspaceLocationButton, new Control[]{this.customLocationText, customLocationBrowseButton}));
    }

    private void bindToConfiguration() {
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewGradleProjectWizardPage.this.updateLocation();
            }
        });
        this.useDefaultWorkspaceLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String location = NewGradleProjectWizardPage.this.useDefaultWorkspaceLocationButton.getSelection() ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : (String)FileUtils.getAbsolutePath((File)((File)NewGradleProjectWizardPage.this.creationConfiguration.getCustomLocation().getValue())).or((Object)"");
                NewGradleProjectWizardPage.this.customLocationText.setText(location);
                NewGradleProjectWizardPage.this.updateLocation();
            }
        });
        this.customLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewGradleProjectWizardPage.this.updateLocation();
            }
        });
        this.workingSetConfigurationWidget.addWorkingSetChangeListener(new WorkingSetChangedListener(){

            @Override
            public void workingSetsChanged(List<IWorkingSet> workingSets) {
                List<String> workingSetNames = WorkingSetUtils.toWorkingSetNames(workingSets);
                NewGradleProjectWizardPage.this.getConfiguration().setWorkingSets(workingSetNames);
            }
        });
        this.workingSetConfigurationWidget.getWorkingSetsEnabledButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = NewGradleProjectWizardPage.this.workingSetConfigurationWidget.getWorkingSetsEnabledButton().getSelection();
                NewGradleProjectWizardPage.this.getConfiguration().setApplyWorkingSets(selected);
            }
        });
    }

    private void updateLocation() {
        File parentLocation = this.useDefaultWorkspaceLocationButton.getSelection() ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile() : (File)FileUtils.getAbsoluteFile((String)this.customLocationText.getText()).orNull();
        File projectDir = parentLocation != null ? new File(parentLocation, this.projectNameText.getText()) : null;
        this.getConfiguration().getProjectDir().setValue((Object)projectDir);
        this.creationConfiguration.setTargetProjectDir(projectDir);
        if (!this.useDefaultWorkspaceLocationButton.getSelection()) {
            this.creationConfiguration.setCustomLocation((File)FileUtils.getAbsoluteFile((String)this.customLocationText.getText()).orNull());
        }
        this.creationConfiguration.setUseDefaultLocation(this.useDefaultWorkspaceLocationButton.getSelection());
        this.creationConfiguration.setProjectName(this.projectNameText.getText());
    }
}

