/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.resources;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.oomph.internal.resources.ExternalFile;
import org.eclipse.oomph.internal.resources.ExternalFolder;
import org.eclipse.oomph.internal.resources.ExternalResource;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendFile;
import org.eclipse.oomph.resources.backend.BackendFolder;
import org.eclipse.oomph.resources.backend.BackendResource;

public abstract class ExternalContainer
extends ExternalResource
implements IContainer {
    protected ExternalContainer(ExternalContainer parent, BackendContainer backendContainer) {
        super(parent, backendContainer);
    }

    @Override
    protected BackendContainer getBackendResource() {
        return (BackendContainer)super.getBackendResource();
    }

    public int getType() {
        return 0;
    }

    public boolean exists(IPath path) {
        IResource member = this.findMember(path);
        return member.exists();
    }

    public IResource findMember(IPath path) {
        if (path.isEmpty()) {
            return this;
        }
        BackendResource member = this.getBackendResource().findMember(path, null);
        if (member != null) {
            BackendContainer thisBackendResource = this.getBackendResource();
            LinkedList<BackendResource> backendResources = new LinkedList<BackendResource>();
            BackendResource it = member;
            while (it != thisBackendResource) {
                backendResources.addFirst(it);
                it = it.getParent();
            }
            ExternalContainer container = this;
            for (BackendResource it2 : backendResources) {
                if (!it2.isContainer()) {
                    return new ExternalFile(container, (BackendFile)it2);
                }
                container = new ExternalFolder(container, (BackendFolder)it2);
            }
        }
        return null;
    }

    public IResource findMember(IPath path, boolean includePhantoms) {
        return this.findMember(path);
    }

    public IResource findMember(String path, boolean includePhantoms) {
        return this.findMember(path);
    }

    public IResource findMember(String path) {
        return this.findMember((IPath)new Path(path));
    }

    public String getDefaultCharset() throws CoreException {
        return "UTF-8";
    }

    public String getDefaultCharset(boolean checkImplicit) throws CoreException {
        return this.getDefaultCharset();
    }

    public IFile getFile(IPath path) {
        BackendFile childBackendFile = this.getBackendResource().getFile(path);
        return new ExternalFile(this, childBackendFile);
    }

    public IFolder getFolder(IPath path) {
        BackendFolder childBackendFolder = this.getBackendResource().getFolder(path);
        return new ExternalFolder(this, childBackendFolder);
    }

    public IResource[] members() throws CoreException {
        ArrayList<ExternalResource> members = new ArrayList<ExternalResource>();
        BackendResource[] backendResourceArray = this.getBackendResource().getMembers(null);
        int n = backendResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BackendResource member = backendResourceArray[n2];
            if (member.isContainer()) {
                members.add(new ExternalFolder(this, (BackendFolder)member));
            } else {
                members.add(new ExternalFile(this, (BackendFile)member));
            }
            ++n2;
        }
        return members.toArray(new IResource[members.size()]);
    }

    public IResource[] members(boolean includePhantoms) throws CoreException {
        return this.members();
    }

    public IResource[] members(int memberFlags) throws CoreException {
        return this.members();
    }

    public IFile[] findDeletedMembersWithHistory(int depth, IProgressMonitor monitor) throws CoreException {
        return new IFile[0];
    }

    @Deprecated
    public void setDefaultCharset(String charset) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public void setDefaultCharset(String charset, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public IResourceFilterDescription createFilter(int type, FileInfoMatcherDescription matcherDescription, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new ExternalResource.ReadOnlyException();
    }

    public IResourceFilterDescription[] getFilters() throws CoreException {
        return new IResourceFilterDescription[0];
    }

    @Override
    protected boolean visit(IResourceVisitor visitor, int depth) throws CoreException {
        if (!super.visit(visitor, depth) || depth < 1) {
            return false;
        }
        --depth;
        IResource[] iResourceArray = this.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            ((ExternalResource)member).visit(visitor, depth);
            ++n2;
        }
        return true;
    }
}

