/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class Digest {
    public static final String MD5_TYPE = "MD5";
    public static final String SHA1_TYPE = "SHA1";
    public static final String SHA256_TYPE = "SHA-256";
    public static final String SHA512_TYPE = "SHA-512";
    public static final Digest MD5;
    public static final Digest SHA1;
    public static final Digest SHA256;
    public static final Digest SHA512;
    public static final NullMessageDigest NULL_DIGEST;
    public static final Map<String, Digest> DIGEST_MAP;
    byte[] bitMap;
    String name;
    private MessageDigest digest;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        MD5 = new Digest(MD5_TYPE, byArray);
        byte[] byArray2 = new byte[4];
        byArray2[0] = 2;
        SHA1 = new Digest(SHA1_TYPE, byArray2);
        byte[] byArray3 = new byte[4];
        byArray3[0] = 3;
        SHA256 = new Digest(SHA256_TYPE, byArray3);
        byte[] byArray4 = new byte[4];
        byArray4[0] = 4;
        SHA512 = new Digest(SHA512_TYPE, byArray4);
        NULL_DIGEST = new NullMessageDigest("NULL");
        DIGEST_MAP = new HashMap<String, Digest>();
        DIGEST_MAP.put(Digest.MD5.name, MD5);
        DIGEST_MAP.put(Digest.SHA1.name, SHA1);
        DIGEST_MAP.put(Digest.SHA256.name, SHA256);
        DIGEST_MAP.put(Digest.SHA512.name, SHA512);
    }

    public Digest(String name, byte[] bitMap) {
        this.name = name;
        this.bitMap = bitMap;
    }

    public MessageDigest getDigest() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance(this.name);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.digest = NULL_DIGEST;
            }
        }
        return this.digest;
    }

    public byte[] getBitMap() {
        return this.bitMap;
    }

    public static class NullMessageDigest
    extends MessageDigest {
        public NullMessageDigest(String algorithm) {
            super(algorithm);
        }

        @Override
        protected byte[] engineDigest() {
            return null;
        }

        @Override
        protected void engineReset() {
        }

        @Override
        protected void engineUpdate(byte input) {
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
        }

        @Override
        public byte[] digest() {
            return null;
        }
    }
}

