/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.draw2d.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class MouseAwareImageFigure
extends ImageFigure {
    private static final Point LEFT_TOP_CORNER = new Point(0, 0);
    protected Image imageWOFocus;
    protected Image imageWFocus;
    private Dimension size;

    public MouseAwareImageFigure() {
        this.init();
    }

    public MouseAwareImageFigure(Image imageWOFocus) {
        super(imageWOFocus);
        this.imageWOFocus = imageWOFocus;
        this.init();
    }

    public MouseAwareImageFigure(Image imageWOFocus, Image imageWFocus) {
        super(imageWOFocus);
        this.imageWOFocus = imageWOFocus;
        this.imageWFocus = imageWFocus;
        this.init();
    }

    private void init() {
        this.size = new Dimension();
        this.addMouseMotionListener(new ToggleImage());
    }

    public void setImageWFocus(Image imageWFocus) {
        this.imageWFocus = imageWFocus;
    }

    public Image getImageWFocus() {
        return this.imageWFocus;
    }

    public void setImageWOFocus(Image imageWOFocus) {
        this.setImage(imageWOFocus);
        this.imageWOFocus = imageWOFocus;
    }

    public Image getImageWOFocus() {
        return this.imageWOFocus;
    }

    protected void paintFigure(Graphics graphics) {
        graphics.drawImage(this.getImage(), new Rectangle(LEFT_TOP_CORNER, super.getPreferredSize(0, 0)), new Rectangle(this.getLocation(), this.getSize()));
    }

    public void setSize(int w, int h) {
        this.size.setWidth(w);
        this.size.setHeight(h);
    }

    public Rectangle getBounds() {
        Rectangle realBounds = new Rectangle(super.getBounds());
        realBounds.setSize(this.size);
        return realBounds;
    }

    public Dimension getPreferredSize(int hint, int hint2) {
        return this.size;
    }

    private final class ToggleImage
    implements MouseMotionListener {
        private ToggleImage() {
        }

        public void mouseDragged(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
            if (MouseAwareImageFigure.this.imageWFocus != null) {
                MouseAwareImageFigure.this.setImage(MouseAwareImageFigure.this.imageWFocus);
            }
        }

        public void mouseExited(MouseEvent me) {
            MouseAwareImageFigure.this.setImage(MouseAwareImageFigure.this.imageWOFocus);
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }
    }
}

