/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.Optional;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAndLabelCommmand;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SetConnectionBendpointsAccordingToExtremityMoveCommmand
extends SetConnectionBendpointsAndLabelCommmand {
    private boolean sourceMove;
    private PrecisionPoint moveDelta;

    public SetConnectionBendpointsAccordingToExtremityMoveCommmand(TransactionalEditingDomain editingDomain) {
        super(editingDomain);
    }

    @Override
    public void setLabelsToUpdate(ConnectionEditPart connectionEditPart) {
        ConnectionEditPart gmfConnectionEditPart = connectionEditPart;
        GraphicalHelper.appliedZoomOnRelativePoint((IGraphicalEditPart)gmfConnectionEditPart, (Point)this.moveDelta);
        Connection connection = gmfConnectionEditPart.getConnectionFigure();
        Point tempSourceRefPoint = connection.getSourceAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)tempSourceRefPoint);
        Point tempTargetRefPoint = connection.getTargetAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)tempTargetRefPoint);
        PointList connectionPointList = connection.getPoints().getCopy();
        SetConnectionBendpointsAccordingToExtremityMoveCommmand.adaptPointListAndRefPoints(this.sourceMove, (Point)this.moveDelta, (org.eclipse.gef.ConnectionEditPart)connectionEditPart, tempSourceRefPoint, tempTargetRefPoint, connectionPointList);
        this.setNewPointList(connectionPointList, tempSourceRefPoint, tempTargetRefPoint);
        super.setLabelsToUpdate(connectionEditPart);
    }

    public static void adaptPointListAndRefPoints(boolean sourceMove, Point moveDelta, org.eclipse.gef.ConnectionEditPart connectionEditPart, Point sourceRefPoint, Point targetRefPoint, PointList connectionPointList) {
        int nbModelPoints;
        int nbVisualPoints;
        ConnectionEditPartQuery connectionEditPartQuery = new ConnectionEditPartQuery(connectionEditPart);
        if (connectionEditPart.getModel() instanceof Edge && ((Edge)connectionEditPart.getModel()).getBendpoints() instanceof RelativeBendpoints && (nbVisualPoints = connectionPointList.size()) > (nbModelPoints = ((RelativeBendpoints)((Edge)connectionEditPart.getModel()).getBendpoints()).getPoints().size()) && nbModelPoints == 2 && connectionEditPartQuery.checkShapesIntersect()) {
            int i = 0;
            while (i < nbVisualPoints - 2) {
                connectionPointList.removePoint(1);
                ++i;
            }
        }
        PrecisionRectangle sourceBounds = new PrecisionRectangle(GraphicalHelper.getAbsoluteBoundsWithoutLabelsIn100Percent((GraphicalEditPart)((IGraphicalEditPart)connectionEditPart.getSource())));
        PrecisionRectangle targetBounds = new PrecisionRectangle(GraphicalHelper.getAbsoluteBoundsWithoutLabelsIn100Percent((GraphicalEditPart)((IGraphicalEditPart)connectionEditPart.getTarget())));
        boolean isEdgeWithRectilinearRoutingStyle = connectionEditPartQuery.isEdgeWithRectilinearRoutingStyle();
        if (sourceMove) {
            SetConnectionBendpointsAccordingToExtremityMoveCommmand.moveFirstSegmentAndRefPointAccordingToSourceMove(moveDelta, isEdgeWithRectilinearRoutingStyle, sourceBounds, targetBounds, sourceRefPoint, targetRefPoint, connectionPointList);
        } else {
            SetConnectionBendpointsAccordingToExtremityMoveCommmand.moveLastSegmentAndRefPointAccordingToTargetMove(moveDelta, isEdgeWithRectilinearRoutingStyle, sourceBounds, targetBounds, sourceRefPoint, targetRefPoint, connectionPointList);
        }
    }

    private static void moveFirstSegmentAndRefPointAccordingToSourceMove(Point moveDelta, boolean isEdgeWithRectilinearRoutingStyle, PrecisionRectangle sourceBounds, PrecisionRectangle targetBounds, Point sourceRefPoint, Point targetRefPoint, PointList connectionPointList) {
        sourceRefPoint.performTranslate(moveDelta.x, moveDelta.y);
        if (isEdgeWithRectilinearRoutingStyle) {
            LineSeg firstSegment = new LineSeg(connectionPointList.getPoint(0), connectionPointList.getPoint(1));
            if (firstSegment.isHorizontal()) {
                connectionPointList.setPoint(connectionPointList.getPoint(0).translate(moveDelta.x, moveDelta.y), 0);
                connectionPointList.setPoint(connectionPointList.getPoint(1).translate(0, moveDelta.y), 1);
            } else {
                connectionPointList.setPoint(connectionPointList.getPoint(0).translate(moveDelta.x, moveDelta.y), 0);
                connectionPointList.setPoint(connectionPointList.getPoint(1).translate(moveDelta.x, 0), 1);
            }
            SetConnectionBendpointsAccordingToExtremityMoveCommmand.normalizeAndStraight(connectionPointList);
            if (connectionPointList.size() > 2) {
                SetConnectionBendpointsAccordingToExtremityMoveCommmand.removePointsInViews(connectionPointList, (PrecisionRectangle)sourceBounds.getTranslated(moveDelta), sourceRefPoint, targetBounds, targetRefPoint);
            }
        } else if (connectionPointList.size() > 2) {
            Optional intersectionPoint = GraphicalHelper.getIntersection((Point)sourceRefPoint, (Point)connectionPointList.getPoint(1), (Rectangle)sourceBounds.getTranslated(moveDelta), (boolean)false);
            if (intersectionPoint.isPresent()) {
                connectionPointList.setPoint((Point)intersectionPoint.get(), 0);
            } else {
                connectionPointList.setPoint(connectionPointList.getPoint(0).translate(moveDelta), 0);
            }
        } else {
            Optional sourceIntersectionPoint = GraphicalHelper.getIntersection((Point)sourceRefPoint, (Point)targetRefPoint, (Rectangle)sourceBounds.getTranslated(moveDelta), (boolean)false);
            if (sourceIntersectionPoint.isPresent()) {
                connectionPointList.setPoint((Point)sourceIntersectionPoint.get(), 0);
            } else {
                connectionPointList.setPoint(connectionPointList.getPoint(0).translate(moveDelta), 0);
            }
            Optional targetIntersectionPoint = GraphicalHelper.getIntersection((Point)sourceRefPoint, (Point)targetRefPoint, (Rectangle)targetBounds, (boolean)false);
            if (targetIntersectionPoint.isPresent()) {
                connectionPointList.setPoint((Point)targetIntersectionPoint.get(), 1);
            }
        }
    }

    private static void moveLastSegmentAndRefPointAccordingToTargetMove(Point moveDelta, boolean isEdgeWithRectilinearRoutingStyle, PrecisionRectangle sourceBounds, PrecisionRectangle targetBounds, Point sourceRefPoint, Point targetRefPoint, PointList connectionPointList) {
        targetRefPoint.performTranslate(moveDelta.x, moveDelta.y);
        if (isEdgeWithRectilinearRoutingStyle) {
            LineSeg lastSegment = new LineSeg(connectionPointList.getPoint(connectionPointList.size() - 2), connectionPointList.getPoint(connectionPointList.size() - 1));
            if (lastSegment.isHorizontal()) {
                connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 2).translate(0, moveDelta.y), connectionPointList.size() - 2);
                connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 1).translate(moveDelta.x, moveDelta.y), connectionPointList.size() - 1);
            } else {
                connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 2).translate(moveDelta.x, 0), connectionPointList.size() - 2);
                connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 1).translate(moveDelta.x, moveDelta.y), connectionPointList.size() - 1);
            }
            SetConnectionBendpointsAccordingToExtremityMoveCommmand.normalizeAndStraight(connectionPointList);
            if (connectionPointList.size() > 2) {
                SetConnectionBendpointsAccordingToExtremityMoveCommmand.removePointsInViews(connectionPointList, sourceBounds, sourceRefPoint, (PrecisionRectangle)targetBounds.getTranslated(moveDelta), targetRefPoint);
            }
        } else if (connectionPointList.size() > 2) {
            Optional intersectionPoint = GraphicalHelper.getIntersection((Point)targetRefPoint, (Point)connectionPointList.getPoint(connectionPointList.size() - 2), (Rectangle)targetBounds.getTranslated(moveDelta), (boolean)false);
            if (intersectionPoint.isPresent()) {
                connectionPointList.setPoint((Point)intersectionPoint.get(), connectionPointList.size() - 1);
            } else {
                connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 1).translate(moveDelta), connectionPointList.size() - 1);
            }
        } else {
            Optional targetIntersectionPoint;
            Optional sourceIntersectionPoint = GraphicalHelper.getIntersection((Point)sourceRefPoint, (Point)targetRefPoint, (Rectangle)sourceBounds, (boolean)false);
            if (sourceIntersectionPoint.isPresent()) {
                connectionPointList.setPoint((Point)sourceIntersectionPoint.get(), connectionPointList.size() - 2);
            }
            if ((targetIntersectionPoint = GraphicalHelper.getIntersection((Point)sourceRefPoint, (Point)targetRefPoint, (Rectangle)targetBounds.getTranslated(moveDelta), (boolean)false)).isPresent()) {
                connectionPointList.setPoint((Point)targetIntersectionPoint.get(), connectionPointList.size() - 1);
            } else {
                connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 1).translate(moveDelta), connectionPointList.size() - 1);
            }
        }
    }

    private static void normalizeAndStraight(PointList connectionPointList) {
        if (PointListUtilities.normalizeSegments((PointList)connectionPointList, (int)3)) {
            SetConnectionBendpointsAccordingToExtremityMoveCommmand.normalizeToStraightLineTolerance(connectionPointList, 3);
        }
    }

    private static void normalizeToStraightLineTolerance(PointList line, int tolerance) {
        int i = 0;
        while (i < line.size() - 1) {
            Point pt1 = line.getPoint(i);
            Point pt2 = line.getPoint(i + 1);
            if (Math.abs(pt1.x - pt2.x) < tolerance) {
                line.setPoint(new Point(pt1.x, pt2.y), i + 1);
            } else if (Math.abs(pt1.y - pt2.y) < tolerance) {
                line.setPoint(new Point(pt2.x, pt1.y), i + 1);
            }
            ++i;
        }
    }

    private static void removePointsInViews(PointList newLine, PrecisionRectangle source, Point start, PrecisionRectangle target, Point end) {
        PointList initialLine = newLine.getCopy();
        Point lastRemovedFromSource = SetConnectionBendpointsAccordingToExtremityMoveCommmand.removePointsWithinSourceShape(newLine, source);
        Point lastRemovedFromTarget = SetConnectionBendpointsAccordingToExtremityMoveCommmand.removePointsWithinTargetShape(newLine, target);
        Dimension tolerance = new Dimension(1, 0);
        int toleranceValue = tolerance.width;
        if (newLine.size() == 0) {
            boolean allPointsWithinAShape = false;
            if (lastRemovedFromSource == null) {
                lastRemovedFromSource = start;
                allPointsWithinAShape = true;
            }
            if (lastRemovedFromTarget == null) {
                lastRemovedFromTarget = end;
                allPointsWithinAShape = true;
            }
            if (allPointsWithinAShape) {
                SetConnectionBendpointsAccordingToExtremityMoveCommmand.handleAllPointsWithinAShape(newLine, start, target, initialLine, toleranceValue);
            } else {
                if (Math.abs(lastRemovedFromSource.x - lastRemovedFromTarget.x) < toleranceValue) {
                    if (source.preciseY() < target.preciseY()) {
                        newLine.addPoint(lastRemovedFromSource.x, (source.getBottom().y + target.getTop().y) / 2);
                    } else {
                        newLine.addPoint(lastRemovedFromSource.x, (source.getTop().y + target.getBottom().y) / 2);
                    }
                } else if (Math.abs(lastRemovedFromSource.y - lastRemovedFromTarget.y) < toleranceValue) {
                    if (source.preciseX() < target.preciseX()) {
                        newLine.addPoint((source.getRight().x + target.getLeft().x) / 2, lastRemovedFromSource.y);
                    } else {
                        newLine.addPoint((source.getLeft().x + target.getRight().x) / 2, lastRemovedFromSource.y);
                    }
                }
                newLine.addPoint(end);
            }
        } else {
            Optional<Point> optionalIntersection;
            if (lastRemovedFromSource != null && (optionalIntersection = SetConnectionBendpointsAccordingToExtremityMoveCommmand.getComplementaryPoint(newLine, source, lastRemovedFromSource, newLine.getFirstPoint(), toleranceValue)).isPresent()) {
                newLine.insertPoint(optionalIntersection.get(), 0);
            }
            if (lastRemovedFromTarget != null && (optionalIntersection = SetConnectionBendpointsAccordingToExtremityMoveCommmand.getComplementaryPoint(newLine, target, lastRemovedFromTarget, newLine.getLastPoint(), toleranceValue)).isPresent()) {
                newLine.addPoint(optionalIntersection.get());
            }
        }
    }

    private static Point removePointsWithinTargetShape(PointList newLine, PrecisionRectangle target) {
        Point lastRemovedFromTarget = null;
        PointList targetPointList = PointListUtilities.createPointsFromRect((Rectangle)target);
        if (newLine.size() != 0) {
            int nbIncludedPoints = 0;
            int i = newLine.size() - 1;
            while (i >= 0 && targetPointList.polygonContainsPoint(newLine.getPoint((int)i).x, newLine.getPoint((int)i).y)) {
                ++nbIncludedPoints;
                --i;
            }
            if (nbIncludedPoints > 1 || nbIncludedPoints == 1 && newLine.size() > 1 && SetConnectionBendpointsAccordingToExtremityMoveCommmand.isAnotherIntersection(newLine.getLastPoint(), newLine.getPoint(newLine.size() - 2), targetPointList)) {
                i = 0;
                while (i < nbIncludedPoints) {
                    lastRemovedFromTarget = newLine.removePoint(newLine.size() - 1);
                    ++i;
                }
            }
        }
        return lastRemovedFromTarget;
    }

    private static Point removePointsWithinSourceShape(PointList newLine, PrecisionRectangle source) {
        Point lastRemovedFromSource = null;
        PointList sourcePointList = PointListUtilities.createPointsFromRect((Rectangle)source);
        if (newLine.size() != 0) {
            int nbIncludedPoints = 0;
            int i = 0;
            while (i < newLine.size() && sourcePointList.polygonContainsPoint(newLine.getPoint((int)i).x, newLine.getPoint((int)i).y)) {
                ++nbIncludedPoints;
                ++i;
            }
            if (nbIncludedPoints > 1 || nbIncludedPoints == 1 && newLine.size() > 1 && SetConnectionBendpointsAccordingToExtremityMoveCommmand.isAnotherIntersection(newLine.getFirstPoint(), newLine.getPoint(1), sourcePointList)) {
                i = 0;
                while (i < nbIncludedPoints) {
                    lastRemovedFromSource = newLine.removePoint(0);
                    ++i;
                }
            }
        }
        return lastRemovedFromSource;
    }

    private static void handleAllPointsWithinAShape(PointList newLine, Point start, PrecisionRectangle target, PointList initialLine, int toleranceValue) {
        newLine.addPoint(start);
        if (Math.abs(initialLine.getFirstPoint().x - initialLine.getPoint((int)1).x) < toleranceValue) {
            if (Math.abs(start.y - target.getTop().y) < Math.abs(start.y - target.getBottom().y)) {
                newLine.addPoint(start.x, target.getTop().y);
            } else {
                newLine.addPoint(start.x, target.getBottom().y);
            }
        } else if (Math.abs(start.x - target.getLeft().x) < Math.abs(start.x - target.getRight().x)) {
            newLine.addPoint(target.getLeft().x, start.y);
        } else {
            newLine.addPoint(target.getRight().x, start.y);
        }
    }

    private static Optional<Point> getComplementaryPoint(PointList pointsList, PrecisionRectangle nodeBouds, Point lastRemoved, Point otherPointExtremity, int toleranceValue) {
        Optional optionalIntersection = Math.abs(lastRemoved.x - otherPointExtremity.x) < toleranceValue ? (lastRemoved.preciseY() < otherPointExtremity.preciseY() ? GraphicalHelper.getIntersection((Point)lastRemoved, (Point)otherPointExtremity, (Rectangle)nodeBouds, (boolean)false) : GraphicalHelper.getIntersection((Point)otherPointExtremity, (Point)lastRemoved, (Rectangle)nodeBouds, (boolean)true)) : (lastRemoved.preciseX() < otherPointExtremity.preciseX() ? GraphicalHelper.getIntersection((Point)lastRemoved, (Point)otherPointExtremity, (Rectangle)nodeBouds, (boolean)false) : GraphicalHelper.getIntersection((Point)otherPointExtremity, (Point)lastRemoved, (Rectangle)nodeBouds, (boolean)true));
        return optionalIntersection;
    }

    private static boolean isAnotherIntersection(Point origin, Point terminus, PointList pointList) {
        PointList line = new PointList();
        line.addPoint(origin);
        line.addPoint(terminus);
        PointList distances = new PointList();
        PointList intersections = new PointList();
        PointListUtilities.findIntersections((PointList)line, (PointList)pointList, (PointList)intersections, (PointList)distances);
        return intersections.size() > 1;
    }

    public void setSourceMove(boolean sourceMove) {
        this.sourceMove = sourceMove;
        if (sourceMove) {
            this.setLabel(Messages.SetConnectionBendpointsAccordingToExtremityMoveCommmand_sourceSidedLabel);
        } else {
            this.setLabel(Messages.SetConnectionBendpointsAccordingToExtremityMoveCommmand_targetSidedLabel);
        }
    }

    public void setMoveDelta(PrecisionPoint moveDelta) {
        this.moveDelta = new PrecisionPoint((Point)moveDelta);
    }
}

