/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.search.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.core.search.scope.WorkingSetSearchScope;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.search.actions.WSDLFindReferencesAction;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.search.XSDSearchQuery;

public class WSDLFindReferencesInWorkingSetAction
extends WSDLFindReferencesAction {
    public WSDLFindReferencesInWorkingSetAction(IEditorPart editor) {
        super(editor);
    }

    @Override
    public void run() {
        IWorkingSet[] workingSets = WSDLFindReferencesInWorkingSetAction.queryWorkingSets();
        if (workingSets == null || workingSets.length == 0) {
            return;
        }
        String pattern = "";
        WSDLBaseAdapter component = this.getWSDLNamedComponent();
        IFile file = this.getCurrentFile();
        QualifiedName[] names = this.determineMetaAndQualifiedName(component);
        if (file != null && component != null) {
            WorkingSetSearchScope scope = new WorkingSetSearchScope();
            int i = 0;
            while (i < workingSets.length) {
                IAdaptable[] elements = workingSets[i].getElements();
                scope.addAWorkingSetToScope(elements);
                ++i;
            }
            String scopeDescription = "Working Set";
            XSDSearchQuery searchQuery = new XSDSearchQuery(pattern, file, names[1], names[0], 2, (SearchScope)scope, scopeDescription);
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
        }
    }

    public static IWorkingSet[] queryWorkingSets() {
        IWorkingSet[] workingSets;
        Shell shell = XSDEditorPlugin.getShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }
}

