/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.pagedesigner.commands.single.AddSubNodeCommand;
import org.eclipse.jst.pagedesigner.commands.single.ChangeAttributeCommand;
import org.eclipse.jst.pagedesigner.commands.single.RemoveSubNodeCommand;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.properties.BaseCustomSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSFHtmlOutputFormatParamsSection
extends BaseCustomSection {
    private Table _paramTable;
    private TableViewer _paramViewer;
    private Button _paramAddButton;
    private Button _paramRemoveButton;
    private String[] _columnNames = new String[]{"name", "value"};

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite top = factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        top.setLayout((Layout)layout);
        this.createParamPart(factory, top);
    }

    private void createParamPart(TabbedPropertySheetWidgetFactory factory, Composite other) {
        Label label = factory.createLabel(other, SectionResources.getString("JSFHtmlOutputFormatSection.Parameters"));
        GridData data = new GridData(4);
        data.horizontalSpan = 4;
        label.setLayoutData((Object)data);
        this._paramTable = factory.createTable(other, 65538);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 3;
        data.heightHint = 50;
        this._paramTable.setHeaderVisible(true);
        this._paramTable.setLinesVisible(true);
        this._paramTable.setLayoutData((Object)data);
        TableColumn column = new TableColumn(this._paramTable, 0);
        column.setText(SectionResources.getString("JSFHtmlOutputFormatSection.ColName"));
        column.setWidth(100);
        column = new TableColumn(this._paramTable, 0);
        column.setText(SectionResources.getString("JSFHtmlOutputFormatSection.ColValue"));
        column.setWidth(100);
        this._paramViewer = new TableViewer(this._paramTable);
        this._paramViewer.setColumnProperties(this._columnNames);
        CellEditor[] editors = new CellEditor[this._columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this._paramTable);
        editors[0] = textEditor;
        textEditor = new TextCellEditor((Composite)this._paramTable);
        editors[1] = textEditor;
        this._paramViewer.setCellEditors(editors);
        this._paramViewer.setCellModifier((ICellModifier)new ParamCellModifier());
        this._paramViewer.setContentProvider((IContentProvider)new ParamCotentLabelProvider());
        this._paramViewer.setLabelProvider((IBaseLabelProvider)new ParamCotentLabelProvider());
        this._paramViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    IDOMElement node = (IDOMElement)selection.getFirstElement();
                    JSFHtmlOutputFormatParamsSection.this.gotoNode((Node)node);
                }
            }
        });
        this._paramViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this._paramAddButton = factory.createButton(other, SectionResources.getString("JSFHtmlOutputTextSection.Add"), 0);
        data = new GridData(256);
        this._paramAddButton.setLayoutData((Object)data);
        this._paramAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("name", "name");
                attributes.put("value", "value");
                AddSubNodeCommand c = new AddSubNodeCommand(SectionResources.getString("JSFHtmlOutputFormatSection.CommandLabel.AddSubTag"), JSFHtmlOutputFormatParamsSection.this._element, "param", "http://java.sun.com/jsf/core", attributes);
                c.execute();
                JSFHtmlOutputFormatParamsSection.this._paramViewer.refresh();
            }
        });
        this._paramRemoveButton = factory.createButton(other, SectionResources.getString("JSFHtmlOutputTextSection.Remove"), 0);
        data = new GridData(256);
        this._paramRemoveButton.setLayoutData((Object)data);
        this._paramRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JSFHtmlOutputFormatParamsSection.this._paramViewer.getSelection();
                if (selection != null) {
                    for (IDOMElement node : selection) {
                        RemoveSubNodeCommand c = new RemoveSubNodeCommand(SectionResources.getString("JSFHtmlOutputFormatSection.CommandLabel.RemoveSubTag"), JSFHtmlOutputFormatParamsSection.this._element, node);
                        c.execute();
                    }
                    JSFHtmlOutputFormatParamsSection.this._paramViewer.refresh();
                }
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this._paramViewer.setInput((Object)this._element);
    }

    private List getColumnNames() {
        return Arrays.asList(this._columnNames);
    }

    protected void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this._paramViewer != null && !this._paramViewer.getControl().isDisposed()) {
            this._paramViewer.refresh();
        }
    }

    private class ParamCellModifier
    implements ICellModifier {
        private ParamCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            int columnIndex = JSFHtmlOutputFormatParamsSection.this.getColumnNames().indexOf(property);
            String result = null;
            IDOMElement node = (IDOMElement)element;
            switch (columnIndex) {
                case 0: {
                    result = node.getAttribute("name");
                    break;
                }
                case 1: {
                    result = node.getAttribute("value");
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result != null ? result : "";
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = JSFHtmlOutputFormatParamsSection.this.getColumnNames().indexOf(property);
            TableItem item = (TableItem)element;
            IDOMElement node = (IDOMElement)item.getData();
            switch (columnIndex) {
                case 0: {
                    String valueString = ((String)value).trim();
                    ChangeAttributeCommand c = new ChangeAttributeCommand(SectionResources.getString("JSFHtmlOutputFormatSection.CommandLabel.ChangeAttribute"), node, "name", valueString);
                    c.execute();
                    break;
                }
                case 1: {
                    String valueString = ((String)value).trim();
                    ChangeAttributeCommand c = new ChangeAttributeCommand(SectionResources.getString("JSFHtmlOutputFormatSection.CommandLabel.ChangeAttribute"), node, "value", valueString);
                    c.execute();
                    break;
                }
            }
            JSFHtmlOutputFormatParamsSection.this._paramViewer.setInput((Object)JSFHtmlOutputFormatParamsSection.this._element);
        }
    }

    private class ParamCotentLabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private ParamCotentLabelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IDOMElement root = JSFHtmlOutputFormatParamsSection.this._element;
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList children = root.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                IDOMElement element;
                String nodeName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (nodeName = (element = (IDOMElement)child).getNodeName()).indexOf("param") != -1) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return new Object[0];
            }
            return result.toArray(new IDOMElement[result.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IDOMElement) {
                IDOMElement node = (IDOMElement)element;
                switch (columnIndex) {
                    case 0: {
                        result = node.getAttribute("name");
                        break;
                    }
                    case 1: {
                        result = node.getAttribute("value");
                        break;
                    }
                }
            }
            return result != null ? result : "";
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

