/*******************************************************************************
 * Copyright (c) 2008-2010 Sonatype, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *      Sonatype, Inc. - initial API and implementation
 *******************************************************************************/

/**
 * <copyright>
 * </copyright>
 *
 * $Id: PomSwitch.java 20588 2008-12-04 17:59:55Z jerdfelt $
 */

package org.eclipse.m2e.model.edit.pom.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.m2e.model.edit.pom.Activation;
import org.eclipse.m2e.model.edit.pom.ActivationFile;
import org.eclipse.m2e.model.edit.pom.ActivationOS;
import org.eclipse.m2e.model.edit.pom.ActivationProperty;
import org.eclipse.m2e.model.edit.pom.Build;
import org.eclipse.m2e.model.edit.pom.BuildBase;
import org.eclipse.m2e.model.edit.pom.CiManagement;
import org.eclipse.m2e.model.edit.pom.Configuration;
import org.eclipse.m2e.model.edit.pom.Contributor;
import org.eclipse.m2e.model.edit.pom.Dependency;
import org.eclipse.m2e.model.edit.pom.DependencyManagement;
import org.eclipse.m2e.model.edit.pom.DeploymentRepository;
import org.eclipse.m2e.model.edit.pom.Developer;
import org.eclipse.m2e.model.edit.pom.DistributionManagement;
import org.eclipse.m2e.model.edit.pom.DocumentRoot;
import org.eclipse.m2e.model.edit.pom.Exclusion;
import org.eclipse.m2e.model.edit.pom.Extension;
import org.eclipse.m2e.model.edit.pom.IssueManagement;
import org.eclipse.m2e.model.edit.pom.License;
import org.eclipse.m2e.model.edit.pom.MailingList;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.Notifier;
import org.eclipse.m2e.model.edit.pom.Organization;
import org.eclipse.m2e.model.edit.pom.Parent;
import org.eclipse.m2e.model.edit.pom.Plugin;
import org.eclipse.m2e.model.edit.pom.PluginExecution;
import org.eclipse.m2e.model.edit.pom.PluginManagement;
import org.eclipse.m2e.model.edit.pom.PomPackage;
import org.eclipse.m2e.model.edit.pom.Prerequisites;
import org.eclipse.m2e.model.edit.pom.Profile;
import org.eclipse.m2e.model.edit.pom.PropertyElement;
import org.eclipse.m2e.model.edit.pom.Relocation;
import org.eclipse.m2e.model.edit.pom.ReportPlugin;
import org.eclipse.m2e.model.edit.pom.ReportSet;
import org.eclipse.m2e.model.edit.pom.Reporting;
import org.eclipse.m2e.model.edit.pom.Repository;
import org.eclipse.m2e.model.edit.pom.RepositoryPolicy;
import org.eclipse.m2e.model.edit.pom.Resource;
import org.eclipse.m2e.model.edit.pom.Scm;
import org.eclipse.m2e.model.edit.pom.Site;


/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance hierarchy. It supports the call
 * {@link #doSwitch(EObject) doSwitch(object)} to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the inheritance hierarchy until a non-null result is
 * returned, which is the result of the switch. <!-- end-user-doc -->
 *
 * @see org.eclipse.m2e.model.edit.pom.PomPackage
 * @generated
 */
public class PomSwitch<T> {
  /**
   * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @generated
   */
  protected static PomPackage modelPackage;

  /**
   * Creates an instance of the switch. <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @generated
   */
  public PomSwitch() {
    if(modelPackage == null) {
      modelPackage = PomPackage.eINSTANCE;
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  public T doSwitch(EObject theEObject) {
    return doSwitch(theEObject.eClass(), theEObject);
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(EClass theEClass, EObject theEObject) {
    if(theEClass.eContainer() == modelPackage) {
      return doSwitch(theEClass.getClassifierID(), theEObject);
    }
    List<EClass> eSuperTypes = theEClass.getESuperTypes();
    return eSuperTypes.isEmpty() ? defaultCase(theEObject) : doSwitch(eSuperTypes.get(0), theEObject);
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   *
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(int classifierID, EObject theEObject) {
    switch(classifierID) {
      case PomPackage.ACTIVATION: {
        Activation activation = (Activation) theEObject;
        T result = caseActivation(activation);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.ACTIVATION_FILE: {
        ActivationFile activationFile = (ActivationFile) theEObject;
        T result = caseActivationFile(activationFile);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.ACTIVATION_OS: {
        ActivationOS activationOS = (ActivationOS) theEObject;
        T result = caseActivationOS(activationOS);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.ACTIVATION_PROPERTY: {
        ActivationProperty activationProperty = (ActivationProperty) theEObject;
        T result = caseActivationProperty(activationProperty);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.BUILD: {
        Build build = (Build) theEObject;
        T result = caseBuild(build);
        if(result == null)
          result = caseBuildBase(build);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.BUILD_BASE: {
        BuildBase buildBase = (BuildBase) theEObject;
        T result = caseBuildBase(buildBase);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.CI_MANAGEMENT: {
        CiManagement ciManagement = (CiManagement) theEObject;
        T result = caseCiManagement(ciManagement);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.CONTRIBUTOR: {
        Contributor contributor = (Contributor) theEObject;
        T result = caseContributor(contributor);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.DEPENDENCY: {
        Dependency dependency = (Dependency) theEObject;
        T result = caseDependency(dependency);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.DEPENDENCY_MANAGEMENT: {
        DependencyManagement dependencyManagement = (DependencyManagement) theEObject;
        T result = caseDependencyManagement(dependencyManagement);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.DEPLOYMENT_REPOSITORY: {
        DeploymentRepository deploymentRepository = (DeploymentRepository) theEObject;
        T result = caseDeploymentRepository(deploymentRepository);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.DEVELOPER: {
        Developer developer = (Developer) theEObject;
        T result = caseDeveloper(developer);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.DISTRIBUTION_MANAGEMENT: {
        DistributionManagement distributionManagement = (DistributionManagement) theEObject;
        T result = caseDistributionManagement(distributionManagement);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.DOCUMENT_ROOT: {
        DocumentRoot documentRoot = (DocumentRoot) theEObject;
        T result = caseDocumentRoot(documentRoot);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.EXCLUSION: {
        Exclusion exclusion = (Exclusion) theEObject;
        T result = caseExclusion(exclusion);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.EXTENSION: {
        Extension extension = (Extension) theEObject;
        T result = caseExtension(extension);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.ISSUE_MANAGEMENT: {
        IssueManagement issueManagement = (IssueManagement) theEObject;
        T result = caseIssueManagement(issueManagement);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.LICENSE: {
        License license = (License) theEObject;
        T result = caseLicense(license);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.MAILING_LIST: {
        MailingList mailingList = (MailingList) theEObject;
        T result = caseMailingList(mailingList);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.MODEL: {
        Model model = (Model) theEObject;
        T result = caseModel(model);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.NOTIFIER: {
        Notifier notifier = (Notifier) theEObject;
        T result = caseNotifier(notifier);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.ORGANIZATION: {
        Organization organization = (Organization) theEObject;
        T result = caseOrganization(organization);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.PARENT: {
        Parent parent = (Parent) theEObject;
        T result = caseParent(parent);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.PLUGIN: {
        Plugin plugin = (Plugin) theEObject;
        T result = casePlugin(plugin);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.PLUGIN_EXECUTION: {
        PluginExecution pluginExecution = (PluginExecution) theEObject;
        T result = casePluginExecution(pluginExecution);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.PLUGIN_MANAGEMENT: {
        PluginManagement pluginManagement = (PluginManagement) theEObject;
        T result = casePluginManagement(pluginManagement);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.PREREQUISITES: {
        Prerequisites prerequisites = (Prerequisites) theEObject;
        T result = casePrerequisites(prerequisites);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.PROFILE: {
        Profile profile = (Profile) theEObject;
        T result = caseProfile(profile);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.RELOCATION: {
        Relocation relocation = (Relocation) theEObject;
        T result = caseRelocation(relocation);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.REPORTING: {
        Reporting reporting = (Reporting) theEObject;
        T result = caseReporting(reporting);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.REPORT_PLUGIN: {
        ReportPlugin reportPlugin = (ReportPlugin) theEObject;
        T result = caseReportPlugin(reportPlugin);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.REPORT_SET: {
        ReportSet reportSet = (ReportSet) theEObject;
        T result = caseReportSet(reportSet);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.REPOSITORY: {
        Repository repository = (Repository) theEObject;
        T result = caseRepository(repository);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.REPOSITORY_POLICY: {
        RepositoryPolicy repositoryPolicy = (RepositoryPolicy) theEObject;
        T result = caseRepositoryPolicy(repositoryPolicy);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.RESOURCE: {
        Resource resource = (Resource) theEObject;
        T result = caseResource(resource);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.SCM: {
        Scm scm = (Scm) theEObject;
        T result = caseScm(scm);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.SITE: {
        Site site = (Site) theEObject;
        T result = caseSite(site);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.PROPERTY_ELEMENT: {
        PropertyElement propertyElement = (PropertyElement) theEObject;
        T result = casePropertyElement(propertyElement);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      case PomPackage.CONFIGURATION: {
        Configuration configuration = (Configuration) theEObject;
        T result = caseConfiguration(configuration);
        if(result == null)
          result = defaultCase(theEObject);
        return result;
      }
      default:
        return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Activation</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Activation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseActivation(Activation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Activation File</em>'. <!-- begin-user-doc
   * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Activation File</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseActivationFile(ActivationFile object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Activation OS</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Activation OS</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseActivationOS(ActivationOS object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Activation Property</em>'. <!--
   * begin-user-doc --> This implementation returns null; returning a non-null result will terminate the switch. <!--
   * end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Activation Property</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseActivationProperty(ActivationProperty object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Build</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Build</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseBuild(Build object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Build Base</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Build Base</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseBuildBase(BuildBase object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Ci Management</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Ci Management</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseCiManagement(CiManagement object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Contributor</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Contributor</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseContributor(Contributor object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Dependency</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Dependency</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDependency(Dependency object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Dependency Management</em>'. <!--
   * begin-user-doc --> This implementation returns null; returning a non-null result will terminate the switch. <!--
   * end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Dependency Management</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDependencyManagement(DependencyManagement object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Deployment Repository</em>'. <!--
   * begin-user-doc --> This implementation returns null; returning a non-null result will terminate the switch. <!--
   * end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Deployment Repository</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDeploymentRepository(DeploymentRepository object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Developer</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Developer</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDeveloper(Developer object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Distribution Management</em>'. <!--
   * begin-user-doc --> This implementation returns null; returning a non-null result will terminate the switch. <!--
   * end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Distribution Management</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDistributionManagement(DistributionManagement object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Document Root</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Document Root</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDocumentRoot(DocumentRoot object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Exclusion</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Exclusion</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseExclusion(Exclusion object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Extension</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Extension</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseExtension(Extension object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Issue Management</em>'. <!-- begin-user-doc
   * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Issue Management</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIssueManagement(IssueManagement object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>License</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>License</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseLicense(License object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Mailing List</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Mailing List</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMailingList(MailingList object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Model</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Model</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseModel(Model object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Notifier</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Notifier</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseNotifier(Notifier object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Organization</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Organization</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseOrganization(Organization object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Parent</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Parent</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseParent(Parent object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Plugin</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Plugin</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePlugin(Plugin object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Plugin Execution</em>'. <!-- begin-user-doc
   * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Plugin Execution</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePluginExecution(PluginExecution object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Plugin Management</em>'. <!-- begin-user-doc
   * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Plugin Management</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePluginManagement(PluginManagement object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Prerequisites</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Prerequisites</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePrerequisites(Prerequisites object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Profile</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Profile</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseProfile(Profile object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Relocation</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Relocation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRelocation(Relocation object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Reporting</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Reporting</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseReporting(Reporting object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Report Plugin</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Report Plugin</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseReportPlugin(ReportPlugin object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Report Set</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Report Set</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseReportSet(ReportSet object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Repository</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Repository</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRepository(Repository object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Repository Policy</em>'. <!-- begin-user-doc
   * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Repository Policy</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRepositoryPolicy(RepositoryPolicy object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Resource</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Resource</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseResource(Resource object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Scm</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Scm</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseScm(Scm object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Site</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Site</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSite(Site object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Property Element</em>'. <!-- begin-user-doc
   * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Property Element</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePropertyElement(PropertyElement object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>Configuration</em>'. <!-- begin-user-doc -->
   * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>Configuration</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseConfiguration(Configuration object) {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of ' <em>EObject</em>'. <!-- begin-user-doc --> This
   * implementation returns null; returning a non-null result will terminate the switch, but this is the last case
   * anyway. <!-- end-user-doc -->
   *
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of ' <em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  public T defaultCase(EObject object) {
    return null;
  }

} // PomSwitch
