/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.INavigatable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.synchronize.NavigationActionGroup;
import org.eclipse.team.internal.ui.synchronize.StructuredViewerAdvisor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public abstract class AbstractTreeViewerAdvisor
extends StructuredViewerAdvisor
implements IAdaptable {
    private ICompareNavigator nav;
    private INavigatable navigatable;

    /*
     * Unable to fully structure code
     */
    private static boolean hasNextPrev(TreeViewer viewer, TreeItem item, boolean next) {
        block5: {
            if (item == null || !(viewer instanceof ITreeViewerAccessor)) {
                return false;
            }
            children = null;
            if (!next) ** GOTO lbl21
            if (!viewer.isExpandable(item.getData())) ** GOTO lbl13
            return true;
lbl-1000:
            // 1 sources

            {
                parent = item.getParentItem();
                children = parent != null ? parent.getItems() : item.getParent().getItems();
                if (children == null || children.length <= 0) continue;
                if (children[children.length - 1] != item) {
                    return true;
                }
                item = parent;
lbl13:
                // 3 sources

                ** while (item != null)
            }
lbl14:
            // 1 sources

            break block5;
lbl-1000:
            // 1 sources

            {
                parent = item.getParentItem();
                children = parent != null ? parent.getItems() : item.getParent().getItems();
                if (children == null || children.length <= 0) continue;
                if (children[0] != item) {
                    return true;
                }
                item = parent;
lbl21:
                // 3 sources

                ** while (item != null)
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static TreeItem findNextPrev(TreeViewer viewer, TreeItem item, boolean next) {
        if (item == null || !(viewer instanceof ITreeViewerAccessor)) {
            return null;
        }
        children = null;
        treeAccessor = (ITreeViewerAccessor)viewer;
        if (!next) {
            parent = item.getParentItem();
            children = parent != null ? parent.getItems() : item.getParent().getItems();
            if (children != null && children.length > 0) {
                index = 0;
                while (index < children.length) {
                    if (children[index] == item) break;
                    ++index;
                }
                if (index > 0) {
                    item = children[index - 1];
                    while (true) {
                        treeAccessor.createChildren(item);
                        n = item.getItemCount();
                        if (n <= 0) break;
                        item.setExpanded(true);
                        item = item.getItems()[n - 1];
                    }
                    return item;
                }
            }
            return parent;
        }
        item.setExpanded(true);
        treeAccessor.createChildren(item);
        if (item.getItemCount() <= 0) ** GOTO lbl42
        children = item.getItems();
        return children[0];
lbl-1000:
        // 1 sources

        {
            children = null;
            parent = item.getParentItem();
            children = parent != null ? parent.getItems() : item.getParent().getItems();
            if (children != null && children.length > 0) {
                index = 0;
                while (index < children.length) {
                    if (children[index] == item) break;
                    ++index;
                }
                if (index < children.length - 1) {
                    return children[index + 1];
                }
            }
            item = parent;
lbl42:
            // 2 sources

            ** while (item != null)
        }
lbl43:
        // 1 sources

        return item;
    }

    private static void setSelection(TreeViewer viewer, TreeItem ti, boolean fireOpen, boolean expandOnly) {
        Object data;
        if (ti != null && (data = ti.getData()) != null) {
            StructuredSelection selection = new StructuredSelection(data);
            if (expandOnly) {
                viewer.expandToLevel(data, 0);
            } else {
                viewer.setSelection((ISelection)selection, true);
                ISelection currentSelection = viewer.getSelection();
                if (fireOpen && currentSelection != null && selection.equals(currentSelection) && viewer instanceof ITreeViewerAccessor) {
                    ((ITreeViewerAccessor)viewer).openSelection();
                }
            }
        }
    }

    public static boolean navigate(TreeViewer viewer, boolean next, boolean fireOpen, boolean expandOnly) {
        Tree tree = viewer.getTree();
        if (tree == null) {
            return false;
        }
        TreeItem item = AbstractTreeViewerAdvisor.getNextItem(viewer, next);
        if (item != null) {
            AbstractTreeViewerAdvisor.setSelection(viewer, item, fireOpen, expandOnly);
        }
        return item == null;
    }

    private static TreeItem getNextItem(TreeViewer viewer, boolean next) {
        TreeItem item = AbstractTreeViewerAdvisor.getCurrentItem(viewer);
        if (item != null) {
            while ((item = AbstractTreeViewerAdvisor.findNextPrev(viewer, item, next)) != null && item.getItemCount() > 0) {
            }
        }
        return item;
    }

    private static TreeItem getCurrentItem(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        if (tree == null) {
            return null;
        }
        TreeItem item = null;
        TreeItem[] children = tree.getSelection();
        if (children != null && children.length > 0) {
            item = children[0];
        }
        if (item == null && (children = tree.getItems()) != null && children.length > 0) {
            item = children[0];
        }
        return item;
    }

    private static boolean hasChange(TreeViewer viewer, boolean next) {
        TreeItem item = AbstractTreeViewerAdvisor.getCurrentItem(viewer);
        if (item != null) {
            return AbstractTreeViewerAdvisor.hasNextPrev(viewer, item, next);
        }
        return false;
    }

    public AbstractTreeViewerAdvisor(ISynchronizePageConfiguration configuration) {
        super(configuration);
        ICompareNavigator nav = (ICompareNavigator)configuration.getProperty("org.eclipse.team.ui.P_NAVIGATOR");
        if (nav == null) {
            configuration.setProperty("org.eclipse.team.ui.P_NAVIGATOR", this.getAdapter(ICompareNavigator.class));
        }
        configuration.addActionContribution(new NavigationActionGroup());
    }

    public boolean navigate(boolean next) {
        return AbstractTreeViewerAdvisor.navigate((TreeViewer)this.getViewer(), next, false, false);
    }

    protected boolean hasChange(boolean next) {
        return AbstractTreeViewerAdvisor.hasChange((TreeViewer)this.getViewer(), next);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ICompareNavigator.class) {
            if (this.nav == null) {
                this.nav = new TreeCompareNavigator();
            }
            return (T)this.nav;
        }
        if (adapter == INavigatable.class) {
            return (T)this.getNavigatable();
        }
        return null;
    }

    private synchronized INavigatable getNavigatable() {
        if (this.navigatable == null) {
            this.navigatable = new INavigatable(){

                public boolean selectChange(int flag) {
                    if (flag == 3) {
                        AbstractTreeViewerAdvisor.this.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
                        flag = 1;
                    } else if (flag == 4) {
                        AbstractTreeViewerAdvisor.this.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
                        flag = 2;
                    }
                    return AbstractTreeViewerAdvisor.navigate((TreeViewer)AbstractTreeViewerAdvisor.this.getViewer(), flag == 1, true, false);
                }

                public boolean openSelectedChange() {
                    StructuredViewer v = AbstractTreeViewerAdvisor.this.getViewer();
                    if (v instanceof ITreeViewerAccessor) {
                        ITreeViewerAccessor tva = (ITreeViewerAccessor)v;
                        if (!v.getControl().isDisposed()) {
                            tva.openSelection();
                            return true;
                        }
                    }
                    return false;
                }

                public boolean hasChange(int changeFlag) {
                    return AbstractTreeViewerAdvisor.this.hasChange(changeFlag == 1);
                }

                public Object getInput() {
                    return AbstractTreeViewerAdvisor.this.getViewer().getInput();
                }
            };
        }
        return this.navigatable;
    }

    @Override
    protected boolean handleDoubleClick(StructuredViewer viewer, DoubleClickEvent event) {
        if (super.handleDoubleClick(viewer, event)) {
            return true;
        }
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = this.getFirstElementOrPath(selection);
        AbstractTreeViewer treeViewer = (AbstractTreeViewer)this.getViewer();
        if (element != null) {
            if (treeViewer.getExpandedState(element)) {
                treeViewer.collapseToLevel(element, -1);
            } else {
                this.expandToNextDiff(element);
            }
        }
        return true;
    }

    private Object getFirstElementOrPath(IStructuredSelection selection) {
        TreeSelection ts;
        TreePath[] paths;
        if (selection instanceof TreeSelection && (paths = (ts = (TreeSelection)selection).getPaths()).length > 0) {
            return paths[0];
        }
        Object element = selection.getFirstElement();
        return element;
    }

    private Object getFirstElement(IStructuredSelection selection) {
        Object element = this.getFirstElementOrPath(selection);
        if (element instanceof TreePath) {
            TreePath path = (TreePath)element;
            element = path.getLastSegment();
        }
        return element;
    }

    protected void expandToNextDiff(Object elementOrPath) {
        AbstractTreeViewerAdvisor.navigate((TreeViewer)this.getViewer(), true, false, true);
    }

    public static interface ITreeViewerAccessor {
        public void createChildren(TreeItem var1);

        public void openSelection();
    }

    private class TreeCompareNavigator
    extends CompareNavigator {
        private TreeCompareNavigator() {
        }

        protected INavigatable[] getNavigatables() {
            INavigatable navigatable = AbstractTreeViewerAdvisor.this.getNavigatable();
            return new INavigatable[]{navigatable};
        }

        public boolean selectChange(boolean next) {
            Object selectedObject;
            if (this.getSubNavigator() != null && this.getSubNavigator().hasChange(next)) {
                this.getSubNavigator().selectChange(next);
                return false;
            }
            boolean noNextChange = super.selectChange(next);
            if (!noNextChange && !this.hasCompareInput(selectedObject = AbstractTreeViewerAdvisor.this.getFirstElement(AbstractTreeViewerAdvisor.this.getViewer().getStructuredSelection()))) {
                return this.selectChange(next);
            }
            return noNextChange;
        }

        private boolean hasCompareInput(Object selectedObject) {
            SyncInfo syncInfo = this.getSyncInfo(selectedObject);
            if (syncInfo != null) {
                return syncInfo.getLocal().getType() == 1;
            }
            ISynchronizeParticipant p = AbstractTreeViewerAdvisor.this.getConfiguration().getParticipant();
            if (p instanceof ModelSynchronizeParticipant) {
                ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)p;
                return msp.hasCompareInputFor(selectedObject);
            }
            return true;
        }

        private SyncInfo getSyncInfo(Object obj) {
            if (obj instanceof SyncInfoModelElement) {
                return ((SyncInfoModelElement)obj).getSyncInfo();
            }
            return null;
        }

        public boolean hasChange(boolean next) {
            if (this.getSubNavigator() != null && this.getSubNavigator().hasChange(next)) {
                return true;
            }
            return super.hasChange(next);
        }

        private CompareNavigator getSubNavigator() {
            Object selectedObject;
            IEditorPart editor;
            IWorkbenchSite ws = AbstractTreeViewerAdvisor.this.getConfiguration().getSite().getWorkbenchSite();
            if (ws instanceof IWorkbenchPartSite && (editor = OpenInCompareAction.findOpenCompareEditor((IWorkbenchPartSite)ws, selectedObject = AbstractTreeViewerAdvisor.this.getFirstElement(AbstractTreeViewerAdvisor.this.getViewer().getStructuredSelection()), AbstractTreeViewerAdvisor.this.getConfiguration().getParticipant())) != null) {
                CompareEditorInput input = (CompareEditorInput)editor.getEditorInput();
                ICompareNavigator navigator = input.getNavigator();
                if (navigator instanceof TreeCompareNavigator) {
                    navigator = (ICompareNavigator)AbstractTreeViewerAdvisor.this.getConfiguration().getProperty("org.eclipse.team.ui.P_INPUT_NAVIGATOR");
                }
                if (navigator instanceof CompareNavigator) {
                    return (CompareNavigator)navigator;
                }
            }
            return null;
        }
    }
}

