/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ParameterViewerDescriptor;
import org.eclipse.datatools.sqltools.result.ui.ExternalParameterViewerProvider;
import org.eclipse.datatools.sqltools.result.ui.view.ParameterViewerProvider;

public class ParameterViewerRegistryReader {
    public static final String EXTERNAL_PARAMETER_VIEWER = "org.eclipse.datatools.sqltools.result.parameterViewer";
    public static final String EXTERNAL_PARAMETER_VIEWER_CLASS = "class";
    public static final String EXTERNAL_PARAMETER_VIEWER_VENDOR = "vendor";
    public static final String EXTERNAL_PARAMETER_VIEWER_ID = "id";
    public static final String EXTERNAL_PARAMETER_VIEWER_DEFAULTVIEWER_NAME = "default_viewer_name";
    private static ParameterViewerRegistryReader myInstance;
    private List myViewers;

    private ParameterViewerRegistryReader() {
    }

    public static synchronized ParameterViewerRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new ParameterViewerRegistryReader();
        }
        return myInstance;
    }

    public synchronized List getParameterViewers() {
        if (this.myViewers == null) {
            this.myViewers = new ArrayList();
            this.retrieveViewers();
        }
        return this.myViewers;
    }

    public ParameterViewerProvider getParameterViewerExecutable(String viewerName) {
        ExternalParameterViewerProvider exe = null;
        List viewers = this.getParameterViewers();
        if (viewerName != null) {
            for (ParameterViewerDescriptor desc : viewers) {
                if (!viewerName.equalsIgnoreCase(desc.getViewerID())) continue;
                exe = desc.getViewerProvider();
                break;
            }
        }
        return exe;
    }

    private void retrieveViewers() {
        try {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTERNAL_PARAMETER_VIEWER);
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension ext = extensions[i];
                    IConfigurationElement[] configElements = ext.getConfigurationElements();
                    int config = 0;
                    while (config < configElements.length) {
                        ExternalParameterViewerProvider viewerProvider = (ExternalParameterViewerProvider)configElements[config].createExecutableExtension(EXTERNAL_PARAMETER_VIEWER_CLASS);
                        String vendor = configElements[config].getAttribute(EXTERNAL_PARAMETER_VIEWER_VENDOR);
                        String id = configElements[config].getAttribute(EXTERNAL_PARAMETER_VIEWER_ID);
                        String defaultViewerName = configElements[config].getAttribute(EXTERNAL_PARAMETER_VIEWER_DEFAULTVIEWER_NAME);
                        ParameterViewerDescriptor descriptor = new ParameterViewerDescriptor(viewerProvider, vendor, id, defaultViewerName);
                        this.myViewers.add(descriptor);
                        ++config;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }
}

