/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.osgi.framework.Bundle;

class SorterDescriptor {
    public static final String SORTER_TAG = "sorter";
    private static final String ID_ATTRIBUTE = "id";
    private static final String PAGE_ID_ATTRIBUTE = "pageId";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String TOOLTIP_ATTRIBUTE = "tooltip";
    private final IConfigurationElement fElement;

    public SorterDescriptor(IConfigurationElement element) {
        this.fElement = element;
    }

    public ViewerComparator createObject() {
        try {
            return (ViewerComparator)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.Search_Error_createSorter_title, SearchMessages.Search_Error_createSorter_message);
            return null;
        }
        catch (ClassCastException ex) {
            ExceptionHandler.displayMessageDialog(ex, SearchMessages.Search_Error_createSorter_title, SearchMessages.Search_Error_createSorter_message);
            return null;
        }
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public ImageDescriptor getImage() {
        String imageName = this.fElement.getAttribute(ICON_ATTRIBUTE);
        if (imageName == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)this.fElement.getContributor().getName());
        return SearchPluginImages.createImageDescriptor(bundle, IPath.fromOSString((String)imageName), true);
    }

    public String getLabel() {
        return this.fElement.getAttribute(LABEL_ATTRIBUTE);
    }

    public String getToolTipText() {
        return this.fElement.getAttribute(TOOLTIP_ATTRIBUTE);
    }

    public String getPageId() {
        return this.fElement.getAttribute(PAGE_ID_ATTRIBUTE);
    }
}

