/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.validation;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.Messages;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.mylyn.wikitext.validation.MarkupValidator;
import org.eclipse.mylyn.wikitext.validation.ValidationProblem;

public abstract class DocumentRegionValidator {
    protected IResource resource;
    protected IAnnotationModel annotationModel;
    protected MarkupLanguage markupLanguage;
    protected MarkupValidator delegate;

    public void validate(IProgressMonitor monitor, IDocument document, IRegion region) throws CoreException {
        if (region.getLength() == 0) {
            return;
        }
        int totalWork = region.getLength() * 2;
        monitor.beginTask(Messages.DocumentRegionValidator_validation, totalWork);
        try {
            this.clearProblems((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)(totalWork / 2)), document, region);
            this.computeProblems((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)(totalWork / 2)), document, region);
        }
        finally {
            monitor.done();
        }
    }

    protected void computeProblems(IProgressMonitor monitor, IDocument document, IRegion region) throws CoreException {
        if (this.delegate == null) {
            return;
        }
        int totalWork = 0x3FFFFFFF;
        monitor.beginTask(Messages.DocumentRegionValidator_validating, 0x3FFFFFFF);
        try {
            List problems;
            String markup = document.get();
            int offset = region.getOffset();
            int length = region.getLength();
            if (offset + length > markup.length()) {
                length = markup.length() - offset;
            }
            if (length <= 0) {
                problems = Collections.emptyList();
            } else {
                problems = this.delegate.validate(markup, offset, length);
                monitor.worked(0x1FFFFFFF);
            }
            this.createProblems((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)0x1FFFFFFF), document, region, problems);
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void createProblems(IProgressMonitor var1, IDocument var2, IRegion var3, List<ValidationProblem> var4) throws CoreException;

    protected abstract void clearProblems(IProgressMonitor var1, IDocument var2, IRegion var3) throws CoreException;

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        if (markupLanguage == this.markupLanguage || markupLanguage != null && this.markupLanguage != null && markupLanguage.getName().equals(this.markupLanguage.getName())) {
            return;
        }
        this.markupLanguage = markupLanguage;
        this.delegate = markupLanguage == null ? null : WikiText.getMarkupValidator(markupLanguage.getName());
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public void setAnnotationModel(IAnnotationModel annotationModel) {
        this.annotationModel = annotationModel;
    }

    protected boolean overlaps(IRegion region, int offset, int length) {
        int end = offset + length;
        if (region.getOffset() > offset) {
            return end > region.getOffset();
        }
        return offset < region.getOffset() + region.getLength();
    }
}

