/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.objects;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.IPropertyDataTypeOverride;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.KnownStringPropertiesOverride;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.NlsPropertyOverride;
import org.eclipse.scout.sdk.core.s.model.js.objects.IScoutJsObject;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsPropertyFactory;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataTypeOwner;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.IFunction;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class TypeScriptScoutObject
implements IScoutJsObject {
    private final IES6Class m_class;
    private final ScoutJsModel m_scoutJsModel;
    private final FinalValue<Optional<IES6Class>> m_model;
    private final FinalValue<Map<String, ScoutJsProperty>> m_properties;
    private final FinalValue<List<IFunction>> m_init;

    protected TypeScriptScoutObject(ScoutJsModel scoutJsModel, IES6Class clazz) {
        this.m_scoutJsModel = scoutJsModel;
        this.m_class = clazz;
        this.m_model = new FinalValue();
        this.m_init = new FinalValue();
        this.m_properties = new FinalValue();
    }

    public static Optional<IScoutJsObject> create(ScoutJsModel scoutJsModel, IES6Class clazz) {
        if (scoutJsModel == null || clazz == null) {
            return Optional.empty();
        }
        return Optional.of(new TypeScriptScoutObject(scoutJsModel, clazz));
    }

    @Override
    public ScoutJsModel scoutJsModel() {
        return this.m_scoutJsModel;
    }

    @Override
    public IES6Class declaringClass() {
        return this.m_class;
    }

    @Override
    public Map<String, ScoutJsProperty> properties() {
        return (Map)this.m_properties.computeIfAbsentAndGet(this::parseProperties);
    }

    protected Map<String, ScoutJsProperty> parseProperties() {
        Stream<IField> fields = this.model().orElse(this.declaringClass()).fields().withoutModifier(Modifier.STATIC).stream().filter(f -> !f.name().equals("eventMap")).filter(f -> !f.name().equals("events")).filter(f -> !f.name().equals("self")).filter(f -> !f.name().equals("widgetMap"));
        return ScoutJsPropertyFactory.createProperties(fields, this.createOverrides(), this);
    }

    protected List<IPropertyDataTypeOverride> createOverrides() {
        IDataType stringType = (IDataType)Ensure.notNull((Object)this.declaringClass().spi().createDataType("string").api());
        return Arrays.asList(new NlsPropertyOverride(this, stringType), new KnownStringPropertiesOverride(this, stringType));
    }

    @Override
    public List<IFunction> _inits() {
        return (List)this.m_init.computeIfAbsentAndGet(() -> this.declaringClass().functions().withName("_init").stream().toList());
    }

    public Optional<IES6Class> model() {
        return (Optional)this.m_model.computeIfAbsentAndGet(() -> this.findClassField("model"));
    }

    protected Optional<IES6Class> findClassField(String name) {
        return this.declaringClass().field(name).flatMap(IDataTypeOwner::dataType).filter(IES6Class.class::isInstance).map(IES6Class.class::cast);
    }

    @Override
    public String name() {
        return this.declaringClass().name();
    }

    public String toString() {
        return this.declaringClass().toString();
    }
}

