/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.AssertionFailedError;

@API(status=API.Status.STABLE, since="5.9")
public class AssertionFailureBuilder {
    private @Nullable Object message;
    private @Nullable Throwable cause;
    private boolean mismatch;
    private @Nullable Object expected;
    private @Nullable Object actual;
    private @Nullable String reason;
    private boolean includeValuesInMessage = true;

    public static AssertionFailureBuilder assertionFailure() {
        return new AssertionFailureBuilder();
    }

    private AssertionFailureBuilder() {
    }

    public AssertionFailureBuilder message(@Nullable Object message) {
        this.message = message;
        return this;
    }

    public AssertionFailureBuilder reason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    public AssertionFailureBuilder cause(@Nullable Throwable cause) {
        this.cause = cause;
        return this;
    }

    public AssertionFailureBuilder expected(@Nullable Object expected) {
        this.mismatch = true;
        this.expected = expected;
        return this;
    }

    public AssertionFailureBuilder actual(@Nullable Object actual) {
        this.mismatch = true;
        this.actual = actual;
        return this;
    }

    public AssertionFailureBuilder includeValuesInMessage(boolean includeValuesInMessage) {
        this.includeValuesInMessage = includeValuesInMessage;
        return this;
    }

    public void buildAndThrow() throws AssertionFailedError {
        throw this.build();
    }

    public AssertionFailedError build() {
        Object reason = AssertionFailureBuilder.nullSafeGet(this.reason);
        if (this.mismatch && this.includeValuesInMessage) {
            reason = (String)(reason == null ? "" : (String)reason + ", ") + AssertionFailureBuilder.formatValues(this.expected, this.actual);
        }
        Object message = AssertionFailureBuilder.nullSafeGet(this.message);
        if (reason != null) {
            message = AssertionFailureBuilder.buildPrefix((String)message) + (String)reason;
        }
        return this.mismatch ? new AssertionFailedError((String)message, this.expected, this.actual, this.cause) : new AssertionFailedError((String)message, this.cause);
    }

    private static @Nullable String nullSafeGet(@Nullable Object messageOrSupplier) {
        if (messageOrSupplier == null) {
            return null;
        }
        if (messageOrSupplier instanceof Supplier) {
            Supplier supplier = (Supplier)messageOrSupplier;
            Object message = supplier.get();
            return StringUtils.nullSafeToString(message);
        }
        return StringUtils.nullSafeToString((Object)messageOrSupplier);
    }

    private static String buildPrefix(@Nullable String message) {
        return StringUtils.isNotBlank((String)message) ? message + " ==> " : "";
    }

    private static String formatValues(@Nullable Object expected, @Nullable Object actual) {
        String actualString;
        String expectedString = AssertionFailureBuilder.toString(expected);
        if (expectedString.equals(actualString = AssertionFailureBuilder.toString(actual))) {
            return "expected: %s but was: %s".formatted(AssertionFailureBuilder.formatClassAndValue(expected, expectedString), AssertionFailureBuilder.formatClassAndValue(actual, actualString));
        }
        return "expected: <%s> but was: <%s>".formatted(expectedString, actualString);
    }

    private static String formatClassAndValue(@Nullable Object value, String valueString) {
        if (value == null) {
            return "<null>";
        }
        String classAndHash = AssertionFailureBuilder.getClassName(value) + AssertionFailureBuilder.toHash(value);
        return value instanceof Class ? "<" + classAndHash + ">" : classAndHash + "<" + valueString + ">";
    }

    private static String toString(@Nullable Object obj) {
        if (obj instanceof Class) {
            Class clazz = (Class)obj;
            return AssertionUtils.getCanonicalName(clazz);
        }
        return StringUtils.nullSafeToString((Object)obj);
    }

    private static String toHash(@Nullable Object obj) {
        return obj == null ? "" : "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    private static String getClassName(@Nullable Object obj) {
        String string;
        if (obj == null) {
            string = "null";
        } else if (obj instanceof Class) {
            Class clazz = (Class)obj;
            string = AssertionUtils.getCanonicalName(clazz);
        } else {
            string = obj.getClass().getName();
        }
        return string;
    }
}

