/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.exceptions.DefaultMultiCauseException;

public class DefaultBuildCancellationToken
implements BuildCancellationToken {
    private final Object lock = new Object();
    private boolean cancelled;
    private List<Runnable> callbacks = new LinkedList<Runnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancellationRequested() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCallback(Runnable cancellationHandler) {
        boolean returnValue;
        Object object = this.lock;
        synchronized (object) {
            returnValue = this.cancelled;
            if (!this.cancelled) {
                this.callbacks.add(cancellationHandler);
            }
        }
        if (returnValue) {
            cancellationHandler.run();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallback(Runnable cancellationHandler) {
        Object object = this.lock;
        synchronized (object) {
            this.callbacks.remove(cancellationHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ArrayList<Runnable> toCall = new ArrayList<Runnable>();
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            toCall.addAll(this.callbacks);
            this.callbacks.clear();
        }
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        for (Runnable callback : toCall) {
            try {
                callback.run();
            }
            catch (Throwable ex) {
                failures.add(ex);
            }
        }
        if (!failures.isEmpty()) {
            throw new DefaultMultiCauseException("Failed to run cancellation actions.", failures);
        }
    }
}

