/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class TextChangeCompatibility {
    public static void addTextEdit(TextChange change, String name, TextEdit edit) {
        Assert.isNotNull((Object)change);
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)edit);
        TextEdit root = change.getEdit();
        if (root == null) {
            root = new MultiTextEdit();
            change.setEdit(root);
        }
        TextChangeCompatibility.insert(root, edit);
        change.addTextEditGroup(new TextEditGroup(name, edit));
    }

    public static void addTextEdit(TextChange change, String name, TextEdit[] edits) {
        Assert.isNotNull((Object)change);
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)edits);
        TextEdit root = change.getEdit();
        if (root == null) {
            root = new MultiTextEdit();
            change.setEdit(root);
        }
        int i = 0;
        while (i < edits.length) {
            TextChangeCompatibility.insert(root, edits[i]);
            ++i;
        }
        change.addTextEditGroup(new TextEditGroup(name, edits));
    }

    public static void insert(TextEdit parent, TextEdit edit) {
        TextEdit child;
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            return;
        }
        TextEdit[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (TextChangeCompatibility.covers(child, edit)) {
                TextChangeCompatibility.insert(child, edit);
                return;
            }
            ++i;
        }
        i = children.length - 1;
        while (i >= 0) {
            child = children[i];
            if (TextChangeCompatibility.covers(edit, child)) {
                parent.removeChild(i);
                edit.addChild(child);
            }
            --i;
        }
        parent.addChild(edit);
    }

    private static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset < otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }
}

