/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableOwnerDrawSupport
implements Listener {
    private static final String STYLED_RANGES_KEY = "styled_ranges";
    private final TextLayout fSharedLayout;
    private int fDeltaOfLastMeasure;

    public static void install(Table table) {
        TableOwnerDrawSupport listener = new TableOwnerDrawSupport(table);
        table.addListener(12, (Listener)listener);
        table.addListener(41, (Listener)listener);
        table.addListener(40, (Listener)listener);
        table.addListener(42, (Listener)listener);
    }

    public static void storeStyleRanges(TableItem item, int column, StyleRange[] ranges) {
        item.setData(STYLED_RANGES_KEY + column, (Object)ranges);
    }

    private static StyleRange[] getStyledRanges(TableItem item, int column) {
        return (StyleRange[])item.getData(STYLED_RANGES_KEY + column);
    }

    private TableOwnerDrawSupport(Table table) {
        int orientation = table.getStyle() & 0x6000000;
        this.fSharedLayout = new TextLayout((Device)table.getDisplay());
        this.fSharedLayout.setOrientation(orientation);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 41: {
                this.measureItem(event);
                break;
            }
            case 40: {
                event.detail &= 0xFFFFFFEF;
                break;
            }
            case 42: {
                this.performPaint(event);
                break;
            }
            case 12: {
                this.widgetDisposed();
            }
        }
    }

    private void measureItem(Event event) {
        boolean isSelected = (event.detail & 2) != 0;
        this.fDeltaOfLastMeasure = this.updateTextLayout((TableItem)event.item, event.index, isSelected);
        event.width += this.fDeltaOfLastMeasure;
    }

    private int updateTextLayout(TableItem item, int index, boolean isSelected) {
        this.fSharedLayout.setFont(item.getFont(index));
        this.fSharedLayout.setText("");
        this.fSharedLayout.setText(item.getText(index));
        int originalTextWidth = this.fSharedLayout.getBounds().width;
        StyleRange[] ranges = TableOwnerDrawSupport.getStyledRanges(item, index);
        if (ranges != null) {
            StyleRange[] styleRangeArray = ranges;
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange range;
                StyleRange curr = range = styleRangeArray[n2];
                if (isSelected) {
                    curr = (StyleRange)curr.clone();
                    curr.foreground = null;
                    curr.background = null;
                }
                this.fSharedLayout.setStyle((TextStyle)curr, curr.start, curr.start + curr.length - 1);
                ++n2;
            }
        }
        return this.fSharedLayout.getBounds().width - originalTextWidth;
    }

    private void performPaint(Event event) {
        Rectangle textBounds;
        int y;
        int x;
        Image image;
        TableItem item = (TableItem)event.item;
        GC gc = event.gc;
        int index = event.index;
        boolean isSelected = (event.detail & 2) != 0;
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        if (!isSelected) {
            Color foreground = item.getForeground(index);
            gc.setForeground(foreground);
            Color background = item.getBackground(index);
            gc.setBackground(background);
        }
        if ((image = item.getImage(index)) != null) {
            Rectangle imageBounds = item.getImageBounds(index);
            Rectangle bounds = image.getBounds();
            x = imageBounds.x + Math.max(0, (imageBounds.width - bounds.width) / 2);
            y = imageBounds.y + Math.max(0, (imageBounds.height - bounds.height) / 2);
            gc.drawImage(image, x, y);
        }
        if ((textBounds = item.getTextBounds(index)) != null) {
            Rectangle layoutBounds = this.fSharedLayout.getBounds();
            x = textBounds.x;
            y = textBounds.y + Math.max(0, (textBounds.height - layoutBounds.height) / 2);
            this.fSharedLayout.draw(gc, x, y);
        }
        if ((event.detail & 4) != 0) {
            Rectangle focusBounds = item.getBounds();
            gc.drawFocus(focusBounds.x, focusBounds.y, focusBounds.width + this.fDeltaOfLastMeasure, focusBounds.height);
        }
        if (!isSelected) {
            gc.setForeground(oldForeground);
            gc.setBackground(oldBackground);
        }
    }

    private void widgetDisposed() {
        this.fSharedLayout.dispose();
    }
}

