/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dataobject;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.java.builder.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.java.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.s.dataobject.DataObjectNode;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.generator.method.ScoutDoMethodGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class DataObjectGenerator<TYPE extends DataObjectGenerator<TYPE>>
extends PrimaryTypeGenerator<TYPE> {
    private String m_namespace;
    private String m_typeVersion;
    private final Map<String, NodeEntry> m_nodes = new LinkedHashMap<String, NodeEntry>();

    protected void setup() {
        this.typeVersion().map(tv -> AnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::TypeVersion).withElementFrom(IScoutApi.class, api -> api.TypeVersion().valueElementName(), b -> ((IScoutApi)b.context().requireApi(IScoutApi.class)).TypeVersion().buildValue((IExpressionBuilder<?>)b, (String)tv))).ifPresent(arg_0 -> ((DataObjectGenerator)this).withAnnotation(arg_0));
        this.namespace().map(ns -> AnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::TypeName).withElementFrom(IScoutApi.class, api -> api.TypeName().valueElementName(), b -> b.stringLiteral((CharSequence)this.buildTypeName((String)ns, b.context())))).ifPresent(arg_0 -> ((DataObjectGenerator)this).withAnnotation(arg_0));
        this.withSuperClassFrom(IScoutApi.class, api -> api.DoEntity().fqn());
        if (!this.m_nodes.isEmpty()) {
            this.appendDoNodes();
            this.appendGeneratedComment();
            this.withPreProcessor((e, c) -> this.appendConvenienceMethods((IJavaBuilderContext)c));
        }
    }

    protected void appendDoNodes() {
        AtomicInteger num = new AtomicInteger();
        this.nodes().forEach(n -> this.withMethod(ScoutDoMethodGenerator.createDoNodeFunc(n.name(), n.kind(), n.dataTypeFunc()), new Object[]{"D", num.incrementAndGet()}));
    }

    protected void appendGeneratedComment() {
        this.withField((IFieldGenerator)FieldGenerator.create().withComment(b -> b.append(ScoutDoMethodGenerator.convenienceMethodsMarkerComment(b.context().lineDelimiter()))), new Object[]{"M", 0});
    }

    protected void appendConvenienceMethods(IJavaBuilderContext context) {
        AtomicInteger num = new AtomicInteger();
        this.nodes().forEach(nodeEntry -> ScoutDoMethodGenerator.createConvenienceMethods(nodeEntry.name(), nodeEntry.kind(), (String)nodeEntry.dataTypeFunc().apply(context), false, this, context).forEach(g -> ((DataObjectGenerator)this.withoutMethod(g.identifier(context), context)).withMethod((IMethodGenerator)g, new Object[]{"M", num.incrementAndGet()})));
    }

    protected String buildTypeName(String namespace, IJavaBuilderContext context) {
        String pageParamDoName = Strings.removeSuffix((String)((String)this.elementName(context).orElseThrow(() -> Ensure.newFail((CharSequence)"DataObject name missing.", (Object[])new Object[0]))), (CharSequence)"Do");
        return namespace + "." + pageParamDoName;
    }

    protected Stream<NodeEntry> nodes() {
        return this.m_nodes.values().stream();
    }

    public TYPE withNode(String name, DataObjectNode.DataObjectNodeKind kind, String dataType) {
        Ensure.notBlank((CharSequence)dataType);
        return this.withNodeFunc(name, kind, (Function<IJavaBuilderContext, String>)JavaBuilderContextFunction.orNull((Object)dataType));
    }

    public <API extends IApiSpecification> TYPE withNodeFrom(String name, DataObjectNode.DataObjectNodeKind kind, Class<API> api, Function<API, String> dataTypeFunc) {
        return this.withNodeFunc(name, kind, (Function<IJavaBuilderContext, String>)new ApiFunction(api, dataTypeFunc));
    }

    public TYPE withNodeFunc(String name, DataObjectNode.DataObjectNodeKind kind, Function<IJavaBuilderContext, String> dataTypeFunc) {
        Ensure.notBlank((CharSequence)name);
        Ensure.notNull(dataTypeFunc);
        Ensure.notNull((Object)((Object)kind));
        this.m_nodes.put(name, new NodeEntry(name, kind, (JavaBuilderContextFunction<String>)JavaBuilderContextFunction.create(dataTypeFunc)));
        return (TYPE)((Object)((DataObjectGenerator)this.thisInstance()));
    }

    public Optional<String> typeVersion() {
        return Strings.notBlank((CharSequence)this.m_typeVersion);
    }

    public TYPE withTypeVersion(String typeVersion) {
        this.m_typeVersion = typeVersion;
        return (TYPE)((Object)((DataObjectGenerator)this.thisInstance()));
    }

    public Optional<String> namespace() {
        return Strings.notEmpty((CharSequence)this.m_namespace);
    }

    public TYPE withNamespace(String namespace) {
        this.m_namespace = namespace;
        return (TYPE)((Object)((DataObjectGenerator)this.thisInstance()));
    }

    protected static final class NodeEntry {
        private final String m_name;
        private final DataObjectNode.DataObjectNodeKind m_kind;
        private final JavaBuilderContextFunction<String> m_dataType;

        public NodeEntry(String name, DataObjectNode.DataObjectNodeKind kind, JavaBuilderContextFunction<String> dataType) {
            this.m_name = name;
            this.m_kind = kind;
            this.m_dataType = dataType;
        }

        public DataObjectNode.DataObjectNodeKind kind() {
            return this.m_kind;
        }

        public String name() {
            return this.m_name;
        }

        public JavaBuilderContextFunction<String> dataTypeFunc() {
            return this.m_dataType;
        }
    }
}

