/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.generator.field;

import java.util.Optional;
import org.eclipse.scout.sdk.core.typescript.builder.ITypeScriptSourceBuilder;
import org.eclipse.scout.sdk.core.typescript.builder.nodeelement.INodeElementBuilder;
import org.eclipse.scout.sdk.core.typescript.builder.nodeelement.NodeElementBuilder;
import org.eclipse.scout.sdk.core.typescript.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.nodeelement.AbstractNodeElementGenerator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.util.Strings;

public class FieldGenerator<TYPE extends IFieldGenerator<TYPE>>
extends AbstractNodeElementGenerator<TYPE>
implements IFieldGenerator<TYPE> {
    private IDataType m_dataType;

    protected FieldGenerator() {
    }

    public static IFieldGenerator<?> create() {
        return new FieldGenerator();
    }

    @Override
    protected void build(ITypeScriptSourceBuilder<?> builder) {
        super.build(builder);
        this.buildFieldSource(NodeElementBuilder.create(builder));
    }

    protected void buildFieldSource(INodeElementBuilder<?> builder) {
        Optional<String> elementName = this.elementName().filter(Strings::hasText);
        if (elementName.isPresent()) {
            builder.appendModifiers(this.modifiers()).append(elementName.orElseThrow());
            this.dataType().ifPresent(dt -> ((INodeElementBuilder)((INodeElementBuilder)builder.colon()).space()).ref((IDataType)dt));
            builder.semicolon();
        }
    }

    @Override
    public Optional<IDataType> dataType() {
        return Optional.ofNullable(this.m_dataType);
    }

    @Override
    public TYPE withDataType(IDataType dataType) {
        this.m_dataType = dataType;
        return (TYPE)((IFieldGenerator)this.thisInstance());
    }
}

