/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;

public class Anchor
extends AbstractNodeHandler {
    private static final Pattern INLINE_LINK_ESCAPE = Pattern.compile("([\\(\\)])");
    private static final String INLINE_LINK_REPLACEMENT = "\\\\$1";

    @Override
    public void handleNode(NodeHandler parent, Element node, DocumentConverter converter) {
        if (node.hasAttr("href") && node.attr("href").trim().length() > 0) {
            String url = converter.cleaner.cleanUrl(node.attr("href"));
            String label = converter.getInlineContent(this, node);
            if (label.length() > 0) {
                if (converter.options.autoLinks && url.equals(label)) {
                    converter.output.write(label);
                } else if (converter.options.inlineLinks) {
                    if (converter.options.fixPegdownStrongEmphasisInLinks) {
                        label = label.replace("***", "**");
                    }
                    converter.output.printf("[%s](%s)", label, url);
                } else {
                    String linkId;
                    if (converter.options.fixPegdownStrongEmphasisInLinks) {
                        label = label.replace("***", "**");
                    }
                    if (label.equals(linkId = converter.addLink(url, label, false))) {
                        converter.output.printf("[%s][]", label);
                    } else {
                        converter.output.printf("[%s][%s]", label, linkId);
                    }
                }
            }
        } else {
            converter.walkNodes(parent, node);
        }
    }
}

