/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.ClassTemplate;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContext;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContextProvider;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.parallel.ResourceLocksProvider;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.descriptor.DynamicDescendantFilter;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.LifecycleMethodUtils;
import org.junit.jupiter.engine.descriptor.TemplateExecutor;
import org.junit.jupiter.engine.descriptor.UniqueIdPrefixTransformer;
import org.junit.jupiter.engine.execution.ExtensionContextSupplier;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.13")
public class ClassTemplateTestDescriptor
extends ClassBasedTestDescriptor
implements Filterable {
    public static final String STANDALONE_CLASS_SEGMENT_TYPE = "class-template";
    public static final String NESTED_CLASS_SEGMENT_TYPE = "nested-class-template";
    private final Map<Integer, Collection<? extends TestDescriptor>> childrenPrototypesByIndex = new HashMap<Integer, Collection<? extends TestDescriptor>>();
    private final List<TestDescriptor> childrenPrototypes = new ArrayList<TestDescriptor>();
    private final ClassBasedTestDescriptor delegate;
    private final DynamicDescendantFilter dynamicDescendantFilter;

    public ClassTemplateTestDescriptor(UniqueId uniqueId, ClassBasedTestDescriptor delegate) {
        this(uniqueId, delegate, new DynamicDescendantFilter());
    }

    private ClassTemplateTestDescriptor(UniqueId uniqueId, ClassBasedTestDescriptor delegate, DynamicDescendantFilter dynamicDescendantFilter) {
        super(uniqueId, delegate.getTestClass(), delegate.getDisplayName(), delegate.configuration);
        this.delegate = delegate;
        this.dynamicDescendantFilter = dynamicDescendantFilter;
    }

    public Set<TestTag> getTags() {
        return this.delegate.getTags();
    }

    @Override
    protected void validateCoreLifecycleMethods(DiscoveryIssueReporter reporter) {
        this.delegate.validateCoreLifecycleMethods(reporter);
    }

    @Override
    protected void validateClassTemplateInvocationLifecycleMethods(DiscoveryIssueReporter reporter) {
        boolean requireStatic = this.classInfo.lifecycle == TestInstance.Lifecycle.PER_METHOD;
        LifecycleMethodUtils.validateClassTemplateInvocationLifecycleMethodsAreDeclaredCorrectly(this.getTestClass(), requireStatic, reporter);
    }

    @Override
    public DynamicDescendantFilter getDynamicDescendantFilter() {
        return this.dynamicDescendantFilter;
    }

    @Override
    protected JupiterTestDescriptor copyIncludingDescendants(UnaryOperator<UniqueId> uniqueIdTransformer) {
        ClassTemplateTestDescriptor copy = (ClassTemplateTestDescriptor)super.copyIncludingDescendants(uniqueIdTransformer);
        this.childrenPrototypes.forEach(oldChild -> {
            JupiterTestDescriptor newChild = ((JupiterTestDescriptor)((Object)oldChild)).copyIncludingDescendants(uniqueIdTransformer);
            copy.childrenPrototypes.add((TestDescriptor)newChild);
        });
        this.childrenPrototypesByIndex.forEach((index, oldChildren) -> {
            List<JupiterTestDescriptor> newChildren = oldChildren.stream().map(oldChild -> ((JupiterTestDescriptor)((Object)((Object)oldChild))).copyIncludingDescendants(uniqueIdTransformer)).toList();
            copy.childrenPrototypesByIndex.put((Integer)index, (Collection<? extends TestDescriptor>)newChildren);
        });
        return copy;
    }

    @Override
    protected ClassTemplateTestDescriptor withUniqueId(UnaryOperator<UniqueId> uniqueIdTransformer) {
        return new ClassTemplateTestDescriptor((UniqueId)uniqueIdTransformer.apply(this.getUniqueId()), this.delegate, this.dynamicDescendantFilter.copy(uniqueIdTransformer));
    }

    public void prune() {
        super.prune();
        if (this.children.isEmpty()) {
            return;
        }
        new LinkedHashSet(this.children).forEach(child -> child.accept(TestDescriptor::prune));
        this.children.forEach(child -> {
            if (child instanceof ClassTemplateInvocationTestDescriptor) {
                ClassTemplateInvocationTestDescriptor descriptor = (ClassTemplateInvocationTestDescriptor)child;
                int index = descriptor.getIndex();
                this.dynamicDescendantFilter.allowIndex(index - 1);
                this.childrenPrototypesByIndex.put(index, child.getChildren());
            } else {
                this.childrenPrototypes.add((TestDescriptor)child);
            }
        });
        this.children.clear();
    }

    public boolean mayRegisterTests() {
        return !this.childrenPrototypes.isEmpty() || !this.childrenPrototypesByIndex.isEmpty();
    }

    @Override
    public List<Class<?>> getEnclosingTestClasses() {
        return this.delegate.getEnclosingTestClasses();
    }

    @Override
    public TestInstances instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionContextSupplier extensionContext, ExtensionRegistry registry, JupiterEngineExecutionContext context) {
        return this.delegate.instantiateTestClass(parentExecutionContext, extensionContext, registry, context);
    }

    @Override
    public Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> getResourceLocksProviderEvaluator() {
        return this.delegate.getResourceLocksProviderEvaluator();
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        Set result = this.determineExclusiveResources().collect(Collectors.toCollection(HashSet::new));
        TestDescriptor.Visitor visitor = testDescriptor -> {
            if (testDescriptor instanceof Node) {
                Node node = (Node)testDescriptor;
                result.addAll(node.getExclusiveResources());
            }
        };
        this.childrenPrototypes.forEach(child -> child.accept(visitor));
        this.childrenPrototypesByIndex.values().forEach(prototypes -> prototypes.forEach(child -> child.accept(visitor)));
        return result;
    }

    @Override
    public void cleanUp(JupiterEngineExecutionContext context) throws Exception {
        this.childrenPrototypes.clear();
        this.childrenPrototypesByIndex.clear();
        this.dynamicDescendantFilter.allowAll();
        super.cleanUp(context);
    }

    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        new ClassTemplateExecutor().execute(context, dynamicTestExecutor);
        return context;
    }

    class ClassTemplateExecutor
    extends TemplateExecutor<ClassTemplateInvocationContextProvider, ClassTemplateInvocationContext> {
        ClassTemplateExecutor() {
            super(ClassTemplateTestDescriptor.this, ClassTemplateInvocationContextProvider.class);
        }

        @Override
        boolean supports(ClassTemplateInvocationContextProvider provider, ExtensionContext extensionContext) {
            return provider.supportsClassTemplate(extensionContext);
        }

        @Override
        protected String getNoRegisteredProviderErrorMessage() {
            return "You must register at least one %s that supports @%s class [%s]".formatted(ClassTemplateInvocationContextProvider.class.getSimpleName(), ClassTemplate.class.getSimpleName(), ClassTemplateTestDescriptor.this.getTestClass().getName());
        }

        @Override
        Stream<? extends ClassTemplateInvocationContext> provideContexts(ClassTemplateInvocationContextProvider provider, ExtensionContext extensionContext) {
            return provider.provideClassTemplateInvocationContexts(extensionContext);
        }

        @Override
        boolean mayReturnZeroContexts(ClassTemplateInvocationContextProvider provider, ExtensionContext extensionContext) {
            return provider.mayReturnZeroClassTemplateInvocationContexts(extensionContext);
        }

        @Override
        protected String getZeroContextsProvidedErrorMessage(ClassTemplateInvocationContextProvider provider) {
            return "Provider [%s] did not provide any invocation contexts, but was expected to do so. You may override mayReturnZeroClassTemplateInvocationContexts() to allow this.".formatted(provider.getClass().getSimpleName());
        }

        @Override
        UniqueId createInvocationUniqueId(UniqueId parentUniqueId, int index) {
            return parentUniqueId.append("class-template-invocation", "#" + index);
        }

        @Override
        TestDescriptor createInvocationTestDescriptor(UniqueId uniqueId, ClassTemplateInvocationContext invocationContext, int index) {
            ClassTemplateInvocationTestDescriptor containerInvocationDescriptor = new ClassTemplateInvocationTestDescriptor(uniqueId, ClassTemplateTestDescriptor.this, invocationContext, index, ClassTemplateTestDescriptor.this.getSource().orElse(null), ClassTemplateTestDescriptor.this.configuration);
            this.collectChildren(index, uniqueId).forEach(arg_0 -> ((ClassTemplateInvocationTestDescriptor)containerInvocationDescriptor).addChild(arg_0));
            return containerInvocationDescriptor;
        }

        private Stream<? extends TestDescriptor> collectChildren(int index, UniqueId invocationUniqueId) {
            if (ClassTemplateTestDescriptor.this.childrenPrototypesByIndex.containsKey(index)) {
                return ClassTemplateTestDescriptor.this.childrenPrototypesByIndex.remove(index).stream();
            }
            UniqueIdPrefixTransformer transformer = new UniqueIdPrefixTransformer(ClassTemplateTestDescriptor.this.getUniqueId(), invocationUniqueId);
            return ClassTemplateTestDescriptor.this.childrenPrototypes.stream().map(JupiterTestDescriptor.class::cast).map(it -> it.copyIncludingDescendants(transformer));
        }
    }
}

