/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class MonoReconciler
extends AbstractReconciler {
    private final IReconcilingStrategy fStrategy;

    public MonoReconciler(IReconcilingStrategy strategy, boolean isIncremental) {
        Assert.isNotNull((Object)strategy);
        IReconcilingStrategy iReconcilingStrategy = this.fStrategy = strategy;
        if (iReconcilingStrategy instanceof IReconcilingStrategyExtension) {
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)((Object)iReconcilingStrategy);
            extension.setProgressMonitor(this.getProgressMonitor());
        }
        this.setIsIncrementalReconciler(isIncremental);
    }

    @Override
    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        Assert.isNotNull((Object)contentType);
        return this.fStrategy;
    }

    @Override
    protected void process(DirtyRegion dirtyRegion) {
        if (dirtyRegion != null) {
            this.fStrategy.reconcile(dirtyRegion, (IRegion)dirtyRegion);
        } else {
            IDocument document = this.getDocument();
            if (document != null) {
                this.fStrategy.reconcile((IRegion)new Region(0, document.getLength()));
            }
        }
    }

    @Override
    protected void reconcilerDocumentChanged(IDocument document) {
        this.fStrategy.setDocument(document);
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        super.setProgressMonitor(monitor);
        IReconcilingStrategy iReconcilingStrategy = this.fStrategy;
        if (iReconcilingStrategy instanceof IReconcilingStrategyExtension) {
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)((Object)iReconcilingStrategy);
            extension.setProgressMonitor(monitor);
        }
    }

    @Override
    protected void initialProcess() {
        IReconcilingStrategy iReconcilingStrategy = this.fStrategy;
        if (iReconcilingStrategy instanceof IReconcilingStrategyExtension) {
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)((Object)iReconcilingStrategy);
            extension.initialReconcile();
        }
    }

    @Override
    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        if (this.fStrategy instanceof ITextViewerLifecycle) {
            ((ITextViewerLifecycle)((Object)this.fStrategy)).install(textViewer);
        }
    }

    @Override
    public void uninstall() {
        if (this.fStrategy instanceof ITextViewerLifecycle) {
            ((ITextViewerLifecycle)((Object)this.fStrategy)).uninstall();
        }
        super.uninstall();
    }
}

