/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.util;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ExceptionUtils;

@API(status=API.Status.INTERNAL, since="6.0")
public class PreemptiveTimeoutUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T executeWithPreemptiveTimeout(Duration timeout, ThrowingSupplier<T> supplier, @Nullable Supplier<@Nullable String> messageSupplier, TimeoutFailureFactory<E> failureFactory) throws E {
        AtomicReference<Thread> threadReference = new AtomicReference<Thread>();
        ExecutorService executorService = Executors.newSingleThreadExecutor(new TimeoutThreadFactory());
        try {
            Future<T> future = PreemptiveTimeoutUtils.submitTask(supplier, threadReference, executorService);
            T t = PreemptiveTimeoutUtils.resolveFutureAndHandleException(future, timeout, messageSupplier, threadReference::get, failureFactory);
            return t;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private static <T> Future<T> submitTask(ThrowingSupplier<T> supplier, AtomicReference<Thread> threadReference, ExecutorService executorService) {
        return executorService.submit(() -> {
            try {
                threadReference.set(Thread.currentThread());
                return supplier.get();
            }
            catch (Throwable throwable) {
                throw ExceptionUtils.throwAsUncheckedException((Throwable)throwable);
            }
        });
    }

    private static <T, E extends Throwable> T resolveFutureAndHandleException(Future<T> future, Duration timeout, @Nullable Supplier<@Nullable String> messageSupplier, Supplier<@Nullable Thread> threadSupplier, TimeoutFailureFactory<E> failureFactory) throws E, RuntimeException {
        try {
            return future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            Thread thread = threadSupplier.get();
            ExecutionTimeoutException cause = null;
            if (thread != null) {
                cause = new ExecutionTimeoutException("Execution timed out in thread " + thread.getName());
                cause.setStackTrace(thread.getStackTrace());
            }
            throw failureFactory.createTimeoutFailure(timeout, messageSupplier, (Throwable)((Object)cause), thread);
        }
        catch (ExecutionException ex) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)Objects.requireNonNullElse(ex.getCause(), ex));
        }
        catch (Throwable ex) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)ex);
        }
    }

    private PreemptiveTimeoutUtils() {
    }

    private static class TimeoutThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger threadNumber = new AtomicInteger(1);

        private TimeoutThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "junit-timeout-thread-" + threadNumber.getAndIncrement());
        }
    }

    public static interface TimeoutFailureFactory<T extends Throwable> {
        public T createTimeoutFailure(Duration var1, @Nullable Supplier<@Nullable String> var2, @Nullable Throwable var3, @Nullable Thread var4);
    }

    private static class ExecutionTimeoutException
    extends JUnitException {
        private static final long serialVersionUID = 1L;

        ExecutionTimeoutException(String message) {
            super(message);
        }
    }
}

