/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.core.launching;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.eclemma.internal.core.launching.AdjustedLaunchConfiguration;

class AdjustedLaunchConfigurationWorkingCopy
extends AdjustedLaunchConfiguration
implements ILaunchConfigurationWorkingCopy {
    private final ILaunchConfigurationWorkingCopy delegate;
    private final ILaunchConfiguration original;
    private final String extraVMArgument;

    AdjustedLaunchConfigurationWorkingCopy(String extraVMArgument, ILaunchConfigurationWorkingCopy delegate, ILaunchConfiguration original) {
        super(extraVMArgument, (ILaunchConfiguration)delegate);
        this.delegate = delegate;
        this.original = original;
        this.extraVMArgument = extraVMArgument;
    }

    public ILaunchConfiguration getOriginal() {
        return this.original;
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public void setAttribute(String attributeName, Set value) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String attributeName, String value) {
        if (VM_ARGUMENTS_KEY.equals(attributeName)) {
            this.delegate.setAttribute(attributeName, this.filterExtraVMArguments(value));
        } else {
            this.delegate.setAttribute(attributeName, value);
        }
    }

    private String filterExtraVMArguments(String vmArguments) {
        return vmArguments.replace(this.extraVMArgument, "").trim();
    }

    public void setAttributes(Map attributes) {
        HashMap<String, String> adjustedAttributes = new HashMap<String, String>(attributes);
        if (attributes.containsKey(VM_ARGUMENTS_KEY)) {
            adjustedAttributes.put(VM_ARGUMENTS_KEY, this.filterExtraVMArguments(attributes.get(VM_ARGUMENTS_KEY).toString()));
        }
        this.delegate.setAttributes(adjustedAttributes);
    }

    public boolean isDirty() {
        return this.delegate.isDirty();
    }

    public ILaunchConfiguration doSave() throws CoreException {
        return this.delegate.doSave();
    }

    public ILaunchConfiguration doSave(int flag) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String attributeName, int value) {
        this.delegate.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, List value) {
        this.delegate.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, Map value) {
        this.delegate.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) {
        this.delegate.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, Object value) {
        throw new UnsupportedOperationException();
    }

    public void rename(String name) {
        this.delegate.rename(name);
    }

    public void setContainer(IContainer container) {
        this.delegate.setContainer(container);
    }

    public void setMappedResources(IResource[] resources) {
        this.delegate.setMappedResources(resources);
    }

    public void setModes(Set modes) {
        this.delegate.setModes(modes);
    }

    public void setPreferredLaunchDelegate(Set modes, String delegateId) {
        this.delegate.setPreferredLaunchDelegate(modes, delegateId);
    }

    public void addModes(Set modes) {
        this.delegate.addModes(modes);
    }

    public void removeModes(Set modes) {
        this.delegate.removeModes(modes);
    }

    public Object removeAttribute(String attributeName) {
        return this.delegate.removeAttribute(attributeName);
    }

    public ILaunchConfigurationWorkingCopy getParent() {
        return this.delegate.getParent();
    }

    public void copyAttributes(ILaunchConfiguration prototype) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setPrototype(ILaunchConfiguration prototype, boolean copy) throws CoreException {
        throw new UnsupportedOperationException();
    }
}

