/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Type;

public class Argument
extends JSNode
implements ISourceable {
    private Identifier identifier;
    private int colonPosition = -1;
    private Type type;
    private int commaPosition = -1;

    public Argument(ASTNode parent) {
        super(parent);
    }

    public String getArgumentName() {
        return this.identifier != null ? this.identifier.getName() : null;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public int getColonPosition() {
        return this.colonPosition;
    }

    public void setColonPosition(int colonPosition) {
        this.colonPosition = colonPosition;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getCommaPosition() {
        return this.commaPosition;
    }

    public void setCommaPosition(int commaPosition) {
        this.commaPosition = commaPosition;
    }

    public String toSourceString(String indentationString) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier.toSourceString(indentationString));
        if (this.type != null) {
            sb.append(":");
            sb.append(this.type.toSourceString(indentationString));
        }
        return sb.toString();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (this.identifier != null) {
            this.identifier.traverse(visitor);
        }
        if (this.type != null) {
            this.type.traverse(visitor);
        }
    }
}

