/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.Disposable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.HideDDiagramElementLabelAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.RevealOutlineLabelsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;

public class TabbarRevealLabelsAction
extends RevealOutlineLabelsAction
implements Disposable {
    private static Predicate<Object> isEnabledPredicate = new Predicate<Object>(){

        public boolean apply(Object input) {
            Option<DDiagramElement> optionTarget;
            boolean result = false;
            if (input instanceof IGraphicalEditPart) {
                result = TabbarRevealLabelsAction.isEnabled((IGraphicalEditPart)input);
            } else if (input instanceof DDiagramElement) {
                result = TabbarRevealLabelsAction.isEnabled((DDiagramElement)input);
            } else if (input instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)input)).getDiagramElementTarget()).some()) {
                result = TabbarRevealLabelsAction.isEnabled((DDiagramElement)optionTarget.get());
            }
            return result;
        }
    };
    private HideDDiagramElementLabelAction oppositeAction;

    public TabbarRevealLabelsAction() {
        this(Messages.RevealOutlineLabelsAction_label);
    }

    public TabbarRevealLabelsAction(String text) {
        this(text, DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/categoryLabelVisible.gif"));
    }

    public TabbarRevealLabelsAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(text);
    }

    public boolean isEnabled() {
        if (this.selection instanceof IStructuredSelection) {
            return TabbarRevealLabelsAction.isEnabled(((IStructuredSelection)this.selection).toList());
        }
        return super.isEnabled();
    }

    public static boolean isEnabled(Collection<?> elementsToCheck) {
        return Iterables.any(elementsToCheck, isEnabledPredicate);
    }

    @Override
    public void selectionChanged(IAction action, ISelection s) {
        super.selectionChanged(action, s);
        this.setEnabled(true);
        if (s instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            this.setEnabled(TabbarRevealLabelsAction.isEnabled(((DiagramOutlinePage.TreeSelectionWrapper)s).toList()));
        } else if (s instanceof IStructuredSelection) {
            this.setEnabled(TabbarRevealLabelsAction.isEnabled(((IStructuredSelection)s).toList()));
        }
    }

    @Override
    protected boolean doRun(Object element) {
        boolean value = super.doRun(element);
        if (this.oppositeAction != null) {
            this.oppositeAction.setEnabled(this.oppositeAction.isEnabled());
        }
        this.setEnabled(this.isEnabled());
        return value;
    }

    private static boolean isEnabled(IGraphicalEditPart graphicalEditPart) {
        boolean result = false;
        if (graphicalEditPart.isActive() && graphicalEditPart.resolveSemanticElement() instanceof DDiagramElement) {
            DDiagramElement resolveSemanticElement = (DDiagramElement)graphicalEditPart.resolveSemanticElement();
            result = graphicalEditPart instanceof AbstractDEdgeNameEditPart ? new DDiagramElementQuery(resolveSemanticElement).isLabelHidden(new EditPartQuery(graphicalEditPart).getVisualID()) : TabbarRevealLabelsAction.isEnabled(resolveSemanticElement);
        }
        return result;
    }

    private static boolean isEnabled(DDiagramElement diagramElement) {
        DDiagram dDiagram = diagramElement.getParentDiagram();
        DDiagramElementQuery query = new DDiagramElementQuery(diagramElement);
        return dDiagram != null && TabbarRevealLabelsAction.isEditable(dDiagram) && query.hasAnyHiddenLabel();
    }

    private static boolean isEditable(DDiagram diagram) {
        boolean isEditable = false;
        Resource resource = diagram.eResource();
        if (resource != null) {
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resource.getResourceSet());
            isEditable = permissionAuthority.canEditInstance((EObject)diagram);
        }
        return isEditable;
    }

    public void setOppositeHideAction(HideDDiagramElementLabelAction action) {
        this.oppositeAction = action;
    }

    @Override
    public void dispose() {
        this.selection = null;
        this.oppositeAction = null;
        super.dispose();
    }
}

