/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.tools.api.figure.IWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.svg.SimpleImageTranscoder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.swt.graphics.Image;

public class SVGWorkspaceImageFigure
extends SVGFigure
implements IWorkspaceImageFigure {
    private double imageAspectRatioForModeWithViewBox = 1.0;

    public SVGWorkspaceImageFigure() {
        this.minSize = new Dimension(0, 0);
    }

    public static SVGWorkspaceImageFigure createImageFigure(WorkspaceImage image) {
        SVGWorkspaceImageFigure fig = new SVGWorkspaceImageFigure();
        fig.refreshFigure(image);
        return fig;
    }

    public void setSize(int w, int h) {
        if (this.modeWithViewBox) {
            int newHeight = (int)((double)w / this.imageAspectRatioForModeWithViewBox);
            super.setSize(w, newHeight);
        } else {
            super.setSize(w, h);
        }
    }

    public void setMaximumSize(Dimension d) {
        super.setMaximumSize(this.getSize());
    }

    public void setMinimumSize(Dimension d) {
        super.setMinimumSize(this.getSize());
    }

    public void setPreferredSize(Dimension size) {
        super.setPreferredSize(this.getSize());
    }

    @Override
    public void refreshFigure(ContainerStyle containerStyle) {
        if (containerStyle instanceof FlatContainerStyle) {
            FlatContainerStyle style = (FlatContainerStyle)containerStyle;
            boolean updated = this.updateImageURI(style.getBackgroundStyle().getName());
            if (updated) {
                this.contentChanged();
            }
        } else if (containerStyle instanceof WorkspaceImage) {
            this.refreshFigure((WorkspaceImage)containerStyle);
        } else {
            this.setURI(null);
        }
    }

    @Override
    public void refreshFigure(WorkspaceImage workspaceImage) {
        if (workspaceImage != null) {
            boolean updated = this.updateImageURI(workspaceImage.getWorkspacePath());
            if (updated) {
                this.contentChanged();
                SimpleImageTranscoder transcoder = this.getTranscoder();
                if (transcoder != null) {
                    this.imageAspectRatioForModeWithViewBox = transcoder.getAspectRatio();
                }
            }
        } else {
            this.setURI(null);
        }
    }

    private boolean updateImageURI(String workspacePath) {
        if (workspacePath != null) {
            Option<String> existingImageUri = SVGWorkspaceImageFigure.getImageUri(workspacePath, false);
            if (existingImageUri.some()) {
                this.setURI((String)existingImageUri.get());
            } else {
                this.setURI(SVGFigure.IMAGE_NOT_FOUND_URI);
            }
            return true;
        }
        return false;
    }

    private static Option<String> getImageUri(String workspacePath, boolean force) {
        File imageFile = FileProvider.getDefault().getFile((IPath)new Path(workspacePath));
        if (imageFile != null && (force || imageFile.exists() && imageFile.canRead())) {
            return Options.newSome((Object)imageFile.toURI().toString());
        }
        Option nonExistingFile = Options.newNone();
        if (force) {
            nonExistingFile = Options.newSome((Object)(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString() + workspacePath));
        }
        return nonExistingFile;
    }

    public static Image flyWeightImage(String path) {
        SVGWorkspaceImageFigure fig = new SVGWorkspaceImageFigure();
        fig.updateImageURI(path);
        fig.contentChanged();
        return fig.getImage((Rectangle)new PrecisionRectangle(0.0, 0.0, -1.0, -1.0), null);
    }

    public static Option<String> removeFromCache(String workspacePath) {
        Option<String> imageUri = SVGWorkspaceImageFigure.getImageUri(workspacePath, true);
        if (imageUri.some() && SVGFigure.doRemoveFromCache((String)imageUri.get())) {
            return imageUri;
        }
        return Options.newNone();
    }
}

