/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.p2packing;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.options.InternalProperties;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.alg.rectpacking.p2packing.Compaction;
import org.eclipse.elk.alg.rectpacking.p2packing.InitialPlacement;
import org.eclipse.elk.alg.rectpacking.util.Block;
import org.eclipse.elk.alg.rectpacking.util.BlockRow;
import org.eclipse.elk.alg.rectpacking.util.BlockStack;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.alg.rectpacking.util.DrawingDataDescriptor;
import org.eclipse.elk.alg.rectpacking.util.DrawingUtil;
import org.eclipse.elk.alg.rectpacking.util.RectRow;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkNode;

public class RowFillingAndCompaction {
    private double aspectRatio;
    private double nodeNodeSpacing;
    public double potentialRowWidthDecreaseMin = Double.POSITIVE_INFINITY;
    public double potentialRowWidthDecreaseMax = 0.0;
    public double potentialRowWidthIncreaseMin = Double.POSITIVE_INFINITY;
    public double potentialRowWidthIncreaseMax = 0.0;

    public RowFillingAndCompaction(double aspectRatio, double nodeNodeSpacing) {
        this.aspectRatio = aspectRatio;
        this.nodeNodeSpacing = nodeNodeSpacing;
    }

    public DrawingData start(List<ElkNode> rectangles, IElkProgressMonitor progressMonitor, ElkNode layoutGraph, ElkPadding padding) {
        double targetWidth = (Double)layoutGraph.getProperty(InternalProperties.TARGET_WIDTH);
        double minWidth = (Double)layoutGraph.getProperty(InternalProperties.MIN_WIDTH);
        double minHeight = (Double)layoutGraph.getProperty(InternalProperties.MIN_HEIGHT);
        DrawingUtil.resetCoordinates((List<ElkNode>)layoutGraph.getChildren());
        List<RectRow> rows = InitialPlacement.place((List<ElkNode>)layoutGraph.getChildren(), targetWidth, this.nodeNodeSpacing);
        int rowIdx = 0;
        while (rowIdx < rows.size()) {
            Pair<Boolean, Boolean> result;
            RectRow currentRow = rows.get(rowIdx);
            if (rowIdx != 0) {
                RectRow previousRow = rows.get(rowIdx - 1);
                currentRow.setY(previousRow.getY() + previousRow.getHeight() + this.nodeNodeSpacing);
            }
            if (((Boolean)(result = Compaction.compact(rowIdx, rows, targetWidth, this.nodeNodeSpacing, (Boolean)layoutGraph.getProperty(RectPackingOptions.PACKING_COMPACTION_ROW_HEIGHT_REEVALUATION))).getSecond()).booleanValue()) {
                for (Block block : currentRow.getChildren()) {
                    block.setFixed(false);
                    block.setPositionFixed(false);
                    block.resetBlock();
                }
                currentRow.resetStacks();
                currentRow.setWidth(targetWidth);
                --rowIdx;
            } else {
                this.adjustWidthAndHeight(currentRow);
                if (rowIdx + 1 < rows.size()) {
                    this.potentialRowWidthIncreaseMax = Math.max(currentRow.getWidth() + this.nodeNodeSpacing + rows.get(rowIdx + 1).getFirstBlock().getWidth() - targetWidth, this.potentialRowWidthDecreaseMax);
                    this.potentialRowWidthIncreaseMin = Math.min(currentRow.getWidth() + this.nodeNodeSpacing + rows.get(rowIdx + 1).getFirstBlock().getWidth() - targetWidth, this.potentialRowWidthDecreaseMin);
                    if (currentRow.getStacks().size() != 0) {
                        this.potentialRowWidthDecreaseMax = Math.max(this.potentialRowWidthDecreaseMax, currentRow.getStacks().get(currentRow.getStacks().size() - 1).getWidth() + (currentRow.getStacks().size() <= 1 ? 0.0 : this.nodeNodeSpacing));
                        this.potentialRowWidthDecreaseMin = Math.min(this.potentialRowWidthDecreaseMax, currentRow.getStacks().get(currentRow.getStacks().size() - 1).getWidth() + (currentRow.getStacks().size() <= 1 ? 0.0 : this.nodeNodeSpacing));
                    }
                }
                if (rows.size() == 1) {
                    BlockStack lastStack = currentRow.getStacks().get(currentRow.getStacks().size() - 1);
                    Block lastBlock = lastStack.getBlocks().get(lastStack.getBlocks().size() - 1);
                    for (BlockRow blockRow : lastBlock.getRows()) {
                        this.potentialRowWidthDecreaseMax = Math.max(this.potentialRowWidthDecreaseMax, lastBlock.getWidth() - blockRow.getWidth());
                        this.potentialRowWidthDecreaseMin = Math.min(this.potentialRowWidthDecreaseMin, lastBlock.getWidth() - blockRow.getWidth());
                        this.potentialRowWidthIncreaseMax = Math.max(this.potentialRowWidthIncreaseMax, blockRow.getWidth() + this.nodeNodeSpacing);
                        this.potentialRowWidthIncreaseMin = Math.min(this.potentialRowWidthIncreaseMin, blockRow.getWidth() + this.nodeNodeSpacing);
                    }
                }
                if (progressMonitor.isLoggingEnabled()) {
                    progressMonitor.logGraph(layoutGraph, "Compacted row " + rowIdx);
                }
            }
            ++rowIdx;
        }
        KVector size = DrawingUtil.calculateDimensions(rows, this.nodeNodeSpacing);
        double totalWidth = Math.max(size.x, minWidth - padding.getHorizontal());
        double height = Math.max(size.y, minHeight - padding.getVertical());
        double additionalHeight = height - size.y;
        layoutGraph.setProperty(InternalProperties.ADDITIONAL_HEIGHT, (Object)additionalHeight);
        layoutGraph.setProperty(InternalProperties.ROWS, rows);
        return new DrawingData(this.aspectRatio, totalWidth, size.y + additionalHeight, DrawingDataDescriptor.WHOLE_DRAWING);
    }

    private void adjustWidthAndHeight(RectRow row) {
        double maxHeight = 0.0;
        double maxWidth = 0.0;
        int index = 0;
        for (BlockStack stack : row.getStacks()) {
            stack.updateDimension();
            maxHeight = Math.max(maxHeight, stack.getHeight());
            maxWidth += stack.getWidth() + (index > 0 ? this.nodeNodeSpacing : 0.0);
            ++index;
        }
        row.setHeight(maxHeight);
        row.setWidth(maxWidth);
    }
}

