/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.InterpreterStatusFactory;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.internal.interpreter.AbstractInterpreter;

public class VariableInterpreter
extends AbstractInterpreter
implements IInterpreter,
IInterpreterProvider {
    public static final String PREFIX = "var:";
    public static final String SELF_VARIABLE_NAME = "self";

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Object evaluate(EObject target, String expression) throws EvaluationException {
        Object result = null;
        if (target != null && this.provides(expression)) {
            String variableName = expression.trim().substring(PREFIX.length());
            result = this.evaluateVariable(target, variableName);
        }
        return result;
    }

    protected Object evaluateVariable(EObject target, String variableName) throws EvaluationException {
        Object result = null;
        if (target != null && variableName != null) {
            if (SELF_VARIABLE_NAME.equals(variableName)) {
                result = target;
            } else if (this.variables.getVariables().containsKey(variableName)) {
                result = this.variables.getVariable(variableName);
            } else {
                throw new EvaluationException(MessageFormat.format(Messages.VariableInterpreter_unknownVariable, variableName));
            }
        }
        return result;
    }

    @Override
    public IInterpreter createInterpreter() {
        return new VariableInterpreter();
    }

    @Override
    public boolean supportsValidation() {
        return true;
    }

    @Override
    public ValidationResult analyzeExpression(IInterpreterContext context, String expression) {
        ValidationResult result = new ValidationResult();
        if (expression != null && context != null && expression.startsWith(PREFIX)) {
            String variableName = expression.substring(PREFIX.length());
            if (!context.getVariables().containsKey(variableName) && !SELF_VARIABLE_NAME.equals(variableName)) {
                result.addStatus(InterpreterStatusFactory.createInterpreterStatus(context, "error", MessageFormat.format(Messages.VariableInterpreter_unkownVariable, variableName)));
            }
            if (SELF_VARIABLE_NAME.equals(variableName)) {
                VariableType firstType = context.getTargetType();
                if (firstType != null) {
                    result.setReturnType(firstType);
                }
            } else {
                VariableType returnType = context.getVariables().get(variableName);
                if (returnType != null) {
                    result.setReturnType(returnType);
                }
            }
        }
        return result;
    }
}

