/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.options;

import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.p2layers.BreadthFirstModelOrderLayerer;
import org.eclipse.elk.alg.layered.p2layers.CoffmanGrahamLayerer;
import org.eclipse.elk.alg.layered.p2layers.DepthFirstModelOrderLayerer;
import org.eclipse.elk.alg.layered.p2layers.InteractiveLayerer;
import org.eclipse.elk.alg.layered.p2layers.LongestPathLayerer;
import org.eclipse.elk.alg.layered.p2layers.LongestPathSourceLayerer;
import org.eclipse.elk.alg.layered.p2layers.MinWidthLayerer;
import org.eclipse.elk.alg.layered.p2layers.NetworkSimplexLayerer;
import org.eclipse.elk.alg.layered.p2layers.StretchWidthLayerer;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;

public enum LayeringStrategy implements ILayoutPhaseFactory<LayeredPhases, LGraph>
{
    NETWORK_SIMPLEX,
    LONGEST_PATH,
    LONGEST_PATH_SOURCE,
    COFFMAN_GRAHAM,
    INTERACTIVE,
    STRETCH_WIDTH,
    MIN_WIDTH,
    BF_MODEL_ORDER,
    DF_MODEL_ORDER;


    public ILayoutPhase<LayeredPhases, LGraph> create() {
        switch (this) {
            case NETWORK_SIMPLEX: {
                return new NetworkSimplexLayerer();
            }
            case LONGEST_PATH: {
                return new LongestPathLayerer();
            }
            case COFFMAN_GRAHAM: {
                return new CoffmanGrahamLayerer();
            }
            case INTERACTIVE: {
                return new InteractiveLayerer();
            }
            case STRETCH_WIDTH: {
                return new StretchWidthLayerer();
            }
            case MIN_WIDTH: {
                return new MinWidthLayerer();
            }
            case LONGEST_PATH_SOURCE: {
                return new LongestPathSourceLayerer();
            }
            case BF_MODEL_ORDER: {
                return new BreadthFirstModelOrderLayerer();
            }
            case DF_MODEL_ORDER: {
                return new DepthFirstModelOrderLayerer();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the layerer " + this.toString());
    }
}

