/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.query.RangeComparator;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ReversedRangeComparator;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceDiagramQuery;
import org.eclipse.sirius.diagram.sequence.description.tool.CombinedFragmentCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InteractionUseCreationTool;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractSequenceInteractionValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.CreateRequestQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class FrameCreationValidator
extends AbstractSequenceInteractionValidator {
    public static final String ORIGINAL_TARGET = "original.target";
    private static final String VALIDATOR = "org.eclipse.sirius.sequence.frame.creation.validator";
    private SequenceDiagram sequenceDiagram;
    private SequenceDiagramQuery sequenceDiagramQuery;
    private Collection<Lifeline> coverage;
    private EventEnd startingEndPredecessor;
    private EventEnd finishingEndPredecessor;
    private Multimap<Lifeline, ISequenceEvent> sequenceEventsInCreationRange;
    private Set<ISequenceEvent> eventsToShift;
    private Set<ISequenceEvent> localParents;
    private final ContainerCreationDescription ccdTool;
    private Rectangle creationBounds;

    public FrameCreationValidator(SequenceDiagram sequenceDiagram, ContainerCreationDescription ccdTool, CreateRequestQuery createRequestQuery) {
        super(createRequestQuery);
        this.creationBounds = createRequestQuery.getLogicalDelta();
        this.sequenceDiagram = sequenceDiagram;
        this.ccdTool = ccdTool;
        this.sequenceDiagramQuery = new SequenceDiagramQuery(sequenceDiagram);
        this.sequenceEventsInCreationRange = HashMultimap.create();
        this.eventsToShift = new TreeSet<ISequenceEvent>((Comparator<ISequenceEvent>)new RangeComparator());
        this.localParents = new HashSet<ISequenceEvent>();
    }

    @Override
    public SequenceDiagram getDiagram() {
        return this.sequenceDiagram;
    }

    @Override
    public Function<ISequenceEvent, Range> getRangeFunction() {
        return ISequenceEvent.VERTICAL_RANGE;
    }

    @Override
    protected void doValidation() {
        int firstClickY = this.creationBounds.y;
        int secondClickY = this.creationBounds.bottom();
        Range creationRange = new Range(firstClickY, secondClickY);
        this.computeCoverage();
        if (!this.coverage.isEmpty() || this.creationBounds.width > 0 || this.creationBounds.height > 0) {
            this.createdElements.add(creationRange);
        }
        boolean bl = this.valid = !this.coverage.isEmpty();
        if (this.valid) {
            this.valid = this.categorizeOverlappedEvents(creationRange);
            if (this.valid) {
                this.computeExpanzionZone(creationRange);
            }
            this.computeSemanticPredecessors(firstClickY);
        }
    }

    private void computeExpanzionZone(Range creationRange) {
        block4: {
            Range newExpansionZone;
            int expansionCut;
            block5: {
                if (!(this.ccdTool instanceof InteractionUseCreationTool)) break block5;
                for (ISequenceEvent parent : this.localParents) {
                    Range newExpansionZone2 = new Range(parent.getVerticalRange().getUpperBound() - 1, creationRange.getUpperBound());
                    this.expansionZone = this.expansionZone.union(newExpansionZone2);
                }
                TreeSet overlapped = new TreeSet(new RangeComparator());
                overlapped.addAll(this.sequenceEventsInCreationRange.values());
                for (ISequenceEvent ise : Iterables.filter(overlapped, (Predicate)Predicates.not((Predicate)Predicates.in(this.localParents)))) {
                    int lowerBound = ise.getVerticalRange().getLowerBound();
                    if (lowerBound < creationRange.getLowerBound()) continue;
                    Range newExpansionZone3 = new Range(lowerBound - 1, creationRange.getUpperBound());
                    this.expansionZone = this.expansionZone.union(newExpansionZone3);
                    break block4;
                }
                break block4;
            }
            if (!(this.ccdTool instanceof CombinedFragmentCreationTool)) break block4;
            ArrayList partialOverlaps = Lists.newArrayList((Iterable)Iterables.concat(this.localParents, this.eventsToShift));
            for (ISequenceEvent parent : this.localParents) {
                this.checkOtherLifelines(parent, partialOverlaps);
                expansionCut = Math.max(creationRange.getLowerBound(), parent.getVerticalRange().getUpperBound() - 1);
                newExpansionZone = new Range(expansionCut, creationRange.getUpperBound());
                this.expansionZone = this.expansionZone.union(newExpansionZone);
            }
            for (ISequenceEvent eventToShift : this.eventsToShift) {
                this.checkOtherLifelines(eventToShift, partialOverlaps);
                expansionCut = Math.max(creationRange.getLowerBound(), eventToShift.getVerticalRange().getLowerBound() - 1);
                newExpansionZone = new Range(expansionCut, creationRange.getUpperBound());
                this.expansionZone = this.expansionZone.union(newExpansionZone);
            }
        }
    }

    private void computeSemanticPredecessors(int firstClickY) {
        SequenceDDiagram sequenceDDiagram = this.sequenceDiagram.getSequenceDDiagram();
        this.startingEndPredecessor = SequenceGraphicalHelper.getEndBefore(sequenceDDiagram, firstClickY - 1);
        this.finishingEndPredecessor = this.expansionZone != null && !this.expansionZone.isEmpty() ? SequenceGraphicalHelper.getEndBefore(sequenceDDiagram, this.expansionZone.getLowerBound()) : SequenceGraphicalHelper.getEndBefore(sequenceDDiagram, this.creationBounds.getBottom().y);
    }

    private void checkOtherLifelines(ISequenceEvent eventToCheck, Collection<ISequenceEvent> eventsToIgnore) {
        Range rangeToCheck = eventToCheck.getVerticalRange();
        for (Lifeline lifeline : this.sequenceEventsInCreationRange.keySet()) {
            Collection overlap = this.sequenceEventsInCreationRange.get((Object)lifeline);
            if (overlap.contains(eventToCheck)) continue;
            for (ISequenceEvent otherLifelineEvent : Iterables.filter((Iterable)overlap, (Predicate)Predicates.not((Predicate)Predicates.in(eventsToIgnore)))) {
                Range otherRange = otherLifelineEvent.getVerticalRange();
                Range intersection = otherRange.intersection(rangeToCheck);
                if (intersection.equals((Object)rangeToCheck) || intersection.equals((Object)otherRange) || intersection.isEmpty()) continue;
                this.valid = false;
            }
        }
    }

    private void computeCoverage() {
        this.coverage = new LinkedHashSet<Lifeline>();
        Set graphicallyCoveredLifelines = this.sequenceDiagram.getGraphicallyCoveredLifelines(this.creationBounds);
        Object originalTarget = this.request.getExtendedData().get(ORIGINAL_TARGET);
        if (originalTarget instanceof ISequenceEventEditPart) {
            ISequenceEventEditPart sequenceEventEditPart = (ISequenceEventEditPart)originalTarget;
            Option optLifeline = sequenceEventEditPart.getISequenceEvent().getLifeline();
            if (optLifeline.some()) {
                Lifeline lifeline = (Lifeline)optLifeline.get();
                this.request.getExtendedData().remove(ORIGINAL_TARGET);
                this.coverage.add(lifeline);
            }
        } else {
            for (Lifeline coveredLifeline : this.computeGraphicalCoverageFromSelectionArea(graphicallyCoveredLifelines)) {
                this.coverage.add(coveredLifeline);
            }
            for (InteractionUse iu : this.sequenceDiagram.getAllInteractionUses()) {
                if (!iu.getVerticalRange().includes(this.creationBounds.y)) continue;
                Collection iuLifelines = iu.computeCoveredLifelines();
                this.coverage.removeAll(iuLifelines);
            }
        }
    }

    private boolean categorizeOverlappedEvents(Range creationRange) {
        HashSet<ISequenceEvent> checkedSequenceEvents = new HashSet<ISequenceEvent>();
        for (Lifeline lifeline : this.coverage) {
            this.categorizeOverlappedEvents(lifeline, creationRange, checkedSequenceEvents);
        }
        return this.eventInError.isEmpty();
    }

    private void categorizeOverlappedEvents(Lifeline lifeline, Range creationRange, Collection<ISequenceEvent> alreadyChecked) {
        SortedSet overlappedEvents = this.sequenceDiagramQuery.getAllSequenceEventsOnLifelineOnRange(lifeline, creationRange);
        if (!overlappedEvents.isEmpty()) {
            this.sequenceEventsInCreationRange.putAll((Object)lifeline, (Iterable)overlappedEvents);
            ISequenceEvent lFirstIseInRange = (ISequenceEvent)overlappedEvents.first();
            for (ISequenceEvent ise : overlappedEvents) {
                if (ise.getVerticalRange().getLowerBound() >= creationRange.getLowerBound()) continue;
                lFirstIseInRange = ise;
            }
            TreeSet upperBoundSorted = new TreeSet(new ReversedRangeComparator());
            upperBoundSorted.addAll(overlappedEvents);
            ISequenceEvent lLastIseInRange = (ISequenceEvent)upperBoundSorted.last();
            if (!creationRange.includes(lFirstIseInRange.getVerticalRange().getLowerBound())) {
                this.localParents.add(lFirstIseInRange);
                if (this.ccdTool instanceof InteractionUseCreationTool && lFirstIseInRange instanceof InteractionUse) {
                    this.eventInError.add(lFirstIseInRange);
                }
            }
            if (!creationRange.includes(lLastIseInRange.getVerticalRange().getUpperBound())) {
                this.eventsToShift.add(lLastIseInRange);
            }
            if (this.ccdTool instanceof CombinedFragmentCreationTool) {
                this.categorizeCombinedFragmentOverlappedEvents(creationRange, alreadyChecked, overlappedEvents, lFirstIseInRange);
            }
        }
    }

    private void categorizeCombinedFragmentOverlappedEvents(Range creationRange, Collection<ISequenceEvent> alreadyChecked, SortedSet<ISequenceEvent> overlappedEvents, ISequenceEvent lFirstIseInRange) {
        for (Message message : Iterables.filter(overlappedEvents, Message.class)) {
            Option tgtLifeline;
            if (alreadyChecked.contains(message)) continue;
            alreadyChecked.add((ISequenceEvent)message);
            Option srcLifeline = message.getSourceLifeline();
            if (srcLifeline.some() && !this.coverage.contains(srcLifeline.get())) {
                ISequenceEvent parentEvent = null;
                ISequenceNode targetElement = message.getTargetElement();
                if (targetElement instanceof ISequenceEvent) {
                    parentEvent = this.getHigherAncestorWithLowerBoundInCreationRange((ISequenceEvent)targetElement, creationRange);
                }
                if (parentEvent == null) {
                    this.eventsToShift.add(lFirstIseInRange);
                } else if (!creationRange.includes(parentEvent.getVerticalRange())) {
                    this.eventsToShift.add((ISequenceEvent)message);
                } else {
                    this.eventsToShift.add(parentEvent);
                }
            }
            if (!(tgtLifeline = message.getTargetLifeline()).some() || this.coverage.contains(tgtLifeline.get())) continue;
            ISequenceEvent parentEvent = null;
            ISequenceNode sourceElement = message.getSourceElement();
            if (sourceElement instanceof ISequenceEvent) {
                parentEvent = this.getHigherAncestorWithLowerBoundInCreationRange((ISequenceEvent)sourceElement, creationRange);
            }
            if (parentEvent == null) {
                this.eventsToShift.add(lFirstIseInRange);
                continue;
            }
            if (!creationRange.includes(parentEvent.getVerticalRange())) {
                this.eventsToShift.add((ISequenceEvent)message);
                continue;
            }
            this.eventsToShift.add(parentEvent);
        }
        for (AbstractFrame frame : Iterables.filter(overlappedEvents, AbstractFrame.class)) {
            if (alreadyChecked.contains(frame)) continue;
            alreadyChecked.add((ISequenceEvent)frame);
            Collection coveredLifelines = frame.computeCoveredLifelines();
            if (this.coverage.containsAll(coveredLifelines) || this.eventsToShift.contains(frame) || !creationRange.includes(frame.getVerticalRange().getLowerBound())) continue;
            this.eventsToShift.add((ISequenceEvent)frame);
        }
    }

    private ISequenceEvent getHigherAncestorWithLowerBoundInCreationRange(ISequenceEvent event, Range creationRange) {
        ISequenceEvent parentEvent;
        ISequenceEvent iSequenceEvent = parentEvent = event == null ? null : event.getParentEvent();
        if (parentEvent != null && creationRange.includes(parentEvent.getVerticalRange().getLowerBound())) {
            return this.getHigherAncestorWithLowerBoundInCreationRange(parentEvent, creationRange);
        }
        return event;
    }

    private Set<Lifeline> computeGraphicalCoverageFromSelectionArea(Set<Lifeline> graphicallyCoveredLifelines) {
        LinkedHashSet<Lifeline> validCoverage = new LinkedHashSet<Lifeline>();
        for (Lifeline lifeline : graphicallyCoveredLifelines) {
            if (!this.coveredByDeepestOperand(lifeline, graphicallyCoveredLifelines)) continue;
            validCoverage.add(lifeline);
        }
        return validCoverage;
    }

    private boolean coveredByDeepestOperand(Lifeline lifeline, Set<Lifeline> graphicallyCoveredLifelines) {
        boolean coveredByDeepestOperand = true;
        Range inclusionRange = RangeHelper.verticalRange((Rectangle)this.creationBounds);
        Option<Operand> findDeepestCoveringOperand = this.findDeepestCoveringOperand(graphicallyCoveredLifelines);
        if (findDeepestCoveringOperand.some()) {
            Option parentOperand = lifeline.getParentOperand(inclusionRange);
            coveredByDeepestOperand = parentOperand.some() && ((Operand)findDeepestCoveringOperand.get()).equals(parentOperand.get());
        }
        return coveredByDeepestOperand;
    }

    private Option<Operand> findDeepestCoveringOperand(Set<Lifeline> graphicallyCoveredLifelines) {
        Option deepestOperandOption = Options.newNone();
        for (Lifeline lifeline : graphicallyCoveredLifelines) {
            Option currentOperandOption = lifeline.getParentOperand(RangeHelper.verticalRange((Rectangle)this.creationBounds));
            if (deepestOperandOption.some() && currentOperandOption.some()) {
                Operand deepestOperand = (Operand)deepestOperandOption.get();
                Operand currentOperand = (Operand)currentOperandOption.get();
                if (!deepestOperand.getVerticalRange().includes(currentOperand.getVerticalRange())) continue;
                deepestOperand = currentOperand;
                continue;
            }
            if (deepestOperandOption.some() || !currentOperandOption.some()) continue;
            deepestOperandOption = currentOperandOption;
        }
        return deepestOperandOption;
    }

    public List<EObject> getCoverage() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.coverage, (Function)ISequenceElement.SEMANTIC_TARGET));
    }

    public Rectangle getCreationBounds() {
        return this.creationBounds;
    }

    public EventEnd getStartingEndPredecessor() {
        return this.startingEndPredecessor;
    }

    public EventEnd getFinishingEndPredecessor() {
        return this.finishingEndPredecessor;
    }

    public static FrameCreationValidator getOrCreateValidator(SequenceDiagram sequenceDiagram, ContainerCreationDescription containerCreationDescription, CreateRequestQuery createRequestQuery) {
        FrameCreationValidator validator = null;
        Object object = createRequestQuery.getExtendedData().get(VALIDATOR);
        if (object instanceof FrameCreationValidator) {
            validator = (FrameCreationValidator)object;
            if (validator.request == null || !validator.getCreationBounds().equals((Object)createRequestQuery.getLogicalDelta())) {
                validator = null;
            }
        }
        if (validator == null || createRequestQuery.getExtendedData().get(ORIGINAL_TARGET) != null) {
            validator = new FrameCreationValidator(sequenceDiagram, containerCreationDescription, createRequestQuery);
            createRequestQuery.getExtendedData().put(VALIDATOR, validator);
        }
        return validator;
    }
}

