/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.export.xsl.TransformStyle;
import org.eclipse.set.utils.export.xsl.XMLDocumentExtensions;
import org.eclipse.set.utils.export.xsl.XSLConstant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransformTableBody {
    final Document doc;
    final Sheet sheet;

    public TransformTableBody(Document doc, Sheet sheet) {
        this.doc = doc;
        this.sheet = sheet;
    }

    public Set<Element> getDefaultStyles() {
        return this.getDefaultStyles(this.groupCellByStyle(Collections.emptySet()));
    }

    public Set<Element> getDefaultStyles(Set<Set<Cell>> styleGroup) {
        return styleGroup.stream().flatMap(cells -> Set.of(this.rowStyleTemplate((Set<Cell>)cells), this.lastRowStyleTemplate((Set<Cell>)cells)).stream()).collect(Collectors.toSet());
    }

    private Set<Set<Cell>> groupCellByStyle(Set<Integer> pageBreakAts) {
        LinkedHashSet<Set<Cell>> result = new LinkedHashSet<Set<Cell>>();
        int lastHeaderRowIndex = ExcelWorkbookExtension.getHeaderLastRowIndex(this.sheet);
        Set<Integer> parentGroupLastIndex = this.getColumnWithWideBorderRight();
        Row firstDataRow = this.sheet.getRow(lastHeaderRowIndex + 2);
        if (firstDataRow == null) {
            throw new RuntimeException("Missing first data row. Is the printing area configured correctly?");
        }
        int i = 0;
        while (i <= ExcelWorkbookExtension.getHeaderLastColumnIndex(this.sheet)) {
            Optional<Cell> cellAt = ExcelWorkbookExtension.getCellAt(this.sheet, firstDataRow.getRowNum(), i);
            if (!cellAt.isEmpty()) {
                if (parentGroupLastIndex.contains(i) || pageBreakAts.contains(i)) {
                    TransformStyle.setExcelCellBorderStyle(cellAt, XSLConstant.TableAttribute.BorderDirection.RIGHT, BorderStyle.MEDIUM);
                } else if (pageBreakAts.contains(i - 1)) {
                    TransformStyle.setExcelCellBorderStyle(cellAt, XSLConstant.TableAttribute.BorderDirection.LEFT, BorderStyle.MEDIUM);
                }
                if (!TransformTableBody.isDefaultStyle(cellAt.get().getCellStyle())) {
                    LinkedHashSet<Cell> sameStyleGroup = result.stream().filter(cells -> cells.stream().filter(cell -> TransformTableBody.isEquals(((Cell)cellAt.get()).getCellStyle(), cell.getCellStyle())).findFirst().orElse(null) != null).findFirst().orElse(null);
                    if (sameStyleGroup == null) {
                        sameStyleGroup = new LinkedHashSet<Cell>();
                        result.add(sameStyleGroup);
                    }
                    sameStyleGroup.add(cellAt.get());
                }
            }
            ++i;
        }
        return result;
    }

    private Set<Integer> getColumnWithWideBorderRight() {
        Row headerRow = this.sheet.getRow(1);
        HashSet<Integer> result = new HashSet<Integer>();
        int i = 1;
        while (i <= ExcelWorkbookExtension.getHeaderLastColumnIndex(this.sheet)) {
            Cell cell = headerRow.getCell(i);
            if (cell.getCellStyle().getBorderRight() == BorderStyle.MEDIUM) {
                result.add(i);
            }
            if (i != 1 && cell.getCellStyle().getBorderLeft() == BorderStyle.MEDIUM) {
                result.add(i - 1);
            }
            ++i;
        }
        return result;
    }

    private static boolean isDefaultStyle(CellStyle cellStyle) {
        boolean isDefaultBorder;
        Map<XSLConstant.TableAttribute.BorderDirection, String> borderStyle = TransformStyle.transformBorderStyle(cellStyle);
        boolean bl = isDefaultBorder = borderStyle.values().stream().filter(style -> !style.isEmpty()).count() == 0L;
        return isDefaultBorder && cellStyle.getAlignment() == HorizontalAlignment.CENTER;
    }

    private static boolean isEquals(CellStyle first, CellStyle second) {
        if (first.getAlignment() != second.getAlignment()) {
            return false;
        }
        Map<XSLConstant.TableAttribute.BorderDirection, String> firstBorderStyle = TransformStyle.transformBorderStyle(first);
        Map<XSLConstant.TableAttribute.BorderDirection, String> secondBorderStyle = TransformStyle.transformBorderStyle(second);
        return firstBorderStyle.equals(secondBorderStyle);
    }

    public Set<Element> pageBreakColumnCellStyle(Set<Integer> pageBreakAt) {
        Set<Set<Cell>> groupStyles = this.groupCellByStyle(pageBreakAt);
        Set<Cell> pageBreakColumns = groupStyles.stream().flatMap(group -> group.stream().map(cell -> {
            if (pageBreakAt.contains(cell.getColumnIndex())) {
                return cell;
            }
            return null;
        })).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<Element> pageBreakColumnsStyle = Stream.of(this.rowStyleTemplate(pageBreakColumns), this.lastRowStyleTemplate(pageBreakColumns)).filter(Objects::nonNull).collect(Collectors.toSet());
        pageBreakColumnsStyle.forEach(style -> {
            Element numberCountColStyle = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table-cell", new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.XSL_USE_ATTRIBUTE_SETS, "body-row-cell-style"), new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED, String.format("{@%s}", XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED)));
            Element block = this.doc.createElement("fo:block");
            Element valueOf = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "xsl:value-of", "select", "../@group-number");
            block.appendChild(valueOf);
            numberCountColStyle.appendChild(block);
            Element applyTemplates = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "xsl:apply-templates", "select", "../*[@column-number = '1']");
            style.appendChild(numberCountColStyle);
            style.appendChild(applyTemplates);
        });
        Set defeaultStyle = groupStyles.stream().flatMap(group -> {
            group.removeIf(cell -> pageBreakAt.contains(cell.getColumnIndex()));
            return Stream.of(this.rowStyleTemplate((Set<Cell>)group), this.lastRowStyleTemplate((Set<Cell>)group));
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        pageBreakColumnsStyle.addAll(defeaultStyle);
        return pageBreakColumnsStyle;
    }

    private Element rowStyleTemplate(Set<Cell> exclusionColumns) {
        if (exclusionColumns.isEmpty()) {
            return null;
        }
        String expression = String.format("Cell[contains(' %s ', concat(' ', @column-number, ' ')) and ../@group-number != count(/Table/Rows/Row)]", String.join((CharSequence)" ", exclusionColumns.stream().map(col -> String.valueOf(col.getColumnIndex())).toList()));
        Element template = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "xsl:template", "match", expression);
        Element tableCell = this.createCellStyleElement("default-cell-style", (Cell)exclusionColumns.toArray()[0]);
        template.appendChild(tableCell);
        return template;
    }

    private Element lastRowStyleTemplate(Set<Cell> exclusionColumns) {
        if (exclusionColumns.isEmpty()) {
            return null;
        }
        String expression = String.format("Cell[contains(' %s ', concat(' ', @column-number, ' ')) and ../@group-number = count(/Table/Rows/Row)]", String.join((CharSequence)" ", exclusionColumns.stream().map(col -> String.valueOf(col.getColumnIndex())).toList()));
        Element template = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "xsl:template", "match", expression);
        Element tableCell = this.createCellStyleElement("last-row-cell-style", (Cell)exclusionColumns.toArray()[0]);
        template.appendChild(tableCell);
        return template;
    }

    private Element createCellStyleElement(String styleSets, Cell cell) {
        Element tableCell = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "fo:table-cell", new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.XSL_USE_ATTRIBUTE_SETS, styleSets), new XMLDocumentExtensions.XMLAttribute(XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED, String.format("{@%s}", XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED)));
        TransformStyle.transformCellStyle(tableCell, Optional.of(cell));
        this.addChooseForCompareProjectCell(tableCell);
        tableCell.appendChild(this.doc.createElement("xsl:apply-templates"));
        return tableCell;
    }

    private void addChooseForCompareProjectCell(Element tableCell) {
        Element compareCellBorderAttribute = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "xsl:attribute", new XMLDocumentExtensions.XMLAttribute("name", "border"));
        compareCellBorderAttribute.setTextContent("0.3mm solid #0066FF");
        Element borderColorAttribute = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "xsl:attribute", new XMLDocumentExtensions.XMLAttribute("name", "border-color"));
        borderColorAttribute.setTextContent("black");
        Element chooseElement = this.createChooseElement("CompareProjectContent", compareCellBorderAttribute, borderColorAttribute);
        tableCell.appendChild(chooseElement);
    }

    private Element createChooseElement(String expression, Element ifTrue, Element whenFalse) {
        Element choose = this.doc.createElement("xsl:choose");
        Element when = XMLDocumentExtensions.createXMLElementWithAttr(this.doc, "xsl:when", new XMLDocumentExtensions.XMLAttribute("test", expression));
        choose.appendChild(when);
        when.appendChild(ifTrue);
        Element otherwise = this.doc.createElement("xsl:otherwise");
        otherwise.appendChild(whenFalse);
        choose.appendChild(otherwise);
        return choose;
    }
}

