/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiPredicate;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.set.basis.InitializationData;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class FilenameInitialization<T extends InitializationData>
extends TitleAreaDialog {
    private BiPredicate<Shell, Path> createDirectoryPermission;
    private final DialogService dialogService;
    private BiPredicate<Shell, T> initAction;

    private static Color invalid() {
        return Display.getCurrent().getSystemColor(3);
    }

    private static Color valid() {
        return Display.getCurrent().getSystemColor(1);
    }

    public FilenameInitialization(Shell parentShell, DialogService dialogService) {
        super(parentShell);
        this.dialogService = dialogService;
    }

    public void create() {
        super.create();
        this.setTitle(this.getPageTitle());
        this.setMessage(this.getInitMessage(), 1);
    }

    public abstract String getDialogTitle();

    public abstract String getInitButtonText();

    public abstract T getInitializationData();

    public abstract String getInitMessage();

    public abstract String getPageTitle();

    public void setCreateDirectoryPermission(BiPredicate<Shell, Path> createDirectoryPermission) {
        this.createDirectoryPermission = createDirectoryPermission;
    }

    public void setInitAction(BiPredicate<Shell, T> initAction) {
        this.initAction = initAction;
    }

    private boolean checkCreateDirectory() {
        Path dir = Paths.get(this.getInitializationData().getDirectory(), new String[0]);
        File file = dir.toFile();
        if (file.exists()) {
            return true;
        }
        boolean permission = this.createDirectoryPermission.test(this.getShell(), dir);
        if (permission) {
            file.mkdirs();
            return true;
        }
        return false;
    }

    protected abstract String compileTooltip(String var1);

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.validate();
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.getInitButtonText(), true);
        this.createButton(parent, 1, JFaceResources.getString((String)"cancel"), false);
        this.validate();
    }

    protected DialogService getDialogService() {
        return this.dialogService;
    }

    protected void okPressed() {
        if (this.checkCreateDirectory() && this.initAction.test(this.getShell(), (Shell)this.getInitializationData())) {
            super.okPressed();
        }
    }

    protected abstract void validate();

    protected boolean validate(Text text, String pattern) {
        if (text.getText().matches(pattern)) {
            text.setBackground(FilenameInitialization.valid());
            text.setToolTipText("");
            return true;
        }
        text.setBackground(FilenameInitialization.invalid());
        text.setToolTipText(this.compileTooltip(pattern));
        return false;
    }
}

