/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.browserfunctions;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.feature.siteplan.Messages;
import org.eclipse.set.feature.siteplan.SiteplanBrowser;
import org.eclipse.set.feature.siteplan.browserfunctions.SelectFolderDialogBrowserFunction;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToFreeFieldTransformation;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToTitleboxTransformation;
import org.eclipse.set.services.export.ExportService;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.exception.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;

public class ExportSiteplanBrowserFunction
extends SelectFolderDialogBrowserFunction {
    private final List<BufferedImage> exportImages = new LinkedList<BufferedImage>();
    private final IModelSession modelSession;
    private final ExportService exportService;
    private final Messages message;
    private final SessionService sessionService;

    public ExportSiteplanBrowserFunction(SiteplanBrowser browser, String name, IModelSession modelSession, SessionService sessionService, ExportService exportService, Shell shell, DialogService dialogService, Messages message) {
        super(browser, name, shell, dialogService);
        this.modelSession = modelSession;
        this.sessionService = sessionService;
        this.exportService = exportService;
        this.message = message;
    }

    @Override
    public Object function(Object[] arguments) {
        this.exportImages.clear();
        Optional optionalOutputDir = this.dialogService.selectDirectory(this.shell, ToolboxConfiguration.getDefaultPath().toString());
        String key = (String)arguments[0];
        int sheetcutCount = Integer.parseInt((String)arguments[1]);
        double ppm = Double.parseDouble((String)arguments[2]);
        optionalOutputDir.ifPresentOrElse(outputDir -> {
            this.webBrowser.executeJavascript(String.format("%s('%s', '%s');", "window.planproSelectFolderDialogCallback", key, outputDir.replace("\\", "\\\\")));
            this.webBrowser.setBeforeDownloadFunc(url -> this.sheetcutImageHandle((String)url, sheetcutCount, Path.of(outputDir, new String[0]), ppm));
        }, () -> this.webBrowser.executeJavascript(String.format("%s('%s', null);", "window.planproSelectFolderDialogCallback", key)));
        return null;
    }

    private void sheetcutImageHandle(String url, int sheetcutcount, Path outDir, double ppm) {
        String base64Data = url.split(",")[1];
        byte[] decode = Base64.getDecoder().decode(base64Data);
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (ByteArrayInputStream inputstream = new ByteArrayInputStream(decode);){
                BufferedImage bufferedImage = ImageIO.read(inputstream);
                this.exportImages.add(bufferedImage);
                if (this.exportImages.size() >= sheetcutcount) {
                    PlanProToFreeFieldTransformation planProToFreeField = PlanProToFreeFieldTransformation.create();
                    FreeFieldInfo freeFieldInfo = planProToFreeField.transform(this.modelSession);
                    this.dialogService.showProgressUISync(this.shell, this.message.WebSiteplanPart_Export, () -> {
                        this.exportService.exportSiteplanPdf(this.exportImages, this.createTitleBox(), freeFieldInfo, ppm, outDir.toAbsolutePath().toString(), this.modelSession.getToolboxPaths(), this.modelSession.getTableType(), OverwriteHandling.forCheckbox((boolean)true), (Consumer)new ExceptionHandler(this.shell, this.dialogService));
                        this.exportImages.clear();
                    });
                    this.dialogService.openDirectoryAfterExport(this.shell, outDir);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.dialogService.error(this.shell, (Exception)e);
        }
    }

    private Titlebox createTitleBox() {
        PlanProToTitleboxTransformation titleBoxTransform = new PlanProToTitleboxTransformation(this.sessionService);
        return titleBoxTransform.transform(null, null);
    }
}

