/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.overviewplan.track;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.set.feature.overviewplan.track.TOPKanteMetaData;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.xtext.xbase.lib.Pair;

public class OverviewplanTrack {
    public Map<TOP_Knoten, OverviewplanTrack> leftTracks = new HashMap<TOP_Knoten, OverviewplanTrack>();
    public int lvl = 0;
    public boolean fixedLvl = false;
    public Map<TOP_Knoten, OverviewplanTrack> rightTracks = new HashMap<TOP_Knoten, OverviewplanTrack>();
    private final List<TOPKanteMetaData> topEdges = new LinkedList<TOPKanteMetaData>();
    private final List<TOP_Knoten> topNodes = new LinkedList<TOP_Knoten>();

    public OverviewplanTrack(TOPKanteMetaData edge) {
        this.topEdges.add(edge);
        this.addTrackSections(edge, edge.getTopNodeA());
        Collections.reverse(this.topEdges);
        this.addTrackSections(edge, edge.getTopNodeB());
    }

    public List<TOPKanteMetaData> getTopEdges() {
        return this.topEdges;
    }

    public List<TOP_Knoten> getTopNodes() {
        if (!this.topNodes.isEmpty()) {
            return this.topNodes;
        }
        TOPKanteMetaData first = this.topEdges.get(0);
        List<Pair<TOP_Knoten, TOPKanteMetaData>> continuousEdges = first.getContinuousEdges();
        if (continuousEdges.isEmpty()) {
            this.topNodes.add(first.getTopNodeA());
            this.topNodes.add(first.getTopNodeB());
            return this.topNodes;
        }
        Pair<TOP_Knoten, TOPKanteMetaData> pair = continuousEdges.get(0);
        TOP_Knoten connectNode = (TOP_Knoten)pair.getKey();
        this.topNodes.add(first.getNextTopNode(connectNode));
        TOPKanteMetaData continuous = (TOPKanteMetaData)pair.getValue();
        while (continuous != null) {
            this.topNodes.add(connectNode);
            connectNode = continuous.getNextTopNode(connectNode);
            continuous = continuous.getContinuousEdgeAt(connectNode);
        }
        this.topNodes.add(connectNode);
        return this.topNodes;
    }

    public boolean isSingleEdgeTrack() {
        return this.topEdges.size() == 1;
    }

    private void addTrackSections(TOPKanteMetaData md, TOP_Knoten topNode) {
        if (md == null) {
            return;
        }
        TOPKanteMetaData continuous = md.getContinuousEdgeAt(topNode);
        if (continuous == null || this.topEdges.contains(continuous)) {
            return;
        }
        this.topEdges.add(continuous);
        this.addTrackSections(continuous, continuous.getNextTopNode(topNode));
    }
}

