/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public abstract class DefaultStackPresentationSite
implements IStackPresentationSite {
    private StackPresentation presentation;
    private int state = 2;
    private int activeState = 0;

    public void setPresentation(StackPresentation newPresentation) {
        this.presentation = newPresentation;
        if (this.presentation != null) {
            this.presentation.setState(this.state);
            this.presentation.setActive(this.activeState);
        }
    }

    public StackPresentation getPresentation() {
        return this.presentation;
    }

    @Override
    public int getState() {
        return this.state;
    }

    public void setActive(int activeState) {
        if (activeState != this.activeState) {
            this.activeState = activeState;
            if (this.presentation != null) {
                this.presentation.setActive(activeState);
            }
        }
    }

    public int getActive() {
        return this.activeState;
    }

    @Override
    public void selectPart(IPresentablePart toSelect) {
        if (this.presentation != null) {
            this.presentation.selectPart(toSelect);
        }
    }

    public void dispose() {
        if (this.presentation != null) {
            this.presentation.dispose();
        }
        this.setPresentation(null);
    }

    @Override
    public void setState(int newState) {
        this.setPresentationState(newState);
    }

    public void setPresentationState(int newState) {
        this.state = newState;
        if (this.presentation != null) {
            this.presentation.setState(newState);
        }
    }

    @Override
    public boolean isCloseable(IPresentablePart part) {
        return part.isCloseable();
    }

    @Override
    public void dragStart(IPresentablePart beingDragged, Point initialPosition, boolean keyboard) {
    }

    public void close(IPresentablePart toClose) {
    }

    @Override
    public void dragStart(Point initialPosition, boolean keyboard) {
    }

    @Override
    public boolean supportsState(int state) {
        return true;
    }

    @Override
    public abstract IPresentablePart getSelectedPart();

    @Override
    public void addSystemActions(IMenuManager menuManager) {
    }

    @Override
    public abstract boolean isPartMoveable(IPresentablePart var1);

    @Override
    public abstract boolean isStackMoveable();
}

