/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ai.mcp.transports;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import org.eclipse.ecf.ai.mcp.transports.AbstractStringChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStringChannel
extends AbstractStringChannel {
    private static final Logger logger = LoggerFactory.getLogger(ServerStringChannel.class);
    protected SocketChannel acceptedClient;

    public ServerStringChannel() throws IOException {
    }

    public ServerStringChannel(Selector selector, int incomingBufferSize, ExecutorService executor) {
        super(selector, incomingBufferSize, executor);
    }

    public ServerStringChannel(Selector selector, int incomingBufferSize) {
        super(selector, incomingBufferSize);
    }

    public ServerStringChannel(Selector selector) {
        super(selector);
    }

    protected void configureServerSocketChannel(ServerSocketChannel serverSocketChannel, SocketAddress acceptAddress) {
    }

    public void start(StandardProtocolFamily protocol, SocketAddress address, AbstractStringChannel.IOConsumer<SocketChannel> acceptHandler, AbstractStringChannel.IOConsumer<String> readHandler) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open(protocol);
        serverChannel.configureBlocking(false);
        serverChannel.register(this.selector, 16);
        this.configureServerSocketChannel(serverChannel, address);
        serverChannel.bind(address);
        super.start(client -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting client=" + String.valueOf(client));
            }
            this.acceptedClient = client;
            if (acceptHandler != null) {
                acceptHandler.apply(this.acceptedClient);
            }
        }, null, readHandler);
    }

    @Override
    protected void handleException(SelectionKey key, Throwable e) {
        if (logger.isDebugEnabled()) {
            logger.debug("handleException", e);
        }
        this.close();
    }

    public void writeMessage(String message) throws IOException {
        SocketChannel c = this.acceptedClient;
        if (c != null) {
            this.writeMessageToChannel(c, message);
        } else if (logger.isDebugEnabled()) {
            logger.debug("No acceptedClient attached to writeMessage={}", (Object)message);
        }
    }

    @Override
    public void close() {
        SocketChannel client = this.acceptedClient;
        if (client != null) {
            this.hardCloseClient(client, c -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unsetting client=" + String.valueOf(c));
                }
                this.acceptedClient = null;
            });
        }
    }
}

