/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import java.util.Collections;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;

public class NodePositionHelper {
    private final boolean snapToGrid;
    private final int gridSpacing;

    public NodePositionHelper(boolean snapToGrid, int gridSpacing) {
        this.snapToGrid = snapToGrid;
        this.gridSpacing = gridSpacing;
    }

    public Point getOnBorderPositionFromParent(Node node, Point contextLocation, Dimension size) {
        AbstractDNode port = (AbstractDNode)node.getElement();
        Node parent = (Node)node.eContainer();
        CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parent, 29, this.snapToGrid, this.gridSpacing);
        Dimension borderOffsets = IBorderItemOffsets.DEFAULT_OFFSET;
        if (new ViewQuery((View)node).isForNameEditPart()) {
            borderOffsets = IBorderItemOffsets.NO_OFFSET;
        } else if (new DDiagramElementQuery((DDiagramElement)port).isIndirectlyCollapsed()) {
            borderOffsets = IBorderItemOffsets.COLLAPSE_FILTER_OFFSET;
        }
        locator.setBorderItemOffset(borderOffsets);
        Rectangle constraint = new Rectangle(contextLocation != null ? contextLocation : new Point(0, 0), size != null ? size : this.getBorderNodeDefaultSize(port));
        locator.setConstraint(constraint);
        Rectangle dummyBounds = new Rectangle(constraint);
        Point parentAbsoluteLocation = GMFHelper.getAbsoluteLocation(parent, true, false);
        dummyBounds.translate(parentAbsoluteLocation);
        Point realLocation = locator.getValidLocation(dummyBounds, node, Collections.singleton(node));
        Dimension d = realLocation.getDifference(parentAbsoluteLocation);
        Point location = new Point(d.width, d.height);
        realLocation.setLocation(location);
        locator.relocate(node);
        return location;
    }

    public Point getOnBorderPositionFromLayoutData(Node node, LayoutData layoutData) {
        AbstractDNode port = (AbstractDNode)node.getElement();
        Node parent = (Node)node.eContainer();
        Point location = layoutData.getLocation() != null ? layoutData.getLocation() : new Point(0, 0);
        Dimension size = layoutData.getSize();
        CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parent, 29);
        Dimension borderOffsets = IBorderItemOffsets.DEFAULT_OFFSET;
        if (port != null && new DDiagramElementQuery((DDiagramElement)port).isIndirectlyCollapsed()) {
            borderOffsets = IBorderItemOffsets.COLLAPSE_FILTER_OFFSET;
        }
        locator.setBorderItemOffset(borderOffsets);
        Point parentAbsoluteLocation = GMFHelper.getAbsoluteBounds(parent, false, false, false, false).getTopLeft();
        Point realLocation = locator.getValidLocation(new Rectangle(location.getTranslated(parentAbsoluteLocation), size), node, Collections.singleton(node));
        realLocation.translate(parentAbsoluteLocation.negate());
        return realLocation;
    }

    private Dimension getBorderNodeDefaultSize(AbstractDNode abstractDNode) {
        DNode viewNode;
        Dimension defaultSize = new Dimension(-1, -1);
        if (abstractDNode instanceof DNode && !new org.eclipse.sirius.diagram.business.api.query.DNodeQuery(viewNode = (DNode)abstractDNode).isAutoSize()) {
            defaultSize = new DNodeQuery(viewNode).getDefaultDimension();
        }
        return defaultSize;
    }

    public Dimension getAdjustedDimension(Node node, Size size) {
        Dimension result = new Dimension(size.getWidth(), size.getHeight());
        if (this.snapToGrid && this.gridSpacing > 0) {
            int enlargedAxis = 192;
            if (NodePositionHelper.isBorderedNode(node.getElement())) {
                enlargedAxis = 0;
                LayoutConstraint layoutConstraint = node.getLayoutConstraint();
                if (layoutConstraint instanceof Bounds) {
                    Node parent;
                    LayoutConstraint layoutConstraint2;
                    Bounds nodeBounds = (Bounds)layoutConstraint;
                    EObject eObject = node.eContainer();
                    if (eObject instanceof Node && (layoutConstraint2 = (parent = (Node)eObject).getLayoutConstraint()) instanceof Bounds) {
                        Bounds parentBounds = (Bounds)layoutConstraint2;
                        int borderSide = NodePositionHelper.getPortSide(nodeBounds, parentBounds);
                        switch (borderSide) {
                            case 1: 
                            case 4: {
                                enlargedAxis = 64;
                                break;
                            }
                            case 8: 
                            case 16: {
                                enlargedAxis = 128;
                            }
                        }
                    }
                }
            }
            if ((enlargedAxis & 0x40) != 0) {
                result.width = this.extendSizeToGrid(result.width);
            }
            if ((enlargedAxis & 0x80) != 0) {
                result.height = this.extendSizeToGrid(result.height);
            }
        }
        return result;
    }

    private int extendSizeToGrid(int value) {
        if (value == -1) {
            return -1;
        }
        int shift = value % this.gridSpacing;
        int enlarge = 0;
        if (shift != 0) {
            enlarge = this.gridSpacing - shift;
        }
        return value + enlarge;
    }

    public static boolean isBorderedNode(EObject element) {
        AbstractDNode parentDNode;
        EObject eObject;
        return element instanceof DNode && (eObject = element.eContainer()) instanceof AbstractDNode && (parentDNode = (AbstractDNode)eObject).getOwnedBorderedNodes().contains((Object)element);
    }

    public static boolean isTopLevelNode(EObject element) {
        DDiagram dDiagram;
        EObject eObject = element.eContainer();
        return eObject instanceof DDiagram && (dDiagram = (DDiagram)eObject).getOwnedDiagramElements().contains((Object)element);
    }

    public static boolean isInsideNodeContainer(EObject element) {
        DNodeContainer dNodeContainer;
        EObject eObject = element.eContainer();
        return eObject instanceof DNodeContainer && (dNodeContainer = (DNodeContainer)eObject).getOwnedDiagramElements().contains((Object)element);
    }

    private static ResizeKind getNodeResizeKind(Node createdNode) {
        EObject eObject = createdNode.getElement();
        if (eObject instanceof DNode) {
            DNode dNode = (DNode)eObject;
            return dNode.getResizeKind();
        }
        return ResizeKind.NSEW_LITERAL;
    }

    public static boolean canResizeWidth(Node node) {
        ResizeKind kind = NodePositionHelper.getNodeResizeKind(node);
        return kind == ResizeKind.EAST_WEST_LITERAL || kind == ResizeKind.NSEW_LITERAL;
    }

    public static boolean canResizeHeight(Node node) {
        ResizeKind kind = NodePositionHelper.getNodeResizeKind(node);
        return kind == ResizeKind.NORTH_SOUTH_LITERAL || kind == ResizeKind.NSEW_LITERAL;
    }

    private static int getPortSide(Bounds borderNode, Bounds container) {
        if (container.getWidth() == 0) {
            return 8;
        }
        Point center = new Rectangle(borderNode.getX(), borderNode.getY(), borderNode.getWidth(), borderNode.getHeight()).getCenter();
        boolean aboveNwse = NodePositionHelper.isAboveLine(center, container.getHeight(), container.getWidth(), 0);
        boolean aboveSwne = NodePositionHelper.isAboveLine(center, -container.getHeight(), container.getWidth(), container.getHeight());
        if (aboveSwne) {
            return aboveNwse ? 1 : 8;
        }
        return aboveNwse ? 16 : 4;
    }

    private static boolean isAboveLine(Point point, int a, int r, int b) {
        return point.y * r <= a * point.x + b * r;
    }
}

